

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	gmtime.c
*
*	$Log:   /b/gregs/i960/libc/gmtime.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:16   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:23:56   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:18   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:06   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:34   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:10   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:00:58   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	K Kong
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/**
*
*	Program Name:	nim960 bridge
*
*	Filename:	gmtime.c
*
*	Creation Date:	6.10.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This file contains the function to break down 
*			a time value into GMT date/time info. This is to
*			replace the standard lib function gmtime.
*
*	Copyright (c) Hughes LAN Systems 1991
*
**/
#include <types.h>
#include <time.h>

#define DaySec  (24 * 60 * 60L)
#define YearSec (365 * DaySec)
#define DecSec  315532800L      /* secs in 1970-1979 */
#define Day1    4               /* Jan. 1, 1970 was a Thursday */
#define Day180  2               /* Jan. 1, 1980 was a Tuesday */

static int _lpdays[] =
	{
	-1, 30, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365
	};

static int _days[] =
	{
	-1, 30, 58, 89, 119, 150, 180, 211, 242, 272, 303, 333, 364
	};

static struct tm tb;
/*
 * name		gmtime	- convert time to a structure
 *
 * synopsis	struct tm *gmtime(timp)
 *		time_t	*timp; <<	points to the number of seconds
 *					since Jan 1 1970.
 *
 * description	Converts the UNIX style time value to a structure with the
 *		current GMT time in it.
 *
 * returns	pointer to static structure filled in.
 *		If time value is before Jan 01 1980, returns NULL.
 */

struct tm *gmtime(timp)
const time_t *timp;

	{
	long	ac;        /* accumulator */
	register int	*mdays;    /* pointer to days or lpdays */
	register int	lpcnt;     /* leap-year count */

	if (*timp < (long)DecSec)
        	return(NULL);       /* Before 1980; return NULL */
	
	/*
	 * Make 1st try at determining year
	 */
	tb.tm_year = *timp / (long)YearSec;
	ac = (*timp % (long)YearSec) - 
		(lpcnt = (tb.tm_year + 1) / 4) * (long)DaySec;
	/*
	 * Correct for leap-years passed since 1970.  In the previous
	 * calculation, since the lesser value of YearSec was used, (365 days)
	 * for certain dates ac will be < 0 and tm_year will be too high.
	 * (These dates will tend to be near the end of December.)
	 * This is fixed by adding years back into ac until it is >= 0.
	 */
	while (ac < 0)
		{
		ac += (long)YearSec;
		if (!((tb.tm_year + 1) % 4))
			{
			ac += (long)DaySec;
			lpcnt--;
			}
		tb.tm_year--;
		}
	
	/*
	 * See if this is a leap year
	 */
	tb.tm_year += 1970;
	if (!(tb.tm_year % 4) && ((tb.tm_year % 100) || !(tb.tm_year % 400)))
		/* Yes */
		mdays = _lpdays;
	else
		/* No */
		mdays = _days;
	/*
	 *  Put year in proper form.
	 *  Determine yday, month, hour, minute, and second.
	 */
	tb.tm_year -= 1900;
	tb.tm_yday = ac / (long)DaySec;
	ac %= (long)DaySec;
	for (tb.tm_mon = 1; mdays[tb.tm_mon] < tb.tm_yday; tb.tm_mon++)
		continue;
	tb.tm_mday = tb.tm_yday - mdays[--tb.tm_mon];
	tb.tm_hour = ac / 3600;
	ac %= 3600;
	tb.tm_min = ac / 60;
	tb.tm_sec = ac % 60;
	/*
	 * Determine day of week
	 */
	tb.tm_wday = ((tb.tm_year-70)*365 + lpcnt + tb.tm_yday + Day1) % 7;
	
	tb.tm_isdst = 0;
	return((struct tm *) &tb);
	}
