

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	rand.c
*
*	$Log:   /b/gregs/i960/libc/rand.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:30   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:12   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:32   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:28   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:46   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:20   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:08   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include "types.h"
#include "inc.h"
/*
 * rand, srand : random number generators for the 80960.
 *
 * Andy Wilson , 1-Nov-89.
 *
 */

static long __seed = 1L;

int rand()
{
  struct {
    unsigned long lo;
    unsigned long hi;} dword;
  unsigned long mult=1566083941, q;

  /* Computes pseudo-random number modulo 2**31-1
   * (which is a prime number and thus has nice properties).
   * First computes 64-bit result of seed*multiplier.
   * Then finds (result mod 2**31-1) by observing that
   * result = q*(2**31-1) + r   (where r is the value we want, and)
   * result = q*2**31 + r - q
   * low order 31 bits of result = r - q
   * r = low order 31 bits + q
   * (see Knuth, Vol. 2, sec. 3.2.1.3)
   */

  asm volatile ("emul	%2,%1,%0" : "=dG" (dword)   : "d" (__seed),
		                                      "d" (mult));
  asm volatile ("chkbit	31,%0"    :                 : "d" (dword.lo));
  asm volatile ("addc	%1,%1,%0" : "=d" (q)        : "d" (dword.hi));
  __seed = (q + dword.lo) & 0x7fffffffL;
  return((int) __seed);
}

void srand(val)
unsigned val;	
{
	__seed = val;
}
