

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	scanf.c
*
*	$Log:   /b/gregs/i960/libc/scanf.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:30   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:12   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:34   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:30   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:48   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:20   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:10   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/********************************************************
 *
 *	COPYRIGHT (c) 1986 by SYTEK Inc.   (unpublished)
 *		*** ALL RIGHTS RESERVED ***
 *
 *     sscanf functionality
 *
 ********************************************************/

#include <types.h>

#define MAX_PRTF_ARGS 6

/*
 * a hand coded sscanf.  
 */
sscanf(buf, fmt, arg0, arg1, arg2, arg3, arg4, arg5)
register char *buf;	/* character buffer */
register char *fmt;	/* control/matching string */
int  *arg0;
int  *arg1;
int  *arg2;
int  *arg3;
int  *arg4;
int  *arg5;
{
	int *av[MAX_PRTF_ARGS];
	int i = 0;
	int wdth;	/* number of characters width during prints */
	int base;	/* numeric conversion base */
	char argl;	/* arg is long flag */
	char skip;	/* skip assignment flag */
	int cnvrt = 0;	/* number args converted and assigned */
	char *cp;	/* character argument pointer */
	int reverse;	/* reverse the checking in [...] */
	char *endbracket;     /* position of the ] in format string */

	av[0] = arg0;
	av[1] = arg1;
	av[2] = arg2;
	av[3] = arg3;
	av[4] = arg4;
	av[5] = arg5;

	for (; *fmt != 0; fmt++)
	{
		/* format specifies blanks? */
		if (isblank(*fmt))
		{
			while (isblank(*buf))
				buf++;	/* eat any blanks in line */
			continue;	/* next format spec */
		}

		/* format specifies normal letter */
		if (*fmt != '%')
		{
			if (*buf++ != *fmt)
				return cnvrt;
			continue;	/* next format spec */
		}

		/* parse and convert a % spec */
		argl = 2;	/* word argument */
		wdth = 0;	/* no padding yet */
		skip = 0;	/* dont skip assignment */
		base = 0;	/* numeric conversion base */

		while (1)	/* until all of '%' cmd read */
		{
			switch(*++fmt)
			{
			case '*': skip = 1; continue;	/* dont assign value */
			case 'l': argl = 4; continue;	/* long argument */
			case 'h': argl = 1; continue;	/* byte argument */

			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
				wdth = 10 * wdth + *fmt - '0';
				continue;

			case 'B': argl = 4;
			case 'b': base = 2; break;
			case 'O': argl = 4;
			case 'o': base = 8; break;
			case 'D': argl = 4;
			case 'd': base = 10; break;
			case 'X': argl = 4;
			case 'x': base = 16; break;

			case 'c': 
				cp = (char *)av[i];
				if (*buf == 0)
					return cnvrt;
				if (!wdth)
					wdth = 1;
				while (wdth--)
				{
					if (*buf == 0)	/* End of buf */
						break;
					if (!skip)
						*cp++ = *buf++;
					else
						buf++;
				}
				if (!skip)
				{
 					i++;/* next argument pointer */
					cnvrt++;
				}
				break;

			case 's':
				/* drop leading spaces */
				while (isblank(*buf))
					buf++;	/* eat any blanks in line */
				if (*buf == 0)
					return cnvrt;
				cp = (char *)av[i];

				if (!wdth)
					wdth = 0xffff;	/* arbitrarily large */
				while (wdth-- && !isblank(*buf) && *buf != 0)
				{
					if (!skip)
						*cp++ = *buf++;
					else
						buf++;
				}
				if (!skip)
				{
					*cp = 0;/* string delimit */
 					i++;/* next argument pointer */
					cnvrt++;
				}
				break;

			  case '[':
				cp = (char *)av[i];
				if (!wdth)
					wdth = 0xffff;

				if ( *(++fmt) == '^' )
				{
					reverse = 1;
					fmt++;
				}
				else
					reverse = 0;

				endbracket = fmt;
				while ( *endbracket != ']'/*  && *endbracket != '\0'*/)
					endbracket++;

				if (!*endbracket)
					return cnvrt;

				while (wdth-- && (scnindex(*buf, fmt, endbracket) ^ reverse))
				{
					if (!skip)
						*cp++ = (char)*buf++;
					else
						buf++;
				}

				if (!skip)	
				{
					*cp = 0;/* string delimit */
					i++;/* next argument pointer */
					cnvrt++;
				}
				break;

			default: 
				return cnvrt;
			} /* end switch */

			/* numeric conversions */
			if (base)	/* conversion desired */
			{
				if (wdth == 0)
					wdth = 0xffff;	/* arbitrarily large */
				if (argl == 1)
					wdth = sgetnum(buf, wdth, base, skip, av[i]);
				else if (argl == 2)
					wdth = getnum(buf, wdth, base, skip, av[i]);
				else 
					wdth = lgetnum(buf, wdth, base, skip, av[i]);
				if (!wdth)
					return cnvrt;

				if (!skip)
				{
					buf += wdth;
					cnvrt++;
					i++;
				}
			}

			/* all done with this format conversion */
			break;	
		} /* while loop */
	} /* for loop */

	return cnvrt;
} /* end of procedure */


isblank(c)
register char c;
{
	return (c == ' ' || c == '\t' || c == '\r' || c == '\n');
}


sgetnum(buf, width, base, skip, argp)
char *buf;	/* pointer to buffer with numbers */
word width;	/* number characters maximum to read */
word base;	/* conversion base */
int skip;	/* skip assignment flag */
char *argp;	/* where to place scanned number */
{
	register char *b = buf;
	register int v = 0;
	int c;

	if (!isdigit(*b, base, &c))
		return 0;	/* no match */
	do 
		v = base * v + c;
	while (isdigit(*++b, base, &c) && --width);

	if (!skip)
		{
		*argp = v;
		}
	return b - buf;
}


getnum(buf, width, base, skip, argp)
char *buf;	/* pointer to buffer with numbers */
word width;	/* number characters maximum to read */
word base;	/* conversion base */
int skip;	/* skip assignment flag */
int *argp;	/* where to place scanned number */
{
	register char *b = buf;
	register int v = 0;
	int c;
	int negative = 0;

	if (*b == '-')
		{
		negative = 1;
		b++;
		}
	if (!isdigit(*b, base, &c))
		return 0;	/* no match */
	do 
		v = base * v + c;
	while (isdigit(*++b, base, &c) && --width);

	if (!skip)
		{
		if (negative)
			v = 0 - v;
		*argp = v;
		}
	return b - buf;
}



lgetnum(buf, width, base, skip, argp)
char *buf;	/* pointer to buffer with numbers */
word width;	/* number characters maximum to read */
word base;	/* conversion base */
int skip;	/* skip assignment flag */
long *argp;	/* where to place converted value */
{
	register char *b = buf;
	long v = 0;
	int c;
	int negative = 0;

	if (*b == '-')
		{
		negative = 1;
		b++;
		}
	if (!isdigit(*b, base, &c))
		return 0;	/* no match */
	do 
		v = v * base + c;
	while (isdigit(*++b, base, &c) && --width);

	if (!skip)
		{
		if (negative)
			v = 0 - v;
		*argp = v;
		}
	return b - buf;
}


isdigit(c, b, v)
char c;	/* character to be converted */
int b;	/* base converter */
int *v;	/* value of character */
{
	if (b == 2)
	{
		if ('0' <= c && c <= '1')
			{
			*v =  c - '0';
			return 1;
			}
		return 0;
	}
	else if (b == 8)
	{
		if ('0' <= c && c <= '7')
		{
			*v =  c - '0';
			return 1;
		}
		return 0;
	}
	else if (b == 10)
	{
		if ('0' <= c && c <= '9')
		{
			*v =  c - '0';
			return 1;
		}
		return 0;
	}
	else if (b == 16)
	{
		if ('0' <= c && c <= '9')
		{
			*v =  c - '0';
			return 1;
		}
		if ('a' <= c && c <= 'f')
		{
			*v = c - 'a' + 10;
			return 1;
		}
		if ('A' <= c && c <= 'F')
		{
			*v = c - 'A' + 10;
			return 1;
		}
		return 0;
	}
	return 0;
}

static char input_line[160];
scanf(fmt,arg0,arg1,arg2,arg3,arg4,arg5)
{
  
  gets(input_line);
  sscanf(input_line,fmt,arg0,arg1,arg2,arg3,arg4,arg5);
}


scnindex(ch, string, endmarker)
char ch;
char *string, *endmarker;
{
	if(((endmarker - string) == 3) && (string[1] == '-'))
		return ((string[0] <= ch) &&  (ch <= string[2]));
	else
	{
		while (*string++ != ch) 
			if (string >= endmarker)
				return 0;
		return 1;
	}
}

