#include <types.h>
#include <malloc.h>

static Header sbase;
static Header *sfreep = 0;

initsmalloc(start_addr,size)
char *start_addr;
unsigned  size;
{
   sbase.s.marker = 0;
   sbase.s.reserve = 0;
   sbase.s.ptr = (Header *) start_addr;
   sbase.s.size = 0;
   sfreep = (Header *) start_addr;
   sfreep->s.size = size/sizeof(Header);
   sfreep->s.ptr = &sbase;
}

void *smalloc(unsigned int nbytes)
{
   Header *p,*prevp;
   unsigned nunits;

   nunits = (nbytes + sizeof(Header)-1)/sizeof(Header) +1;
   prevp = sfreep;
   for (p = prevp->s.ptr;;prevp = p, p = p->s.ptr) {
      /*** MYDEBUG ***
      printf("\nStatic Size: %x\n", p->s.size);
      ****End****/
      if (p->s.size >= nunits) { /* big enough */
	 if (p->s.size == nunits) /* exactly */
	    prevp->s.ptr = p->s.ptr;
	 else {  /*allocate tail end */
	    p->s.size -= nunits;
	    p += p->s.size;
	    p->s.size = nunits;
	 }
	 sfreep = prevp;
	 return (void*)(p+1);
      }
      if (p == sfreep)	/* wrap around */
      return NULL;
   }
}


void sfree(void *ap)
{
   Header *bp, *p;

   bp = (Header *)ap - 1;
   for (p=sfreep; !(bp > p && bp < p->s.ptr); p = p->s.ptr)
      if (p >= p->s.ptr && (bp > p || bp < p->s.ptr))
	 break;

   if (bp + bp->s.size == p->s.ptr) { /* join to upper */
      bp->s.size += p->s.ptr->s.size;
      bp->s.ptr = p->s.ptr->s.ptr;
   } else
      bp->s.ptr = p->s.ptr;
   if (p + p->s.size == bp) {
      p->s.size += bp->s.size;
      p->s.ptr = bp->s.ptr;
   } else
      p->s.ptr = bp;
   sfreep = p;
}



