

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	strchr.c
*
*	$Log:   /b/gregs/i960/libc/strchr.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:36   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:16   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:38   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:40   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:50   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:22   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:12   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * strchr, strrch : string searching routines.
 * (and non-ANSI variants strpos, strrpos)
 *
 * Notes:  A naive implementation.  Should use the 960
 *         "scanbyte" instruction and be inlined for benchmarking.
 *
 * Andy Wilson, 3-Oct-89.
 */

#undef strchr
#undef strrchr

char *
  strchr(s, c)
const char *s;
int c;
{
  do
    {
      if (*s==c)	/* note that 0 is a valid char to search for */
	return (char *)s;
    }
  while (*s++ != '\0');

  return (char *)0;
}

char *
  strrchr(s, c)
const char *s;
int c;
{
  char *lastc=(char *)0;

  /*
   * are we searching for a null?  if so,
   * this routine is the same as strchr.
   */
  if (c=='\0')
    return strchr(s, c);

  /*
   * If not, walk the string until we find a null,
   * returning a pointer to the last char to match 'c'.
   */
  while (*s != '\0')
    {
      if (*s == c)
	lastc = (char *)s;
      s++;
    }
  return lastc;
}

