

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	strcmp.c
*
*	$Log:   /b/gregs/i960/libc/strcmp.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:36   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:18   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:40   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:40   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:52   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:24   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:14   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include "types.h"
#include "inc.h"

/*
 * strcmp - compare string s1 to s2
 */

#undef strcmp

int				/* <0 for <, 0 for ==, >0 for > */
strcmp(s1, s2)
CONST register char *s1;
CONST register char *s2;
{
  register int ch1, ch2;
  
  /*
   * [atw] try to avoid dereferencing a null pointer.
   */
  
  if (s1==s2)
    return 0;	/* strings are equal if same object. */
  else if (s1==0)
    return -1;
  else if (s2==0)
    return 1;

  do
  {
    ch1 = *s1;
	ch2 = *s2;
    s1++;		/* fill delay slot waiting for loads to complete */
    s2++;
  } while (ch1 != 0 && ch1 == ch2);


  return(ch1 - ch2);
}
