

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	strstr.c
*
*	$Log:   /b/gregs/i960/libc/strstr.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:46   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:30   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:52   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:56   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:48:04   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:32   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:22   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include "types.h"
#include "inc.h"

/*
 * strstr - find first occurrence of wanted in s
 */
#ifdef NULL
#undef NULL
#endif

#define	NULL	0

#undef strstr

char *				/* found string, or NULL if none */
strstr(s, wanted)
CONST char *s;
CONST char *wanted;
{
	register CONST char *scan;
	register SIZET len;
	register char firstc;
	extern int strcmp();
	extern SIZET strlen();

	/*
	 * The odd placement of the two tests is so "" is findable.
	 * Also, we inline the first char for speed.
	 * The ++ on scan has been moved down for optimization.
	 */
	firstc = *wanted;
	if (firstc == 0)
	  return (char *)s;	/* as per ANSI */
	len = strlen(wanted);
	for (scan = s; *scan != firstc || strncmp(scan, wanted, len) != 0; )
		if (*scan++ == '\0')
			return(NULL);
	return((char *)scan);
}
