/**
 *	Program Name:	nim960 program
 *
 *	Filename:	askdate.c
 *
 *	$Log:   /b/gregs/i960/libutil/askdate.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:35:22   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:24:58   franks
 * No change.
 * 
 *    Rev 1.1   10 Sep 1993 15:25:24   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:46:22   franks
 * Initial revision.
 * 
 *    Rev 1.0   08 Apr 1992 09:39:20   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
extern	char	*EntryInvalidMsg;
extern	char	*SyntaxErrorMsg;

static char	*MonthTable[] =
		{
		"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
		"Aug", "Sep", "Oct", "Nov", "Dec"
		};

/*
 *	AskDate	- ask the user to enter the month and year
 *	Date: 	bit 0 - bit 3 is the month (0 - 11 for Jan to Dec)
 *		bit 4 - bit 7 is the year offset from 1990 (0 for 1990)
 */
AskDate(char *prompt, unsigned date)

	{
	int	month;
	int	year;
	char	c; 	/* dummy for check user input	*/
	char	buffer[80];
	int	argc;

	for (;;)
		{
		month = (date & 0x0f);
		if (month > 11)
			month = 0;
		year = (date >> 4) & 0x0f;
		printf("%s (%d.%d for %s %d) ==>", prompt, month + 1, year + 1990, 
			MonthTable[month], year + 1990);
		gets(buffer);
		if ((argc = sscanf(buffer, "%d.%d%c", &month, &year, &c)) == 2)
			{
			if (1 <= month && month <= 12 && 
				1990 <= year && year <= 2006)
				break;
			else
				{
				printf(EntryInvalidMsg);
				continue;
				}
			}
		else if (argc == 0 && buffer[0] == '\0')
			return date;	/* enter has been pressed	*/
		printf(SyntaxErrorMsg);
		}
	return ((year - 1990) << 4) | (month - 1);
	}


