/**
 *	Program Name:	nim960 program
 *
 *	Filename:	askip.c
 *
 *	$Log:   /b/gregs/i960/libutil/askip.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:35:26   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:25:00   franks
 * No change.
 * 
 *    Rev 1.1   10 Sep 1993 15:25:26   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:46:26   franks
 * Initial revision.
 * 
 *    Rev 1.0   08 Apr 1992 09:39:24   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
#include <types.h>

extern	char	*EntryInvalidMsg;
extern	char	*SyntaxErrorMsg;

/*
 * name		AskIP	- ask the user to enter an ip address
 *
 * synopsis	AskIP(message, ip)
 *		char	*message; <<	displayed to prompt the user
 *		in_name	*ip;>>		the ip address entered by the user
 *					will be returned in here.
 *
 * description	It displays the "message" to prompt the user to enter
 *		an ip address in the format of (dd.dd.dd.dd).  The
 *		ip address will be retured in "ip", which is ready to 
 *		be used without any further formating. The default value
 *		of ip will be displayed and if the user press ENTER,
 *		no new ip will be returned.
 *
 * returns	nothing
 */

void AskIP(char *message, in_name *ip)

	{
	uint	ip0;	/*	First byte of ip	*/
	uint	ip1;	/* 	Second byte of ip	*/
	uint	ip2;	/*	Third byte of ip	*/
	uint	ip3;	/*	Forth byte of ip	*/
	uint	tmp;
	byte	*p = (byte *)ip;
	int	argc;
	char	buffer[80];

	for (;;)
		{
		printf("%s (%d.%d.%d.%d) ==>", message, *p, *(p + 1),
			*(p + 2), *(p + 3));
		gets(buffer);
		if ((argc = sscanf(buffer, "%d.%d.%d.%d%c", 
			&ip0, &ip1, &ip2, &ip3, &tmp)) == 4)
			{
			if (ip0 < 256 && ip1 < 256 && ip2 < 256 && ip3 < 256)
				{
				*p++ = (byte)ip0;
				*p++ = (byte)ip1;
				*p++ = (byte)ip2;
				*p++ = (byte)ip3;
				break;
				}
			else
				{
				printf(EntryInvalidMsg);
				continue;
				}
			}
		else if (argc == 0 && buffer[0] == '\0')
			break;
		printf(SyntaxErrorMsg);
		}
	}

