

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	debugasm.s
*
*	$Log:   /b/gregs/i960/newdebug/debugasm.s_v  $
   
      Rev 1.3   12 Oct 1993 10:36:26   franks
   No change.
   
      Rev 1.2   29 Sep 1993 10:25:44   franks
   No change.
   
      Rev 1.1   10 Sep 1993 15:26:12   franks
   No change.
   
      Rev 1.0   08 Sep 1993 12:53:06   franks
   Initial revision.
   
      Rev 1.1   13 May 1992 12:05:00   suresh
   Aligned the routines to 16 byte boundary.
   
      Rev 1.0   30 Mar 1992 16:54:48   pvcs
   Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

	.globl	_load_byte
	.globl	_load_long
	.globl	_load_triple
	.globl	_load_quad
	.globl	_store_byte
	.globl	_store_quick_byte
	.globl	_store_long
	.globl	_store_triple
	.globl	_store_quad

	.align	4
_load_byte:
	ldob	(g0), r4
	mov	r4, g0
	ret

	.align	4
_load_long:
	ldl	(g0), r4
	stl	r4, (_long_data)
	ret

	.align	4
_load_triple:
	ldt	(g0), r4
	stt	r4, (_long_data)
	ret

	.align	4
_load_quad:
	ldq	(g0), r4
	stq	r4, (_long_data)
	ret

	.align	4
_store_quick_byte:
	stob	g0, (g1)
	ret

	.align	4
_store_byte:
	stob	g0, (g1)
	ldconst 0, g0
	call	_eat_time
	ret

	.align	4
_store_long:
	mov	g0, r4
	mov	g0, r5
	stl	r4, (g1)
	ret

	.align	4
_store_triple:
	mov	g0, r4
	mov	g0, r5
	mov	g0, r6
	stt	r4, (g1)
	ret

	.align	4
_store_quad:
	mov	g0, r4
	mov	g0, r5
	mov	g0, r6
	mov	g0, r7
	stq	r4, (g1)
	ret

