

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	help.c
*
*	$Log:   /b/gregs/i960/newdebug/dhelp.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 10:36:26   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:25:46   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:26:14   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 12:55:24   franks
 * No change.
 * 
 *    Rev 1.0   05 Apr 1993 17:27:46   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 16:54:46   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/


#include <dbdefines.h>

static const char
help_all1[] =
	".                - repeat previous command\n"
	"? [cmd]          - help info for optional cmd\n"
	"bd [address]     - set data breakpoint. If no address is given,\n"
        "                   all current breakpoints are displayed\n"
	"br [address]     - set instruction break. If no address is given,\n"
        "                   all current breakpoints are displayed\n"
	"da address#times - disassemble one or more instructions\n"
	"de address       - delete the specified instruction breakpoint\n"
	"db address#bytes - display one or more bytes\n"
	"dd address#times - display one or more sets of double words\n"
	"di address#words - display one or more words\n"
	"di reg           - display the contents of the register 'reg'\n"
	"dq address#times - display one or more sets of quad words\n"
	"ds address#shrts - display one or more shorts\n"
	;

static const char
help_all2[] =
	"dt address#times - display one or more sets of triple words\n"
	"ed address       - delete the specified data breakpoint\n"
	"fi address address data - fill memory with data value\n"
	"go [address]     - go from start, or continue from breakpoint\n"
	"he [cmd]         - help info for optional cmd\n"
	"mb address       - modify a byte in memory (doesn't read byte first)\n"
	"mo reg           - modify a register. Reg can NOT be fp0-fp3,\n"
	"mo address#words - modify one or more words in memory\n"
	"re               - dump contents of registers\n"
	"rs               - reset board\n"
	"sh [count]       - stack history\n"
	"st [address]     - single step through program\n"
	"tr option on/off - turn on or off one of the following trace options\n"
        "                   branch, call, return or supervisor call\n"
	"ve               - print out version header\n"
	;

static const char
dot_help[] =
	".\n"
	"  Repeat previous command.\n";

static const char
ba_help[] =
	"ba[ud] <rate>\n\n"
	"  Change the current baud rate to the one given.\n"
	"  Choices are:  1200 2400 4800 9600 19200 38400\n";

static const char
bd_help[] =
	"bd [<address>]\n\n"
	"  Set data breakpoint at the address given.  This only applies\n"
	"  to 80960Cx versions which have hardware data breakpoints.  If\n"
	"  no address is given all of the current data breakpoints are\n"
	"  displayed.  To delete a data breakpoint use the 'ed' command.\n";

static const char
br_help[] =
	"br[eak] <address>\n\n"
	"  Set instruction break. If no address is given, all of the\n"
	"  current instruction breakpoints are displayed.  To delete an\n"
	"  instruction breakpoint, use the 'de' command.\n";

static const char
cf_help[] =
	"cf\n\n"
	"  Check if Flash is blank.  If not blank, prints out a message\n"
	"  stating the first and last addresses at which it is\n"
	"  programmed and the total size of the Flash EPROMs.\n";

static const char
da_help[] =
	"da[sm] [<address>][#<words>]\n\n"
	"  Disassemble an instruction beginning at the address given.\n"
	"  If no address is given, the current instruction pointer is used.\n";

static const char
db_help[] =
	"db <address>[#<bytes>]\n\n"
	"  Display one or more bytes beginning at the address given.\n"
	"  Also displays bytes as ASCII characters if printable.\n";

static const char
dd_help[] =
	"dd <address>[#<times>]\n\n"
	"  Display one or more sets of double words at the address\n"
	"  given. Note that this command invokes a two-word burst fetch\n"
	"  on the 80960 burst bus.\n";

static const char
de_help[] =
	"de[lete] <address>\n\n"
	"  Delete the specified instruction breakpoint.\n";

static const char
df_help[] =
	"df\n\n"
	"  Download to Flash EPROMs using Xmodem.  Fatal error messages\n"
	"  will be printed out if the Flash EPROM will no longer program.\n"
	"  The option does NOT erase Flash first before downloading.\n"
	"  This allows multiple programs to be fit into Flash address space.\n";

static const char
di_help[] =
	"di[splay] <address>[#<words>]\n\n"
	"  Display a whole word beginning at the address given.\n"
	"di[splay] <register>\n\n"
	"  Display one register, where register can be any register.\n";

static const char
do_help[] =
	"do[ownload]\n\n"
	"  Download using Xmodem.  If downloading to Flash, this will\n"
	"  automatically erase Flash first.\n";

static const char
dq_help[] =
	"dq address[#times]\n\n"
	"  Display one or more sets of quad words beginning at the address\n"
	"  given. Note that this command invokes a four-word burst fetch on\n"
	"  the 80960 burst bus.\n";

static const char
ds_help[] =
	"ds <address>[#<shorts>]\n\n"
	"  Display one or more shorts beginning at the address given.\n";

static const char
dt_help[] =
	"dt <address>[#<times>]\n\n"
	"  Display one or more sets of triple words beginning at the address\n"
	"  given.  Note that this command invokes a three-word burst fetch\n"
	"  on the 80960 burst bus.\n";

static const char
ed_help[] =
	"ed <address>\n\n"
	"  Erase the specified data breakpoint.";

static const char
ef_help[] =
	"ef\n\n"
	"  Erase Flash EPROM.  Error messages will be printed\n"
	"  if the Flash will no longer erase.\n";

static const char
fi_help[] =
	"fi[ll] <address1> <address2> <data>\n\n"
	"  Fill memory from address1 to address2 inclusive with word of data value.\n"
	"  If address1 = address2 then one word is filled at address1\n";

static const char
fl_help[] =
	"fl[oat] <address>[#<times>]\n\n"
	"  Display one or more long real (64 bit) floating point numbers\n"
	"  beginning at the address given.\n";

static const char
fr_help[] =
	"fr <address>[#<times>]\n\n"
	"  Display one or more real (32 bit) floating point numbers beginning\n"
	"  at the address given.\n";

static const char
fx_help[] =
	"fx <address>[#<times>]\n\n"
	"  Display one or more extended real (80 bit) floating point numbers\n"
	"  beginning at the address given.\n";

static const char
go_help[] =
	"go [<address>]\n\n"
	"  Begins execution of program at address given.  If no address\n"
	"  is given the default is read from information in the downloaded\n"
	"  file or the current IP is used.  Also used as a continue from\n"
	"  breakpoint.\n";

static const char
he_help[] =
	"he[lp] [<command>]\n"
	"? [<command>]\n"
	"  Gives help for optional 'command'.  If no 'command' is specified\n"
	"  or unknown 'command', print short version of all commands.\n";

static const char
mb_help[] =
	"mb <address>\n\n"
	"  Modify a byte in memory (does not read byte first).\n";

static const char
mo_help[] =
	"mo[dify] <register>\n\n"
	"  Modify a register. r4).\n"
	"  NOTE: be careful when modifying the fp, pfp, sp, pc, ac, or tc.\n"
	"  ALSO NOTE: the register set is invalid until after the\n"
	"  application program has begun execution.\n"
	"\nmo[dify] <address>[#<words>]\n\n"
	"  Modify one or more words in memory.\n";

static const char
re_help[] =
	"re[gisters]\n\n"
	"  Dump contents of registers.\n";

static const char
rs_help[] =
	"rs\n\n"
	"  Reset the board.\n";

static const char
sh_help[] =
	"sh[istory] [<count>]\n\n"
	"  Stack history.\n"
	"  It displays the pfp, sp and rip of the previous <count> stack frames.\n";

static const char
st_help[] =
	"st[ep] [<address>]\n\n"
	"  Single step through program.  NOTE: the address of the breakpoint\n"
	"  is the address of the instruction which has JUST FINISHED EXECUTING.\n"
	"  The RIP and IP will contain the instruction to be executed.\n";

static const char
tr_help[] =
	"tr[ace] [br|ca|re|su [on|off]]\n\n"
	"  Turn on or off one of the following trace options: br[anch],\n"
	"  ca[ll], re[turn] or su[pervisor].  If on/off is not given, the\n"
	"  status of that option is displayed.\n";


static const char
ve_help[] =
	"ve[rsion]\n\n"
	"  Print out version header.\n";

static const char *
help_table[] = {
	ba_help, bd_help, br_help, cf_help, da_help,  db_help, dd_help,
	de_help, df_help, di_help, do_help, dot_help, dq_help, ds_help,
	dt_help, ed_help, ef_help, fi_help, fl_help,  fr_help, fx_help,
	go_help, he_help, mb_help, mo_help, re_help,  rs_help, sh_help,
	st_help, tr_help, ve_help,
	NULL
};


/************************************************/
/* Look up a command in the command table	*/
/************************************************/
static
char *
lookup_help( cmd )
char *cmd;
{
const char **p;

	for ( p = help_table; *p != NULL; p++ ){
		if ( !strncmp(cmd,*p,strlen(cmd)) ){
			return (char *) *p;
		}
	}
	return NULL;
}

/************************************************/
/* Help                         		*/
/*                           			*/
/************************************************/
void
help(dummy, nargs, cmdname)
int dummy;	/* Ignored */
int nargs;	/* Number of the following arguments that are valid */
char * cmdname;
{
	const char *p;

	dprintf("\n");
	if ( (nargs > 0) && (p=lookup_help(cmdname)) != NULL ){
		dprintf(p );
	} else {
		dprintf("Available commands are:\n%s", help_all1 );
		dprintf(" Hit SPACE to continue (or q to quit)\r");
		if (uartgetc() != 'q'){
			dprintf(help_all2);
		}
	}
}
