

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	faultasm.s
*
*	$Log:   /b/gregs/i960/system/faultasm.s_v  $
   
      Rev 1.4   12 Oct 1993 10:37:18   franks
   No change.
   
      Rev 1.3   29 Sep 1993 10:26:26   franks
   No change.
   
      Rev 1.2   10 Sep 1993 15:26:46   franks
   No change.
   
      Rev 1.1   08 Sep 1993 13:13:38   franks
   No change.
   
      Rev 1.0   14 Jul 1993 10:26:26   gregs
   Initial revision.
   
      Rev 1.1   14 May 1992 10:28:06   suresh
   Aligned the routines to 16 byte boundary.
   
      Rev 1.0   30 Mar 1992 17:05:02   pvcs
   Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

/* Offsets into '_register_set' array of some important register values
 *		UPDATE 'regs.h' IF THESE CHANGE!
 */
	.set	REG_R0,0
	.set	REG_SP,4
	.set	REG_G0,64
	.set	REG_G4,80
	.set	REG_G8,96
	.set	REG_G12,112
	.set	REG_FP,124
	.set	REG_RIP,8
	.set	REG_PC,128
	.set	REG_AC,132
	.set	REG_IP,136
	.set	REG_TC,140


/***********************************************************************
 * Switch Stack On Fault					
 *
 * This code is the first code invoked from the fault
 * procedure table.  It switches stacks from the application's
 * stack to the NINDY stack, then calls the C-level fault
 * handler to service the fault.  The stack switch keeps
 * NINDY from being intrusive on the user's stack space.
 *
 * The following is done:	
 *			
 *   1)	All global/local registers at the time of the fault
 *	are copied into a global structure.  This structure
 *	is an array of 36 unsigned ints, which will then
 *	contain g0-g15, r0-r15, ac, pc, tc, and ip.
 *
 *   2)	If the fault occurred on the user stack, the fault record
 *	is copied to the NINDY stack and the stacks are switched.
 *
 *   3)	A C-level routine is called to analyze and report the type
 *	of fault.  It will then call the monitor.  The monitor will
 *	eventually (re)start the user program up via a call to _run_user,
 *	also in this file, which will do a return from fault.  Hence,
 *	there is no return to this code.  This also means that the
 *	monitor can be restarted from the beginning of the NINDY stack
 *	each time it is invoked.
 *
 * On entry the user stack appears as follows:
 *
 *		    USER STACK
 *	  pfp ->+-----------------+ (LOWER MEMORY)
 *		| faulting        |
 *		|    frame        |
 *	fp-64 ->+-----------------+<- fault info starts here
 *		| resumption      |
 *		| record          |
 *		|- - - - - - - - -|
 *		| fault record	  |
 *	   fp ->+-----------------+
 *		| this procedure  |
 *		|                 |
 *		+-----------------+ (HIGHER MEMORY)
 *
 * The fault data is copied over to the NINDY stack, and
 * the current stack is switched:
 *
 *		    NINDY STACK
 *	 	+-----------------+ (LOWER MEMORY)
 *		| fault info      |
 *		|                 |
 *	   fp ->+-----------------+
 *		| this            |
 *		| procedure       |
 *	   sp ->+-----------------+ 
 *		| subsequent      |
 *		| routine's frame |
 		| goes here       |
 *		+-----------------+ (HIGHER MEMORY)
 *
 **********************************************************************/ 

	.globl _fault
	.align  4
_fault:
	/*
	 * Set max priority in case of interrupts,
	 * disable trace faults while within monitor.
	 */
	ldconst	0x001f0000, r8	/* load pc data        */
	ldconst	0x001f0001, r9	/* load pc mask        */
	modpc	r8, r9, r8

	flushreg		/* make stack current  */

	/*
	 * Store user's global registers, set g14 = 0 for C compiler
	 */

	ldconst	_register_set, r5
	stq 	g0, REG_G0(r5)
	stq	g4, REG_G4(r5)	
	stq	g8, REG_G8(r5)	
	stq	g12, REG_G12(r5)
	ldconst 0, g14

	/*
	 * Disable Watch Dog Timer 
	 */
	call	_disable_wdt

	/*
	 * Save user's frame pointer and local registers
	 */

	lda	REG_R0(r5), g0
	andnot	0xf, pfp, g1	/* g0 = pfp w/o return bits */
	st	g1, REG_FP(r5)	/* store "real" frame ptr*/
	call	copyframe

	/*
	 * get pc/ac/ip from fault data
	 */

	ldq	-16(fp), r8
	st	r8, REG_PC(r5)	/* store pc */
	st	r9, REG_AC(r5)	/* store ac */
	st	r11, REG_IP(r5)	/* store ip */

	/*
	 * Switch stacks if not nested fault (i.e., fault
	 * while within monitor).
	 */

	lda	_fault_cnt, r15	# increment fault count
	atadd	r15, 1, r8	
	cmpibne	0, r8, endif 	# if original count was not 0 (not nested fault)
	lda	_debug_stack,g0	#   Move fault record to NINDY stack
	lda	-64(fp), g1	#   .
	call	copyframe	#   .
	lda	64(g0), g0	#   change our fp (+64 steps past fault record)
	call	change_fp	#   . (updates sp too)
endif:				# endif

	/*
	 * Turn off trace while in monitor.
	 * Store user register tc directly.
	 */
	ldconst	0x0ffe00fe, r13	# trace mask
	ldconst	0, r14		# all traces off
	modtc	r13, r14, r14	# leaves user's tc in r14
	st	r14, REG_TC(r5)

	/*
	 * Call C-level fault handler to identify fault type
	 * and invoke the monitor.
	 */

	lda	-48(fp), g0	/* pass fault data */
	call	_fault_handler
	/******* NO RETURN *******/

	ret

/***********************************************************************
 * _run_user:
 *	This is the routine that is actually used to turn control over
 *	(or return control) to the user.  The user's registers are
 *	restored from the global arrays.  Then the fault record with
 *	which the monitor was entered is copied to just above our
 *	frame pointer (we know we can find it at the beginning, i.e.,
 *	lowest address, of the NINDY stack).  The user's pc and ac
 *	register values are placed into this contrived fault record
 *	and a return from fault is performed.
 *
 *	ASSUMPTIONS:
 *	    Floating point registers have already been restored.
 *	    User registers pc/tc/ac have already been modified, if necessary,
 *		for single-step.
 *
 **********************************************************************/ 

	.globl	_run_user
	.align  4
_run_user:

	/*
	 * Enable Watch Dog Timer 
	 */
	call	_enable_wdt

	/*
	/*
	 * Restore local registers to application's stack frame
	 */

	flushreg		/* Make stack current, invalidate stack frame*/
	lda	_register_set,r5/* r5 -> saved values of registers */
	ld	REG_FP(r5), g0	/* g0 -> user's frame		*/
	lda	REG_R0(r5), g1	/* g1 -> stored registers	*/
	call	copyframe

	/*
	 * Copy the user ip into the rip on the user
	 * stack frame, so execution will resume there.
	 *
	 * Using our rip as an intermediate register causes it to
	 * hold the same value as is stored in the caller's frame,
	 * which works around a bug in the A-step 80960CA.
	 */

	ld	REG_IP(r5), rip
	st	rip, REG_RIP(g0)

	/*
	 * Copy fault record from beginning of NINDY stack just above
	 * our fp, so we can do a "return from fault" to the user.
	 */

	lda	-64(fp), g0
	lda	_debug_stack, g1
	call	copyframe

	/*
	 * Restore PC, AC into fault record
	 */

	ld	REG_PC(r5), r9
	st	r9, -16(fp)
	ld	REG_AC(r5), r9
	st	r9, -12(fp)

	/*
	 * Restore global registers directly
	 *
	 * Note that g15 is the frame pointer(fp).  DON'T load
	 * g15 directly:  the user's fp will be restored out of
	 * our pfp, so load it there.  In the process, set the
	 * return type bits (bits 0-3) to indicate a return from
	 * fault.
	 */

	ldq	REG_G0(r5), g0	/* load g0-g3			*/
	ldq	REG_G4(r5), g4	/* load g4-g7			*/
	ldq	REG_G8(r5), g8	/* load g8-g11			*/
	ldt	REG_G12(r5), g12/* load g12-g14			*/
	ld	REG_FP(r5), pfp	/* set pfp to user's fp...	*/
	modify	0xf, 1, pfp	/* ...with return type == fault	*/

	/* 
	 * Restore TC directly
	 */

	ld	REG_TC(r5), r14	/* load program trace	*/
	ldconst	0xff01ffff, r7	/* clear event flags	*/
	and	r7, r14, r14	/* .			*/
	ldconst	0x0ffe00fe, r7	/* load TC mask		*/
	modtc	r7, r14, r14	/* set trace controls	*/

	/*
	 * Decrement fault nesting count
	 */

	lda	_fault_cnt, r5
	ldconst	-1, r6
	atadd	r5, r6, r8

	ret			/* return to application */


/*********************************************************************
 * change_fp:
 *	This routine actually swaps the fault handler's stack, by
 *	copying its frame to the new stack, changing the pfp to point
 *	to the copied frame, and returning to it.
 *
 *	It's necessary to do this as a subroutine, because on the KX a
 *	routine cannot it's own frame:  it will pass the modified
 *	frame pointer on to the called routine (as its pfp), but it will
 *	store its registers to the address the fp contained on entry
 *	(because it caches its own fp).
 *
 *	In any case, a subroutine is better because it is the only way to
 *	modify both the fp and sp atomically.  (Otherwise, an interrupt could
 *	leave us with only the fp modified.)
 *
 *	ASSUMPTIONS:
 *	    The lower bits of pfp will be 0 (invoked via local call only).
 *
 *	PARAMETERS:
 *	    g0 = new value of frame pointer
 *********************************************************************/
	.align  4
change_fp:
	flushreg

	/* Move copies of 16 registers from old frame to new one
	 *	Note pfp -> old (caller's) frame.
	 */
	mov	pfp, g1
	call	copyframe

	/* Point pfp at new frame on new stack
	 */
	mov	g0, pfp

	/* Set caller's sp to be 64 beyond his (new) fp
	 */
	lda	64(pfp),r5
	st	r5,REG_SP(pfp)	# save new sp into new stack frame

	ret


/*******************************************************************
 * copyframe:
 *	Copies 16 quad words.
 *	This routine does not modify any of its caller's registers.
 *
 * 	PARAMETERS:
 *	    g0 = dest   (assumed quad-word aligned)
 *	    g1 = source (assumed quad-word aligned)
 *******************************************************************/
	.align  4
copyframe:
	ldq 	(g1), r4
	stq 	r4, (g0)

	ldq 	16(g1), r4
	stq 	r4, 16(g0)

	ldq 	32(g1), r4
	stq 	r4, 32(g0)

	ldq 	48(g1), r4
	stq 	r4, 48(g0)

	ret

	.globl _enter_debug
	.align  4
 _enter_debug:
	ldconst 64, r4
	addo sp, r4, sp

	ldconst	0x00000000, r8	/* load pc data        */
	ldconst	0x00000000, r9	/* load pc mask        */
	modpc	r8, r9, r8
	st	r8, -16(sp)

	ldconst	0x00000000, r8	/* load pc data        */
	ldconst	0x00000000, r9	/* load pc mask        */
	modac	r8, r9, r8
	st	r8, -12(sp)

	lda	0x00010000, r8
	st	r8, -8(sp)

	lda	fault_ret, r8
	st	r8, -4(sp)

	callx _fault
fault_ret:
	ret
