/**			       
*
*	Program Name:	IP Transmit 
*
*	Filename:	et_send.c
*
*	$Log:   /b/gregs/i960/tcpip/drv/et_send.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:39:48   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:28:38   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:55:26   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:13:48   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 May 1992 10:06:46   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:21:02   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		8.12.91
*
*	Version:	1.1
*
*	Programmers:	
*
*	Modifications:	1.1	K Kong	8.12.91
*			Adding the parameter "srcip" in et_ip_send() such
*			that we can support slip in the terminal server.
*			With slip support, the source ip is no longer just
*			me. It can be one of the slip port.
*
*	Comments:	Port to i960 platform.
*			Replaced all unsigned, unsword, unsigned by ushort.
*			lword by ulong.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
/*
Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/

#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <lme.h>
#include <ether.h>

extern IF_ENTRY *ifcntrs;
extern	int	NumberOfSonicPort;
extern	int	PortList2Num(int);

static void PutMacHeader(PACKET packet, NID *np);
static int AllPortsList(int NumberOfPorts);


/* the ethernet IP protocol transmit routine */
et_ip_send(p, len, host, np, srcip)
register PACKET p;
int	len;
in_name	host;
NID	*np;
in_name	srcip;	/* use this as the sender ip	*/

	{
	int	c;
	int	PortList;	/* which port	*/
	int	PortMask;
	PACKET	packet;
	int	PacketOk = 0;	/* how many packets have been sent out ok */
	int	RetCode;
	int	sv_end_port_list;	/* 
					 *	SV_MAX_PORT << 1	
					 *	i.e if max port = 4, 
					 *	sv_end_port_list = 0x10
					 */

	p->db_actcnt = len;
	/* translate IP to IEEE address and get packet format */
	if (np == NULL)
		{
		if (c = ip2et(&np, &p->nb_flags, host, srcip, &PortList))
			{
			return c;
			}
		p->db_xmtportlist = PortList;
		/*
		 *	Prepend the mac header to the packet
		 */
		PutMacHeader(p, np);
		return nim_xmt(p, p->db_actcnt);
		}
	/*
	 *	We do not know which port to send to,
	 *	we send it to all the ports and make myself to
	 *	attach to the last port number.
	 */
	if (p->db_xmtportlist == 0)
		{
		/*
		 *	AllPortsList(NumberOfSonicPort) is SV_ALL_PORTS
		 *	1 << (NumberOfSonicPort - 1) is SV_MAX_PORT
		 */
		p->db_xmtportlist = AllPortsList(NumberOfSonicPort+1);
		PortList = 1 << ((NumberOfSonicPort+1) - 1);
		}
	else
		{
		/*
		 *	pick the last port number as my unique
		 *	port number.
		 *	i.e. PortMask = SV_MAX_PORT
		 */
		for (PortMask = 1 << ((NumberOfSonicPort+1) - 1); 
			PortMask != 0; PortMask >>= 1)
			{
			if ((PortMask & p->db_xmtportlist) != 0)
				{
				PortList = PortMask;
				break;
				}
			}
		}
	sv_end_port_list = 1 << (NumberOfSonicPort+1);
	for (PortMask = 1; PortMask < sv_end_port_list; PortMask <<= 1)
		{
		if ((PortMask & p->db_xmtportlist) == 0)
			{
			/*
			 *	We don't have to send out on this port
			 */
			 continue;
			 }
		/*
		 *	We have to create our own buffer if
		 *	the original packet is not meant for this
		 *	port.
		 */
		if (PortMask != PortList)
			{
			/*
			 *	It's ok to run out of buffer
			 */
			if ((packet = (PACKET)getfree()) == NULL)
				continue;
			/*
			 *	Copy the packet
			 */
			packet->nb_prot = packet->db_buffer + 
					(p->nb_prot - p->db_buffer);
			memcpy(packet->nb_prot, p->nb_prot, len);
			packet->nb_flags = p->nb_flags;
			}
		else
			packet = p;
		packet->db_actcnt = len;
		packet->db_xmtportlist = PortMask;
		PutMacHeader(packet, np);
		if ((RetCode = nim_xmt(packet, packet->db_actcnt)) == 0)
			PacketOk++;
		if (packet != p)
			putfree(packet);
		}	
	/*
	 *	return ok if we can send on at least one of the port
	 */
	return PacketOk != 0 ? 0 : RetCode;
	}


static void PutMacHeader(PACKET packet, NID *np)

	{
	struct ieeehdr	*pi;
	struct ethhdr	*pe;
	
	if (packet->nb_flags & PKT_IEEEHDR)
		{
		pi = (struct ieeehdr *)(packet->nb_prot - IEEESIZ);
			/* set ethernet mac fields: dst src len */
		packet->db_actcnt += IEEESIZ;
		ncopy(pi->i_dst, np);
		ncopy(pi->i_src, MyNid(PortList2Num(packet->db_xmtportlist)));
		pi->i_size = htons(packet->db_actcnt - ETHRSIZ);
	
		/* set LLC fields: snap auth=DOD type */
		pi->i_snp0 = IEEESNP0;
		pi->i_snp2 = IEEESNP2;
		pi->i_dod0 = IEEEDOD0;
		pi->i_dod1 = IEEEDOD1;
		pi->i_type = ET_IP;  
		packet->db_indent = ((byte *)pi) - packet->db_buffer;
		}
	else	/* normal ether header */
		{
		pe = (struct ethhdr *) (packet->nb_prot - ETHRSIZ);
		/* set ethernet mac fields: dst src type */
		packet->db_actcnt += ETHRSIZ;
		ncopy(pe->e_dst, np);
		ncopy(pe->e_src, MyNid(PortList2Num(packet->db_xmtportlist)));
		pe->e_type = ET_IP;  
		packet->db_indent = ((byte *)pe) - packet->db_buffer;
		}
	}
/*
 *	convert number of ports to the port list.
 *	i.e. 
 *	NumberOfPorts	return
 *	1		0x01
 *	2		0x03
 *	3		0x07
 *	4		0x0f
 *	etc	.....
 */
static int AllPortsList(int NumberOfPorts)

	{
	int	PortList = 0;

	while (NumberOfPorts--)
		{
		PortList |= (1 << NumberOfPorts);
		}
	return PortList;
	}
