/**			       
*
*	Program Name:	ICMP Functions 
*
*	Filename:	icmp.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/icmp.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:22   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:48   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:00   gregs
 * Initial revision.
 * 
 *    Rev 1.2   17 Jun 1992 13:10:10   vinay
 * Removed Errorlog function
 * 
 *    Rev 1.1   13 May 1992 10:12:40   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:22:40   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.1
*
*	Programmers:	
*
*	Modifications:	3.25.91	K Kong
*			Don't manipulate ip address directly
*			from the packet buffer.  The ip address
*			may not be properly aligned.  We have to 
*			copy out the ip address first.
*
*			Ramki 2-13-92
*			Made changes to handle local host address
**
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
Copyright (C) 1986,1987 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <tcpip.h>
#include <task.h>
#include <netbuf.h>
#include <ether.h>
#include <icmp.h>
#include <udp.h>
#include <mtcp.h>
#include <ip.h>
#include <error.h>
#include "redirtab.h"
#include "internal.h"

/* 7/4/84 - fixed bug where IcEchoRequest() didn't free its packet if
	it couldn't allocate a timer.	<John Romkey>
   10/2/84 - changed random() to rand() in the new I/O library.
					<John Romkey>
   12/10/85 - added missing parentheses around multiple debug test for
        bad echo reply seq #.  (was printing with debug switches off.)
					<J. H. Saltzer>
   22-Aug-87	fixed destination unreachable routine to use memcpy()
		   and to send the full (including options) IP header
		   plus 8 bytes of data.
*/

#define	ICMP	1		/* ICMP Protocol number */
#define ECHOREP	0		/* ICMP Echo reply */
#define	DESTIN	3		/* Destination Unreachable */
#define	SOURCEQ	4		/* Source quench */
#define	REDIR	5		/* Redirect */
#define	ECHOREQ	8		/* ICMP Echo request */
#define	TIMEX	11		/* Time exceeded */
#define	PARAM	12		/* Parameter problem */
#define	TIMEREQ	13		/* Timestamp request */
#define	TIMEREP	14
#define	INFO	15		/* Information request */
#define ICMPSIZE	sizeof(struct ping)

extern	tcpip	*_initp;

struct ping 
	{				/* ICMP Echo request/reply header */
	byte	ptype;
	byte	pcode;
	ushort	pchksum;
	ushort	pid;
	ushort	pseq;
	};

/* structure of an icmp destination unreachable packet */

struct destun  
	{
	byte	dtype;
	byte	dcode;
	ushort	dchksum;
	ushort	dno1;
	ushort	dno2;
	struct ip dip;
	char	ddata[8];
	};

/* structure of an icmp time exceeded packet */

struct timex
	{
	char	ttype;
	char	tcode;
	ushort	tchksum;
	ushort	tno1;
	ushort	tno2;
	struct ip tip;
	char	tdata[8];
	};

/* structure of a timestamp reply */

struct tstamp
	{
	char	ttype;
	char	tcode;
	ushort	txsum;
	ushort	tid;
	ushort	tseq;
	ulong	tstamp[3];
	};

/* structure of an icmp redirect */

struct redirect 
	{
	char	rdtype;
	char	rdcode;
	ushort	rdchksum;
	in_name	rdgw;
	struct ip rdip;
	char	rddata[8];
	};


struct redent redtab[REDIRTABLEN] = {0};
int	rednext = 0;

static IPCONN	icmp;
static ushort	pingseq = 1;

typedef struct pinger
	{
	PACKET	p_pakt;	/* packet that was sent */
	uint	p_rand;	/* number random bytes sent */
	uint	p_sqnc;	/* sequence number */
	task	*p_task;	/* task that is waiting */
	long	p_uptg;	/* upcall tag */
	TIMER	p_time;	/* timer for this event */
	} PINGER;

#define	PINGMAX		10
PINGER pings[PINGMAX];
PINGER *pinge;
/*
 *	The icmp counters
 */
ICMP_STAT	IcmpStat = {0};

static int icmprcv();
static void wake_req(), pingtmo();

/*
 *	K Kong 1.27.92	adding function to clear the icmp counters.
 */
IcmpClearCounters()
	{
	memset(&IcmpStat, '\0', sizeof(IcmpStat));
	}

IcmpInit() 
	{
	register PINGER *pp;

	pinge = &pings[PINGMAX];
	for (pp = pings; pp != pinge; pp++)
		{
		pp->p_task = NULL;
		CreatTimer(&pp->p_time);
		}

	if (icmp = in_open(ICMP, icmprcv))
		return 0;	/* malloc fail */
	else
		return 3;
	}

/* ICMP packet handler
*/
static icmprcv(p, len, host,lhost)
PACKET	p;			/* the incoming packet */
uint	len;			/* packet length */
in_name host; 			/* the foreign host */
in_name lhost;			/* local host address */
	{			
	struct ip	*pip;
	struct ping	*e;
	PINGER *pp;
	struct redirect	*rd;
	struct destun	*pdp;
	ushort	osum;
	ushort	xsum;
	char	*data1;
	char	*data2;
	int	i;
	int	stat;
	in_name	ip_dest;	/* dest ip address in the icmp packet	*/

	IcmpStat.inmsg++;
	pip = in_head(p);
	e = (struct ping *)in_data(pip);

	osum = e->pchksum;
	e->pchksum = 0;

	if(len&1)
		((char *)e)[len] = 0;

	if((xsum = ~cksum(e, (len+1)>>1)) != osum)
	  {
	    IcmpStat.inerr++;
		return in_badhdr(p);
	  }

	e->pchksum = osum;
		
	switch(e->ptype) {
	case ECHOREQ:
		IcmpStat.inecho++;
		e->ptype = ECHOREP;
		e->pchksum = 0;
		if(len & 1)
			((char *)e)[len] = 0;

		e->pchksum = ~cksum(e, (len + 1) >> 1);
		ipcopy(&pip->ip_src, &pip->ip_dest);
		ipcopy(&pip->ip_dest, &host);
		in_write(icmp, p, len, host, lhost, (NID *)0, (in_name *)0);
		IcmpStat.outechorep++;
		IcmpStat.outmsg++;
		in_free(p);
		break;
	case DESTIN:
		pdp = (struct destun *)e;
		switch(pdp->dip.ip_prot)
			{
			case TCPPROT:  /* if TCP packet */
				/* do nothing for TCP yet */
				break;
			case UDPPROT: /* if UDP packet */
				/* check UDP packet */
				icmp_udp(pdp->dtype, pdp->dcode, 
					(char *)pdp->ddata);
				break;
			default:
				break;
			}
		IcmpStat.indstunrch++;
		in_free(p);
		break;
	case SOURCEQ:
		IcmpStat.insourcq++;
		in_free(p);
		break;
	case REDIR:
		IcmpStat.inredir++;
		rd = (struct redirect *)e;
		ipcopy(&ip_dest, &rd->rdip.ip_dest);
		for(i = 0; i < REDIRTABLEN; i++)
			if(redtab[i].rd_dest == ip_dest)
				{
				ipcopy(&redtab[i].rd_to, &rd->rdgw);
				in_free(p);
				return;
				}

		redtab[rednext].rd_dest = ip_dest;
		ipcopy(&redtab[rednext].rd_to, &rd->rdgw);
		rednext++;
		rednext &= REDIRTABLEN-1;
		in_free(p);
		break;
	case ECHOREP:
		IcmpStat.inechorep++;
		for (pp = pings; pp != pinge; pp++)
			if (pp->p_task && pp->p_sqnc == e->pseq)
				break;	/* got one */
		if (pp == pinge)
			return in_discard(p);

		data1 = in_data(in_head(p))+ICMPSIZE;
		data2 = in_data(in_head(pp->p_pakt))+ICMPSIZE;
		for (i=0; i < pp->p_rand; i++)
		  if (*data1++ != *data2++) 
		  	break;

		in_free(p);
		in_free(pp->p_pakt);
		StopTimer((TIMER *)&pp->p_time);
		icmp_pinged(pp->p_uptg, (i == pp->p_rand) ? 0 : OUT_OF_RANGE);
		pp->p_task = 0;
		break;

	case TIMEX:
		IcmpStat.intimexcd++;
		in_free(p);
		break;
	case PARAM:
		IcmpStat.inparmprob++;
		in_free(p);
		break;
	case TIMEREQ:
		IcmpStat.intmstmp++;
		e->ptype = TIMEREP;
		e->pchksum = 0;
		e->pchksum = ~cksum(e, sizeof(struct tstamp)>>1);
		ipcopy(&pip->ip_src, &pip->ip_dest);
		ipcopy(&pip->ip_dest, &host);
		in_write(icmp, p, sizeof(struct tstamp), host, lhost, (NID *)0, (in_name *)0);
		IcmpStat.outtmstmprep++;
		IcmpStat.outmsg++;
		in_free(p);
		break;
	case INFO:
		in_free(p);
		break;
	default:
		return in_discard(p);
		}
	}


/* ICMP Echo Request - returns 1 if host replies, 0 if timeout or error */
icmp_ping(host, len, time, uptag)
in_name	host;
int	len;
int	time;
long	uptag;

	{
	return IcEchoRequest(host, _initp->in_me, len, time, uptag);
	}

/* abort a ping request */
icmp_ping_abort(uptag)
long uptag;

	{
	PINGER *pp;

	for (pp = pings; pp != pinge; pp++)
		if (pp->p_task != 0 && pp->p_uptg == uptag)
			{
			in_free(pp->p_pakt);
			pp->p_task = NULL;
			break;
			}
	}

IcEchoRequest(host, lhost, length, time, uptag)
in_name host;
in_name lhost;
uint	length;
uint	time;
long	uptag;	

	{
	PINGER	*pp;
	PACKET	p;
	register struct ping *e;
	register char	*data;
	int	i;

	IcmpStat.outecho++;
	/* get packet */
	p = in_alloc(40, 0);
	if (p == NULL) 
		{
	   	IcmpStat.outerr++;
		return ERR_NORSRC;
		}

	/* get pinger controller structure */
	for (pp = pings; pp != pinge; pp++)
		if (pp->p_task == 0)
			break;	/* got one */
	if (pp == pinge)
		{
		in_free(p);
	   	IcmpStat.outerr++;
		return ERR_NORSRC;
		}

	/* init pinger structure */
	pp->p_sqnc = pingseq++;
	pp->p_rand = length;
	pp->p_pakt = p;
	pp->p_task = (task*)CurrentTask();
	pp->p_uptg = uptag;

	e = (struct ping *)in_data(in_head(p));
	e->ptype = ECHOREQ;
	e->pcode = 0;
	e->pid = 0;
	e->pseq = pp->p_sqnc;

	/* Put random numbers in the packet. */
	data = (char *)e + ICMPSIZE;
	for (i = 0; i < length; i++) 
		*data++ = rand();

	/* Calculate the checksum */
	e->pchksum = 0;
	if ((ICMPSIZE + length) & 1)
		*data = 0;
	e->pchksum = ~cksum(e, (ICMPSIZE+length+1) >> 1);

	/* send ping, wait for pong */
	IcmpStat.outmsg++;
	if (i = in_write(icmp, p, ICMPSIZE+length, host, lhost, (NID *)NULL, (in_name *)NULL)) 
		{
		pp->p_task = NULL;
		in_free(p);
		return i;
		}
	StartTimerCall((TIMER *)&pp->p_time, time, pingtmo, (int)pp);
	return 0;	/* ok so far */
	}


icmp_destun(host, lhost, ip, type)
in_name host;
in_name lhost;
struct ip	*ip;
uint	type;

	{
	PACKET	p;
	struct destun	*d;
	int	i;

	p = in_alloc(512, 0);
	if (p == NULL)
		{
		return 0;
		}

	d = (struct destun *)in_data(in_head(p));

	d->dtype = DESTIN;
	d->dcode = type;

	/* copy IP header + 8 bytes of data */
	memcpy((byte *)&d->dip, (byte *)ip, GetIpHeaderLength(ip) * 4 + 8);

	d->dchksum = 0;
	d->dchksum = ~cksum(d, sizeof(struct destun) >> 1);

	in_write(icmp, p, sizeof(struct destun), host, lhost, (NID *)NULL, (in_name *)NULL);
	IcmpStat.outmsg++;
	IcmpStat.outdstunrch++;
	in_free(p);
	return;
	}


static void pingtmo(pp)
PINGER	*pp;

	{
	if (pp->p_task)
		{
		in_free(pp->p_pakt);
		pp->p_task = 0;	/* is free now */
		icmp_pinged(pp->p_uptg, ERR_TIMEOUT);
		}
	}
