/**			       
*
*	Program Name:	Init Functions
*
*	Filename:	in_init.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/in_init.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:26   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:52   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:02   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 May 1992 10:18:06   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:22:46   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* Copyright 1986 FTP Software Inc. */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <ip.h>
#include <tcpip.h>
#include "internal.h"

IP_STAT		*ipcntrs;	/* LME for TCP/IP: IP cntrs */
IP_THRESHOLD	*ipalrms;	/* LME for TCP/IP: IP alarms */
IP_ENTRY	*ipstats;	/* LME for TCP/IP: IP stats */

extern	MBOX	ReceiveMbox;

TIMER	RipTimer;

in_init() 
	{
	ipcntrs = _initp->ipcntr;
	ipalrms = _initp->ipalrm;
	memset(ipcntrs, 0, sizeof(IP_STAT));
	memset(ipalrms, 0, sizeof(IP_THRESHOLD));
	ipstats = _initp->ipstat;
	ipstats->ipaddr = _initp->in_me;
	ipstats->ipnetmask = _initp->net_mask;
	ipstats->ipbroadcast = _initp->in_me | ~_initp->net_mask;
	ipstats->ipifindex = 0;
	return 0;
	}


/* Return true if there are any queued, unprocessed packets in the system. */
in_more() 
	{
	return (int)(ReceiveMbox.mb_mflink);
	}


/* Return the address of our machine relative to a certain foreign host. */
in_name in_mymach(host,lhost)
in_name host; 	
in_name lhost;
	{
	in_name temp;

	if (host == 0xFFFFFFFF)
		return _initp->in_me;
	if (!inroute(host, lhost, &temp))
		return lhost;
	return 0L;
	}
/*
 *	Clear the ip counters
 */
IpClearCounters()

	{
	memset(ipcntrs, '\0', sizeof(IP_STAT));
	}
