/**			       
*
*	Program Name:	Opening Protocol Connection
*
*	Filename:	in_open.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/in_open.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:26   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:52   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:04   gregs
 * Initial revision.
 * 
 *    Rev 1.2   13 May 1992 10:22:46   pvcs
 * No change.
 * 
 *    Rev 1.1   13 May 1992 10:21:58   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:22:48   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* Copyright 1986 FTP Software Inc. */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <ip.h>
#include "lme.h"
#include "ipconn.h"
#include "internal.h"

/* Open a protocol connection on top of internet. Protocol information
	necessary for packet demultiplexing; handler is upcalled
	upon receipt of packet. handler is
		int handler(p, len, fhost)
			PACKET p
			int len
			in_name fhost
*/
#define	IP_DEMUX_SIZE	10	/* we support this many protocols 
				 * at any one time
				 */

IPCONN ipconn[IP_DEMUX_SIZE];		/* demux table */
int nipconns = 0;			/* current posn in demux table */

IPCONN in_open(prot, handler)
uint	prot;	/* protocol above ip, this is normally either udp or tcp */
int	(*handler)();

	{
	int 	i;
	IPCONN	conn;

	/*
	 *	Check if the protocol is already been used.
	 */
	for(i = 0; i < nipconns; i++)
		if(ipconn[i]->c_prot == prot)
			return NULL;

	if ((conn = (IPCONN)lmalloc(sizeof(struct ip_iob))) == NULL)
		return NULL;
	memset(conn, 0, sizeof(struct ip_iob));
	conn->c_prot = prot;
	conn->c_handle = handler;
	ipconn[nipconns++] = conn;
	return conn;
	}
