/**			       
*
*	Program Name: 	Internet Write
*
*	Filename:	in_write.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/in_write.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:28   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:54   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:04   gregs
 * Initial revision.
 * 
 *    Rev 1.3   13 May 1992 10:25:20   pvcs
 * 
 *    Rev 1.2   12 May 1992 19:48:56   kwok
 * check for the return value form IsAdminPort(). A non-zero means ok !!
 * 
 *    Rev 1.1   27 Apr 1992 19:16:34   pvcs
 * Forward the packet to the admin bus if I am the relayer and the
 * destination ip address is for the system card.
 * 
 *    Rev 1.0   16 Apr 1992 18:22:48   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		11.14.91
*
*	Version:	1.1
*
*	Programmers:
*
*	Modifications:	K Kong	11.14.91	1.1
*			Adding support for the admin. bus.  Check if
*			the packet is for the admin. bus or the network
*			before we send it.
*
*			Ramki 2-13-92
*			Made changes to handle local host address
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

/* 8/23/84 - changed debugging messages.
						<John Romkey>
MOD: BLL - changed pctcp\error.h to error.h
*/
/*	3.19.1991	Kwok Kong
*	Don't manipulate ip address directly
*	from the packet buffer.  The ip address
*	may not be properly aligned.  We have to 
*	copy out the ip address first.
*/
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <ether.h>
#include <netbuf.h>
#include <ip.h>
#include <tcpip.h>
#include <error.h>

#include "ipconn.h"
#include "internal.h"

extern	int et_ip_send();
/*
 *	3.13.91		Added by K Kong
 *	We can redirect the MAC level packet send to
 *	slip or whatever easily by re-mapping MacIpSend.
 *	However, the default is et_ip_send. (Ethernet)
 */
int	(*MacIpSend)() = et_ip_send;

/* Fill in the internet header in the packet p and send the packet through the
	appropriate net interface. This will involve using routing. Packets for
	a certain connection are all routed at connection open time, but some
	facility should be provided to allow for later rerouting. */

static ushort uid=1;

in_write(conn, p, datalen, fhost, lhost, np, hp)
register IPCONN conn;
PACKET	p;
int	datalen;	/* ip data length (actual data + udp or tcp header)*/
in_name	fhost; 		/* ip address of the receiving host	*/
in_name lhost;		/* Ip address of the sending host */
NID	*np;		/* use this for destination NID if not NULL	*/
in_name	*hp;		/* use this for fhost is not NULL	*/

	{
	in_name	firsthop;
	struct ip	*pip;
	int	len;
	int	ret = 0;

	ipcntrs->outreq++;

	if(datalen > _initp->tlenfree) 
		return -1;
	if (fhost == NULL)
		return ERR_NET_UNREACHABLE;
		
	/* try to route the packet... */
	if (hp != NULL)
		firsthop = *hp;
	else if (inroute(fhost, lhost, &firsthop))
		return ERR_NET_UNREACHABLE;

	pip = in_head(p);
	PutIpVersion(pip, IP_VER);
	pip->ip_time = IP_TIME;

	PutIpFlags(pip, IP_FLGS);
	PutIpFragmentOffset(pip, IP_FOFF);
	pip->ip_flgs_foff = htons(pip->ip_flgs_foff);

	pip->ip_id = htons(uid++);

	pip->ip_chksum = IPXSUM;
	/*
	 *	Don't manipulate ip address directly
	 *	from the packet buffer.  The ip address
	 *	may not be properly aligned. 
	 */
	ipcopy(&pip->ip_src, &lhost);
	ipcopy(&pip->ip_dest, &fhost);

	len = (GetIpHeaderLength(pip) << 2) + datalen;
	/*** K Kong	8.22.91
	len = (pip->ip_ihl << 2) + datalen;
	*****/

	pip->ip_len = htons((ushort)len);

	pip->ip_tsrv = 0;
	pip->ip_prot = (byte)conn->c_prot;

	pip->ip_chksum = (ushort)~cksum(pip, GetIpHeaderLength(pip) << 1);
	/*
	 *	Check if this is for the ADMIN bus or the network.
	 *
 	 *	4.23.92	K Kong
 	 *	Check if the destination ip address is the ip address
 	 *	of the system card.
	 */
 	if (p->nb_flags & PKT_ADMIN || IsSyscardIP(fhost))
		{
		p->db_actcnt = len;
		p->nb_len = len;
		ret = IsAdminPort(p, fhost);
		if (ret == 0)
			ret = ERR_NET_UNREACHABLE;
		else
			ret = 0;
		}
	else 
		{
		ret = et_ip_send(p, len, firsthop, np, lhost);
		if (ret == ERR_UNKNOWN  &&  firsthop != fhost)
			 ret = ERR_NET_UNREACHABLE;
	   	}
	return ret;
	}


/*
 *	Copy ip address from "from" to "to".
 *	It assumes that "to" and "from" are 
 *	short aligned.
 */
ipcopy(ushort *to, ushort *from)

	{
	*to++ = *from++;
	*to = *from;
	}
