/**			       
*
*	Program Name:	Internet Demultiplexing
*
*	Filename:	indemux.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/indemux.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:30   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:54   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:04   gregs
 * Initial revision.
 * 
 *    Rev 1.2   17 Jun 1992 14:12:56   vinay
 * Removed the Errorlog function
 * 
 *    Rev 1.1   13 May 1992 10:27:14   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:22:50   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		11.12.91
*
*	Version:	1.2
*
*	Programmers:
*
*	Modifications:	1.1	3.19.91		K Kong
*			Don't manipulate ip address directly
*			from the packet buffer.  The ip address
*			may not be properly aligned.  We have to 
*			copy out the ip address first.
*
*			1.2	11.12.91	K Kong
*			If the packet is not for me, check if it
*			is for the SYSCARD - i.e. send it down
*			to the admin. bus.
*
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
Copyright (C) 1986,1987 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/

/*  Copyright 1984,1985 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <icmp.h>
#include <ether.h>
#include <ip.h>
#include <tcpip.h>
#include "ipconn.h"
#include "internal.h"


/* This is the internet demultiplexing routine. It handles packets received by
	the per-net task, verifies their headers and does the upcall to
	the whoever should receive the packet. All the guts of demultiplexing
	is in this piece of code. If the packet doesn't belong to anyone,
	this gets logged and the packet dropped.
MOD: BLL added ip filtering, <tcpip.h>, ipfltr counter 
*/
extern tcpip *_initp;

indemux(p, len)
PACKET	p;
int	len;

	{
	struct ip	*pip;	/* the internet header */
	register IPCONN conn;		/* an internet connection */
	ushort	prot;			/* packet protocol */
	int	i;
	in_name	ip_src;		/*	source ip address in "p"	*/
	in_name	ip_dest;	/*	destination ip in "p"	*/
	unsigned short	csum;
	int	ip_flags;	/*	ip flags in the header	*/
	int	ip_FragOffset;	/*	fragment offset in the header	*/

	ipcntrs->inrcv++;
	pip = in_head(p);
	if(len < (uint)ntohs(pip->ip_len)) 
		{
		return in_badhdr(p);
		}
	len = (uint)ntohs(pip->ip_len);

	/* 
	 *	Is ip version ok ?
	 */
	if(GetIpVersion(pip) != IP_VER) 
		{
		return in_badhdr(p);
		}

	/*
	 *	Is check sum ok ?
	 */
	csum = cksum(pip, GetIpHeaderLength(pip) << 1); 
	if (csum == 0)
		csum = 0xffff;
	if (csum != 0xffff)
		{
		return in_badhdr(p);
		}
	/*
	 *	Don't manipulate ip address directly
 	 *	from the packet buffer.  The ip address
	 *	may not be properly aligned.  We have to 
	 *	copy out the ip addresses first.
	 */

	ipcopy(&ip_src, &pip->ip_src);
	ipcopy(&ip_dest, &pip->ip_dest);
/***
	if (ip_src == _initp->in_me)
		{	
		in_free(p);		
		return;
		}
***/
	/* if the IP address is one of the various broadcast addresses,
		set the IP_BROADCAST bit
	*/
	if (ip_dest == 0xFFFFFFFF 
		||  ip_dest == (_initp->in_me | ~_initp->net_mask))
		{
		/*	K Kong	11.20.91
		 *	if it is from me,
		 *	throw it away.
		 */
/***
		if (ip_src == _initp->in_me) 
			{
			in_free(p);
			return;
			}
***/
		p->nb_flags |= PKT_IP_BROADCAST;
		}

	 /* check if the packet is for me. If it's not and it wasn't
		 a broadcast, or not for the slip port, then punt it
		 Accept all packets if my ip is 0. i.e. I don't know
		 my ip yet!
	 */
	if(ip_dest != _initp->in_me && !is_broadcast(p) 
	&& !IsMyPortIp(ip_dest)
	&& !(p->nb_flags & PKT_IP_BROADCAST) && _initp->in_me != 0)
		{
		/*
		 *	If it is for one of the slip port (terminal server),
		 *	then we are done.
		 *	K Kong	11.12.91
		 *	Check if it is for the SYSCARD - admin. bus.
		 */
		if (IsSlipPacket(p, ip_dest)) 
			return;
		if (IsAdminPort(p, ip_dest))
			{
			putfree(p);
			return;
			}
		return in_badhdr(p);
		}

	/* filter the ip address */
	if ((ip_src ^ _initp->fltr_val) & _initp->fltr_mask)
		{
		return in_badhdr(p);
		}

	/* Woe, oh silly crock */
	/*
	 *	Convert the fragment offset
	 *	from network order to host order
	 */
	/***********
	*(((ushort *)&pip->ip_id)+1)
	= ntohs(*(((ushort *)&pip->ip_id)+1));
	*******************/
	pip->ip_flgs_foff = ntohs(pip->ip_flgs_foff);
	ip_FragOffset = GetIpFragmentOffset(pip);
	ip_flags = GetIpFlags(pip);
	/*
	 *	If the fragment offset of non-zero or
	 *	the more flag is set, then this is only a fragment
	 *	of the whole ip packet.
	 */
	if((ip_FragOffset != 0) || (ip_flags & 1)) 
		{
		infrag(p, len);
		return;
		}

	/* The packet is now verified; the header is correct. Now we have
		to demultiplex it among our internet connections.
	*/
	prot = pip->ip_prot;
	for(i = 0; i < nipconns; i++) 
		{
		conn = ipconn[i];
		if(conn->c_prot == prot) 
			if(conn->c_handle == NULL)
				break;
			else 
				{
				ipcntrs->indeliver++;
				return (*conn->c_handle)(p, len - IPLEN, ip_src, ip_dest);
				}
		}

	/* nobody's listening for this packet. Unless it was broadcast, send
		a destination unreachable. doesn't work right with
		subnet routing.
	*/
	if(!is_broadcast(p))
		icmp_destun(ip_src, ip_dest, pip, DSTPROT);

	return in_badproto(p);
	}


int in_discard(pkt)
PACKET	pkt;
	{
	/* ipcntrs->indiscard++; 09/22/89 JCL */
	putfree((DBD *)pkt);
	if (ipalrms->discardthold_val)	/* enabled */
		if (--ipalrms->discardthold_val == 0)	/* expired */
			{
			ipalrms->discardthold_val = ipalrms->discardthold_rstval;
/*			lme_alarm(IP_DISCARD_ERR_EVENT, ipcntrs->indiscard);  */
			}
	}


int in_badaddr(p)
PACKET	p;
	{
	ipcntrs->inaddrerr++;
	if (ipalrms->addrerrthold_val)	/* enabled */
		if (--ipalrms->addrerrthold_val == 0)	/* expired */
			{
			ipalrms->addrerrthold_val = ipalrms->addrerrthold_rstval;
/*			lme_alarm(IP_ADDR_ERR_EVENT, ipcntrs->inaddrerr);   */
			}
	ipcntrs->indiscard++;	/* JCL 09/22/89 */
	in_discard(p);
	}


int in_badhdr(p)
PACKET	p;
	{
	ipcntrs->inhdrerr++;
	if (ipalrms->hdrerrthold_val)	/* enabled */
		if (--ipalrms->hdrerrthold_val == 0)	/* expired */
			{
			ipalrms->hdrerrthold_val = ipalrms->hdrerrthold_rstval;
/*			lme_alarm(IP_HDR_ERR_EVENT, ipcntrs->inhdrerr);  */
			}
	ipcntrs->indiscard++;	/* vinay 6/8/92 */
	in_discard(p);
	}

int in_badproto(p)
PACKET	p;
	{
	ipcntrs->inunknownproto++;
	if (ipalrms->protoerrthold_val)	/* enabled */
		if (--ipalrms->protoerrthold_val == 0)	/* expired */
			{
			ipalrms->protoerrthold_val = ipalrms->protoerrthold_rstval;
/* 			lme_alarm(IP_PROTO_ERR_EVENT, ipcntrs->inunknownproto);  */
			}
	ipcntrs->indiscard++;	/* JCL 09/22/89 */
	in_discard(p);
	}

/*
 *	K Kong	8.21.91
 *	These functions are added to support the bit fields in the
 *	ip header.
 *	We cannot use bit field as the 960 will read an int (4 bytes)
 *	from memory, shift left and then shift right to get the
 *	bit fields.  This may cause a fault as the bit fields may not be
 *	aligned on a 4 bytes boundry.
 */

inline GetIpVersion(struct ip *pip)

	{
	return ((pip->ip_ver_ihl & 0xf0) >> 4);
	}

inline GetIpHeaderLength(struct ip *pip)

	{
	return (pip->ip_ver_ihl & 0x0f);
	}

inline GetIpFlags(struct ip *pip)

	{
	return ((pip->ip_flgs_foff & 0xe000) >> 13);
	}
inline GetIpFragmentOffset(struct ip *pip)

	{
	return (pip->ip_flgs_foff & 0x1fff);
	}

inline PutIpVersion(struct ip *pip, uint version)

	{
	pip->ip_ver_ihl = (pip->ip_ver_ihl & 0x0f) | (version << 4);
	}

inline PutIpHeaderLength(struct ip *pip, uint HeaderLength)

	{
	pip->ip_ver_ihl = (pip->ip_ver_ihl & 0xf0) | HeaderLength;
	}

inline PutIpFlags(struct ip *pip, uint flags)

	{
	pip->ip_flgs_foff = (pip->ip_flgs_foff & 0x1fff) | (flags << 13);
	}

inline PutIpFragmentOffset(struct ip *pip, uint FragmentOffset)

	{
	pip->ip_flgs_foff = (pip->ip_flgs_foff & 0xe000) | FragmentOffset;
	}
	
