/**			       
*
*	Program Name:	Internet Router
*
*	Filename:	inroute.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/inroute.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:32   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:58   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:06   gregs
 * Initial revision.
 * 
 *    Rev 1.4   05 Mar 1993 13:12:50   ramki
 * Modified the router handling
 * 
 *    Rev 1.3   01 Sep 1992 10:38:48   ramki
 * The previous fix had a problem
 * 
 *    Rev 1.2   28 Jul 1992 15:16:24   ramki
 * Revoved the rttbl and made it part of initp structure
 * 
 *    Rev 1.1   13 May 1992 10:31:36   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:22:54   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* Copyright 1986 FTP Software Inc. */

/*  Copyright 1984, 1985 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
/* 11/17/84 - changed to use subnet masks.
					<John Romkey>
   11/17/85 - changed to return error when unable to route.
					<John Romkey>
*/
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <ip.h>
#include <tcpip.h>
#include <error.h>
#include "redirtab.h"
#include "internal.h"

/* Route a packet.
	Takes the internet address that we want to send a packet to and
	tries to figure out which net interface to send it through.

	Returns NULL when unable to route.
*/
inroute(host, lhost, hop1)
register in_name host;
in_name lhost;
in_name	*hop1; 
{
	register int i;
	in_name	lh;

	/* first check through the redirect table for this host */
	for (i = 0; i < REDIRTABLEN && redtab[i].rd_dest; i++)
	{
		if(redtab[i].rd_dest == host) 
		{
			*hop1 = redtab[i].rd_to;
			return 0;
		}
	}
	if(lhost == 0)
		lh = _initp->in_me;
	else
		lh = lhost;

	/* Check if it is on my net */
	if ((lh & _initp->net_mask) == (host & _initp->net_mask))
	{
		*hop1 = host;
		return 0;
	}

	/* The host isn't on a net I'm on, so send it to the default gateway
	*	on my first net   --- this is a really bad idea.
	*
	*	May be I should have checked if the gateway is on the
	*	same network as my network.
	*/
	if(_initp->gway1Metric < 16)
	{
		*hop1 = _initp->net_gway;
		return 0;
	}
	else if (_initp->gway2Metric < 16)
	{
		*hop1 = _initp->net_gway2;
		return 0;
	}
	return ERR_NET_UNREACHABLE;
}

ClearRedirtable()
{

	memset((byte *)redtab, 0, sizeof(redtab));
}
