
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	attable.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/attable.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:41:10   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:41:48   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:14:56   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:24:40   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */



/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**  This file contains modules for SNMP AT TABLE
**
*******************************************************/
/*   SYTEK SNMP modified version 1.0      2-22-89			*/


#include <types.h> 
#include <netbuf.h>
#include <tcpip.h>
#include <ip.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <arp.h>


extern tcpip initp;
extern IF_ENTRY  *ifcntrs;

/****************************************************************************
     THIS MODULE CONTAINS ROUTINES TO ACCESS ADDRESS TRANSLATION TABLES
****************************************************************************/

/****************************************************************
**    SVC_ATIFINDEX ROUTINE   (ATENTRY - 1 )
*****************************************************************/
int
svc_atIfIndex(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	unsigned int  *cp;
	unsigned int idx=0;
	unsigned int i,flag;

	flag = (priv > 15 ? 1 : 0);
	switch(service) 
	{
	case SNMP_GET:
		if (i=find_atidx(*compc,(unsigned int  *)compl,flag)==ARP_CACHE_SIZE)
			return NO_SUCH_NAME;
		*value = IFINDEX;
		break;

	case SNMP_SET:
		return READ_ONLY;

	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0)
			idx = 0;
		else
		{
			if ( (idx=find_atidx(*compc,(unsigned int  *)cp,flag))
			    == ARP_CACHE_SIZE )
				return ERR_INSTANCE;
			idx++;
		}
		if ( find_nxtat(idx,(byte  *)compc,
		    (unsigned int  *)compl,flag) == ARP_CACHE_SIZE )
			return NO_SUCH_NAME;
		*value = IFINDEX;
		break;

	case SNMP_TEST:
		return READ_ONLY;

	}
	return 0;
}

chk_x_zeros(min,num,cp)
int min;
unsigned num;
unsigned int  *cp;
{
	int i;

	for(i=0; i<min; i++, cp++ )		/* only check the ip address */
		if ( *cp != 0 )
			return FALSE;
	return TRUE;		/* all 0's-must be the beginning of table */
}

find_atidx(num,cp,flag)
int num;
unsigned int  *cp;
int	flag;
{
	unsigned int i;
	register struct tabent *tp=table;
	AIP ipp;

	if ( *cp++ > _initp->ifNumber)	/* check the seperator */
		return ARP_CACHE_SIZE;
	if(! flag) /* Increment only for atTable objects */
		cp++;
	for ( i=0; i<4; i++,cp++ )
		ipp.ip[i] = *cp;

	for ( i=0; i<ARP_CACHE_SIZE; i++,tp++ )
		if ( tp->etip_id != 0 )
			if ( ipp.ip_adr == tp->ip_addr )
				break;
	return i;
}

find_nxtat(index,compc,compl,flag)
int index;
byte  *compc;
unsigned int  *compl;
int	flag;
{
	unsigned int i,j;
	register struct tabent *tp=table;
	AIP ipadr;

	for ( i=index, tp +=index; i<ARP_CACHE_SIZE; i++,tp++ )
		if ( tp->etip_id != 0 )
		{
			*compl++ = IFINDEX;
			if(!flag)
				*compl++ = 1;
			ipadr.ip_adr = tp->ip_addr;
			for ( j=0; j<4; j++,compl++ )
				*compl = ipadr.ip[j];
			if(!flag)
				*compc = 6;
			else
				*compc = 5;
			break;
		}
	return i;
}

/****************************************************************
**   SVC_ATPHYADDR ROUTINE     ( ATENTRY - 2 )
*****************************************************************/
int
svc_atPhysAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	unsigned int  *cp;
	unsigned int idx=0;
	unsigned int i,flag;

	flag = (priv > 15 ? 1 : 0);
	switch(service) {

	case SNMP_GET:
		if ((i=find_atidx(*compc,(unsigned int  *)compl,flag))
		    ==ARP_CACHE_SIZE)
			return NO_SUCH_NAME;
		get_atphyaddr(i,(OCTET_P)value,(int  *)lenp);
		break;
	case SNMP_SET:
		return READ_ONLY;
	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0)
			idx = 0;
		else
		{
			if ( (idx=find_atidx(*compc,(unsigned int  *)cp,flag))
			    == ARP_CACHE_SIZE )
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=find_nxtat(idx,(byte  *)compc,
		    (unsigned int  *)compl,flag)) == ARP_CACHE_SIZE )
			return NO_SUCH_NAME;
		get_atphyaddr(i,(OCTET_P)value,(int  *)lenp);
		break;

	case SNMP_TEST:
		return READ_ONLY;

	}
	return 0;
}


get_atphyaddr(i,value,lenp)
unsigned int i;
OCTET_P value;
int  *lenp;
{
	register struct tabent *tp=table;

	tp += i;
	memcpy((OCTET_P)value,tp->et_addr,6);
	*lenp = 6;
}

/****************************************************************
**    SVC_ATNETADDR ROUTINE    (ATENTRY - 3 )
*****************************************************************/
int
svc_atNetAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	unsigned int  *cp;
	unsigned int idx=0;
	unsigned int i,flag;

	flag = (priv > 15 ? 1 : 0);
	switch(service)
	{
	case SNMP_GET:
		if ((i=find_atidx(*compc,(unsigned int  *)compl,flag))
		    ==ARP_CACHE_SIZE)
			return NO_SUCH_NAME;
		get_atipaddr(i,(INT_32_T  *)value,(int *)lenp);
		break;
	case SNMP_SET:
		return READ_ONLY;
	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0)
			idx = 0;
		else
		{
			if ( (idx=find_atidx(*compc,(unsigned int  *)cp,flag))
			    == ARP_CACHE_SIZE )
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=find_nxtat(idx,(byte  *)compc,
		    (unsigned int  *)compl,flag)) == ARP_CACHE_SIZE )
			return NO_SUCH_NAME;
		get_atipaddr(i,(INT_32_T  *)value,(int *)lenp);
		break;

	case SNMP_TEST:
		return READ_ONLY;

	}
	return 0;
}


get_atipaddr(i,value,lenp)
unsigned int i;
INT_32_T  *value;
int  *lenp;
{
	register struct tabent *tp=table;

	tp += i;
	*((INT_32_T  *)value) = tp->ip_addr;
	*lenp = 4;
}

/*********************************************************************
**
**      GET_NXTIDX ROUTINE
**
**      check the instance number and value for the non-tabular objects
*********************************************************************/
int
get_nxtidx(compc,compl,rtn_code)
int  *compc;
unsigned int  *compl;
int rtn_code;
{
	if ( *compc == 0 )
	{  /* get the only one instance */
		*compl = 0;
		*compc = 1;
		return 0;
	}
	else
		if ( rtn_code == 0 )
			return NO_SUCH_NAME;
		else
			return  ERR_INSTANCE;
}

/*********************************************************************
**
**      CHK_INDEX ROUTINE
**
**      check the instance of the non-tabular objects
**      return 0 - if instance count is 1 and instance value is 0 
**             NO_SUCH_NAME error code - if instance is incorrect.
*********************************************************************/
int
chk_index(compc,compl)
unsigned int compc,compl;
{
	if (compc == 1 && compl == 0)
		return 0;
	else return NO_SUCH_NAME;
}
