
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	icmptabl.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/icmptabl.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:41:12   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:41:50   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:14:56   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:24:42   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**  This file contains modules for SNMP ICMP TABLE
**  
**          Created on 4-3-89
*******************************************************/


#include <types.h> 
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <icmp.h>




/****************************************************************
**     SVC_ICMPINMSGS   ROUTINE     ( ICMP - 1 )
*****************************************************************/
int
svc_icmpInMsgs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_inmsg;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_inmsg;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINERRS   ROUTINE     ( ICMP - 2 )
*****************************************************************/
int
svc_icmpInErrors(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;
	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_inerr;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_inerr;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}


/****************************************************************
**     SVC_ICMPINDSTUNRCHS   ROUTINE     ( ICMP - 3 )
*****************************************************************/
int
svc_icmpInDestUnreachs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_indstunrch;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_indstunrch;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINTIMEXCD   ROUTINE     ( ICMP - 4 )
*****************************************************************/
int
svc_icmpInTimeExcds(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_intimexcd;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_intimexcd;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINPARMPROB   ROUTINE     ( ICMP - 5 )
*****************************************************************/
int
svc_icmpInParmProbs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_inparmprob;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_inparmprob;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINSRCQENCH   ROUTINE     ( ICMP - 6 )
*****************************************************************/
int
svc_icmpInSrcQuenchs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_insourcq;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_insourcq;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}


/****************************************************************
**     SVC_ICMPINREDIR   ROUTINE     ( ICMP - 7 )
*****************************************************************/
int
svc_icmpInRedirects(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_inredir;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_inredir;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINECHO   ROUTINE     ( ICMP - 8 )
*****************************************************************/
int
svc_icmpInEchos(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_inecho;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_inecho;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINECHOREP   ROUTINE     ( ICMP - 9 )
*****************************************************************/
int
svc_icmpInEchoReps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_inechorep;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_inechorep;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINTIMESTMP   ROUTINE     ( ICMP - 10 )
*****************************************************************/
int
svc_icmpInTimestamps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_intmstmp;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_intmstmp;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINTIMESTAMOREPS ROUTINE  ( ICMP - 11 )
*****************************************************************/
int
svc_icmpInTimestampReps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}


/****************************************************************
**     SVC_ICMPINADRMSK   ROUTINE     ( ICMP - 12 )
*****************************************************************/
int
svc_icmpInAddrMasks(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = 0;  /* ### ??? */
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = 0;  /* ### ??? */
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPINADDRMASKREPS ROUTINE  ( ICMP - 13 )
*****************************************************************/
int
svc_icmpInAddrMaskReps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}


/****************************************************************
**     SVC_ICMPOUTMSGS   ROUTINE     ( ICMP - 14 )
*****************************************************************/
int
svc_icmpOutMsgs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_outmsg;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_outmsg;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}


/****************************************************************
**     SVC_ICMPOUTERRS   ROUTINE     ( ICMP - 15 )
*****************************************************************/
int
svc_icmpOutErrors(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_outerr;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_outerr;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}


/****************************************************************
**     SVC_ICMPOUTDSTUNRCH   ROUTINE     ( ICMP - 16 )
*****************************************************************/
int
svc_icmpOutDestUnreachs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_outdstunrch;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_outdstunrch;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}



/****************************************************************
**     SVC_ICMPOUTTIMEXCD   ROUTINE     ( ICMP - 17 )
*****************************************************************/
int
svc_icmpOutTimeExcds(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = 0;  /* ### ???? */
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = 0;  /* ### ???? */
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPOUTPARMPROB   ROUTINE     ( ICMP - 18 )
*****************************************************************/
int
svc_icmpOutParmProbs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = 0;  /* ### ???? */
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = 0;  /* ### ???? */
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}


/****************************************************************
**     SVC_ICMPOUTSRCQUENCHS ROUTINE  ( ICMP - 19 )
*****************************************************************/
int
svc_icmpOutSrcQuenchs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_ICMPOUTREDIRECTS ROUTINE  ( ICMP - 20 )
*****************************************************************/
int
svc_icmpOutRedirects(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_ICMPOUTECHO   ROUTINE     ( ICMP - 21 )
*****************************************************************/
int
svc_icmpOutEchos(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);

	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_outecho;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_outecho;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPOUTECHOREP   ROUTINE     ( ICMP - 22 )
*****************************************************************/
int
svc_icmpOutEchoReps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_outechorep;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_outechorep;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPOUTTIMESTAMPS ROUTINE  ( ICMP - 23 )
*****************************************************************/
int
svc_icmpOutTimestamps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}


/****************************************************************
**     SVC_ICMPOUTTIMESTMPREP   ROUTINE     ( ICMP - 24 )
*****************************************************************/
int
svc_icmpOutTimestampReps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = icmp_outtmstmprep;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = icmp_outtmstmprep;
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

/****************************************************************
**     SVC_ICMPOUTADDRMASKS ROUTINE  ( ICMP - 25 )
*****************************************************************/
int
svc_icmpOutAddrMasks(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}


/****************************************************************
**     SVC_ICMPOUTADRMSKREP   ROUTINE     ( ICMP - 26 )
*****************************************************************/
int
svc_icmpOutAddrMaskReps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte *compc;
unsigned int *compl;
int *lenp;
UINT_32_T *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = 0;  /* ### ???? */
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int *)compc, 
		    (unsigned int *)compl,rtn_code)) == 0 )
			*value = 0;  /* ### ???? */
		else
			return rtn_code;
		break;

	default:
		return READ_ONLY;
	}
	return 0;
}

