
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	iftable.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/iftable.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:41:16   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:46:30   franks
 * 
 *    Rev 1.0   14 Jul 1993 10:14:58   gregs
 * Initial revision.
 * 
 *    Rev 1.2   15 May 1992 13:45:00   kwok
 * Get the counters from the ifcntrs table if the iftable index is not
 * within the sonic drivers.
 * 
 *    Rev 1.1   14 May 1992 16:41:34   suresh
 * Fixed the iftable statistic counter problem
 * 
 *    Rev 1.0   16 Apr 1992 18:24:42   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */


/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**  This file contains modules for SNMP INTERFACES TABLE
**
*******************************************************/
/*   SYTEK SNMP modified version 1.0      2-22-89			*/


#include <types.h> 
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <sncvar.h>


extern IF_ENTRY  *ifcntrs;
extern	int	NumberOfSonicPort;
/**********************************************************************
     THIS MODULE CONTAINS ROUTINES TO ACCESS THE INTERFACE TABLE
***********************************************************************/

/****************************************************************
**       SVC_IFNUMBER      ( INTERFACES - 1 ) 
*****************************************************************/
int 
svc_ifNumber(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl, rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = _initp->ifNumber;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFINDEX          ( IFENTRY - 1 )
*****************************************************************/
int 
svc_ifIndex(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = *compl;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFDESCR         ( IFENTRY - 2 )
*****************************************************************/
int
svc_ifDescr(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			{
			strcpy(value, (ifcntrs + (*compl - 1))->ifname);
			*lenp = strlen(value);
			}
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFTYPE          ( IFENTRY - 3 )
*****************************************************************/
int 
svc_ifType(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = (ifcntrs + (*compl - 1))->ifType;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFMTU          ( IFENTRY - 4 )
*****************************************************************/
int 
svc_ifMtu(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = (ifcntrs + (*compl - 1))->ifMtu;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**     SVC_IFSPEED          ( IFENTRY - 5 )
*****************************************************************/
int
svc_ifSpeed(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = (ifcntrs + (*compl - 1))->ifSpeed;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFADDR          ( IFENTRY - 6 )
*****************************************************************/
int
svc_ifPhysAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			{
			ncopy(value, (ifcntrs + (*compl - 1))->ifPhysAddress);
			if (AllZeroPhy((NID *)value)) /* Invalid Physical Address */
				*lenp = 0;
			else
				*lenp = 6;
			}
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFADMSTAT          ( IFENTRY - 7 )
*****************************************************************/
int 
svc_ifAdminStatus(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = (ifcntrs + (*compl - 1))->ifAdminStatus;
		else 
			return NO_SUCH_NAME;
		break;
	case SNMP_TEST:
		if (rtn_code == 0)
			{
			if (*value != 1)
				return BAD_VALUE;
			}
		else
			return rtn_code;
		

	}
	return 0;
}

/****************************************************************
**     SVC_IFOPERSTAT          ( IFENTRY - 8 )
**
**	   Same as SVC_ADMSTAT
*****************************************************************/
svc_ifOperStatus(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = (ifcntrs + (*compl - 1))->ifOperStatus;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/*****************************************************************
**     SVC_IFLASTCHNG          ( IFENTRY - 9 )
*****************************************************************/
int
svc_ifLastChange(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = (ifcntrs + (*compl - 1))->ifLastChange;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFINOCT          ( IFENTRY - 10 )
*****************************************************************/
int
svc_ifInOctets(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(0,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFINUCAST          ( IFENTRY - 11 )
*****************************************************************/
int
svc_ifInUcastPkts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(1,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFINNUCAST          ( IFENTRY - 12 )
*****************************************************************/
int
svc_ifInNUcastPkts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(2,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFINDSCRD          ( IFENTRY - 13 )
*****************************************************************/
int
svc_ifInDiscards(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(3,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFINERR          ( IFENTRY - 14 )
*****************************************************************/
int
svc_ifInErrors(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(4,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFINUNKNWN          ( IFENTRY - 15 )
*****************************************************************/
int
svc_ifInUnknownProtos(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(5,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFOUTOCT          ( IFENTRY - 16 )
*****************************************************************/
int
svc_ifOutOctets(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(6,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFOUTUCAST          ( IFENTRY - 17 )
*****************************************************************/
int
svc_ifOutUcastPkts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(7,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFOUTNUCAST          ( IFENTRY - 18 )
*****************************************************************/
int
svc_ifOutNUcastPkts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(8,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFOUTDSCRD          ( IFENTRY - 19 )
*****************************************************************/
int
svc_ifOutDiscards(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(10,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFOUTERR          ( IFENTRY - 20 )
*****************************************************************/
int
svc_ifOutErrors(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ifcommonfnc(9,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IFCOMMONFNC 
*****************************************************************/
int 
svc_ifcommonfnc(index,service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int	rtn_code;
	long  *lp;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
		{
			if (*compl > NumberOfSonicPort)
			{
				/*
				 *	It's not for sonic.
				 *	Get the counters from the 
				 *	iftable.
				 */

		        	lp = (long  *)&(ifcntrs + (*compl - 1))->inbytecnt;
		      		*value = (UINT_32_T)lp[index];
				return;
			}
		  /*
		   *	Otherwise, get it from the sonic table.
		   */
		  switch(index)
		    {
		    case 0: /* inbytecnt */
		      *value = (UINT_32_T)sv_sdvs[*compl - 1].sv_var_loc->sv_inb;
		      break;
		    case 1: /* inunicast */
		      *value = (UINT_32_T)sv_vars[*compl - 1].sv_inu;
		      break;
		    case 2: /* inmulticstcnt */
		      *value = (UINT_32_T)sv_vars[*compl - 1].sv_inm;
		      break;
		    case 3: /* indiscard */
		      *value = (UINT_32_T)sv_vars[*compl - 1].sv_lst;
		      break;
		    case 4: /* inerror */
		      *value = (UINT_32_T)sv_vars[*compl - 1].sv_crc;
		      break;
		    case 6: /* outbytecnt */
		      *value = (UINT_32_T)sv_sdvs[*compl - 1].sv_var_loc->sv_outb;
		      break;
		    case 7: /* outunicast */
		      *value = (UINT_32_T)sv_vars[*compl - 1].sv_outu;
		      break;
		    case 8: /* outmulticast */
		      *value = (UINT_32_T)sv_vars[*compl - 1].sv_outm;
		      break;
		    case 9: /* outerror */
		      *value = (UINT_32_T)sv_vars[*compl - 1].sv_tx_exc;
		      break;
		    default:
		      lp = (long  *)&(ifcntrs + (*compl - 1))->inbytecnt;
		      *value = (UINT_32_T)lp[index];
		      break;
		    }
		}
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFOUTQLEN          ( IFENTRY - 21 )
*****************************************************************/
int
svc_ifOutQLen(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			*value = 0;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IFSPECIFIC        ( IFENTRY - 22 )
*****************************************************************/
int
svc_ifSpecific(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code = chk_ifindex(*compc, *compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtifindex(compc, compl, rtn_code);

	case SNMP_GET:
		if (rtn_code == 0)
			get_ifSpecific(*compl, value, lenp);
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

AllZeroPhy(Nid)
NID *Nid;
{
	int i;

	for (i = 0; i < 3; i++)
		if (Nid->nid[i] != 0)
			return 0;
	return 1;
}
