
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	iptable.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/iptable.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:41:20   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:41:54   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:14:58   gregs
 * Initial revision.
 * 
 *    Rev 1.1   28 Jul 1992 15:17:54   ramki
 * Removed the rttbl reference
 * 
 *    Rev 1.0   16 Apr 1992 18:24:44   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**  This file contains modules for SNMP IP TABLE
**  
**          Created on 3-30-89
*******************************************************/


#include <types.h> 
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>
#include <netbuf.h>
#include <frag.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <netbuf.h>
#include <ip.h>
#include <arp.h>

/****************************************************************
**     SVC_IPFWRD ROUTINE ( IP - 1 )
*****************************************************************/
int
svc_ipForwarding(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = DEVICE_HOST;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**     SVC_IPDEFTTL ROUTINE ( IP - 2 )
*****************************************************************/
int
svc_ipDefaultTTL(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = IP_TIME;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**     SVC_IPINRCVS ROUTINE  ( IP - 3 )
*****************************************************************/
int
svc_ipInReceives(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(0,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPINHDERR ROUTINE ( IP - 4 )
*****************************************************************/
int
svc_ipInHdrErrors(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(1,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPINADDERR ROUTINE ( IP - 5 )
*****************************************************************/
int
svc_ipInAddrErrors(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(2,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPFWRDDGMS ROUTINE ( IP - 6 )
*****************************************************************/
int
svc_ipForwDatagrams(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(3,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPUNKNWNP ROUTINE  ( IP - 7 )
*****************************************************************/
int
svc_ipInUnknownProtos(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(4,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPINDSCRD ROUTINE ( IP - 8 )
*****************************************************************/
int
svc_ipInDiscards(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(5,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPINDLVER ROUTINE ( IP - 9 )
*****************************************************************/
int
svc_ipInDelivers(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(6,service,compc,compl,lenp,value,priv));
}


/****************************************************************
**     SVC_IPOUTREQS  ROUTINE ( IP -10 )
*****************************************************************/
int
svc_ipOutRequests(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(7,service,compc,compl,lenp,value,priv));
}


/****************************************************************
**     SVC_IPOUTDSCRD ROUTINE  ( IP - 11 )
*****************************************************************/
int
svc_ipOutDiscards(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(8,service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPOUTNOROUT ROUTINE ( IP - 12 )
*****************************************************************/
int
svc_ipOutNoRoutes(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_ipcommonfns(9,service,compc,compl,lenp,value,priv));
}

int
svc_ipcommonfns(index,service, compc, compl, lenp, value, priv)
int	index;
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;
	long  *lp = (long  *)_initp->ipcntr;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = (UINT_32_T)lp[index];
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**     SVC_IPREASMTIME ROUTINE ( IP - 13 )
*****************************************************************/
int
svc_ipReasmTimeout(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = ip_reasmtmo;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**     SVC_IPREASMREQS ROUTINE ( IP - 14 )
*****************************************************************/
int
svc_ipReasmReqds(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = ip_reasmreq;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**     SVC_IPREASMOK ROUTINE  ( IP - 15 )
*****************************************************************/
int
svc_ipReasmOKs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = ip_reasmok;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**     SVC_IPREASMFAIL ROUTINE  ( IP - 16 )
*****************************************************************/
int
svc_ipReasmFails(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = ip_reasmfail;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPFRAGOKS ROUTINE  ( IP - 17 )
*****************************************************************/
int
svc_ipFragOKs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_IPFRAGFAILS ROUTINE  ( IP - 18 )
*****************************************************************/
int
svc_ipFragFails(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_IPREASMFAIL ROUTINE  ( IP - 19 )
*****************************************************************/
int
svc_ipFragCreates(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_IPADENTADDR ROUTINE ( IPADDRENTRY - 1 )
*****************************************************************/
int
svc_ipAdEntAddr(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code =  chk_inip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_ipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		else 
			*value = (INT_32_T)_initp->in_me;
		break;

	}
	return 0;
}

chk_inip(compl)
unsigned int  *compl;
{
	AIP ipaddr;
	unsigned int i;
	for ( i=0; i<4; i++,compl++ )
		ipaddr.ip[i] = *compl;
	if ( ipaddr.ip_adr == _initp->in_me )
		return TRUE;
	else
		return FALSE;
}

set_ipidx(compl,compc)
unsigned int  *compl;
int  *compc;
{
	AIP *ipp;
	unsigned int i;

	ipp = (AIP *)&_initp->in_me;
	for ( i=0; i<4; i++,compl++ )
		*compl = ipp->ip[i];
	*compc = 4;
}

get_ipnxt(compc,compl)
int  *compc;
unsigned int  *compl;
{
	unsigned int  *cp;

	cp = compl;
	if ( *compc == 0 || chk_ip_zeros(*compc,(unsigned int  *)cp) )
{  /* first instance may be 0 component or 4 components 
			     ** 0.0.0.0  */
		set_ipidx((unsigned int  *)compl,(byte  *)compc);
		return 0;
	}
	else
	{
		if ( *compc == 4 && chk_inip((unsigned int  *)compl) )
			return NO_SUCH_NAME;
		else
			return ERR_INSTANCE;
	}
}

chk_ip_zeros(num,cp)
unsigned num;
unsigned int  *cp;
{
	int i;
	if( num != 4)
		return FALSE;
	for(i=0; i<num; i++, cp++ )		/* only check the ip address */
		if ( *cp != 0 )
			return FALSE;
	return TRUE;					/* all 0's-must be the beginning of table */
}

/****************************************************************
**     SVC_IPADENTIFIDX ROUTINE ( IPADDRENTRY - 2 )
*****************************************************************/
int
svc_ipAdEntIfIndex(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int  rtn_code;

	rtn_code =  chk_inip((unsigned int  *)compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_ipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		else 
			*value = IFINDEX;
		break;
	}
	return 0;
}

/****************************************************************
**     SVC_IPADENTNETMSK ROUTINE  ( IPADDRENTRY - 3 )
*****************************************************************/
int
svc_ipAdEntNetMask(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code =  chk_inip((unsigned int  *)compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_ipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		else 
			*value = (INT_32_T)_initp->net_mask;
		break;
	}
	return 0;
}

/****************************************************************
**     SVC_IPADENTBCASTADR ROUTINE  ( IPADDRENTRY - 4 )
*****************************************************************/
int
svc_ipAdEntBcastAddr(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int  rtn_code;

	rtn_code =  chk_inip((unsigned int  *)compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_ipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		else 
			*value = 1;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPADENTREASMMAXSIZE ROUTINE  ( IPADDRENTRY - 5)
*****************************************************************/
int
svc_ipAdEntReasmMaxSize(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int	rtn_code;

	rtn_code =  chk_inip((unsigned int  *)compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_ipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		else 
			*value = 0;	/* we don't support re-assemble	*/
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTEDEST ROUTINE ( IPROUTEENTRY - 1 )
*****************************************************************/
int
svc_ipRouteDest(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = (UINT_32_T)0;
		break;

	}
	return 0;
}

chk_routeip(compl)
unsigned int  *compl;
{
	AIP ipaddr;
	unsigned int i;

	for ( i=0; i<4; i++,compl++ )
		ipaddr.ip[i] = *compl;
	if ( ipaddr.ip_adr == 0)
		return 0;
	else
		return NO_SUCH_NAME;
}

get_routeipnxt(compc,compl)
byte  *compc;
unsigned int  *compl;
{
	unsigned int  *cp;

	if( *compc == 0)
	{
		AIP ipp;
		unsigned int i;

		ipp.ip_adr = 0;
		for ( i=0; i<4; i++,compl++ )
			*compl = ipp.ip[i];
		*compc = 4;
	}
	else
	{
		*compc = 0;
		*compl = 0;
		return(NO_SUCH_NAME);
	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTEIFINDEX ROUTINE ( IPROUTEENTRY - 2 )
*****************************************************************/
int
svc_ipRouteIfIndex(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = IFINDEX;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTEMETRIC1 ROUTINE ( IPROUTEENTRY - 3 )
*****************************************************************/
int
svc_ipRouteMetric1(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = _initp->gway1Metric;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTEMETRIC2 ROUTINE ( IPROUTEENTRY - 4 )
*****************************************************************/
int
svc_ipRouteMetric2(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (ipmetric_com(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_IPROUTEMETRIC3 ROUTINE ( IPROUTEENTRY - 5 )
*****************************************************************/
int
svc_ipRouteMetric3(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (ipmetric_com(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_IPROUTEMETRIC4 ROUTINE ( IPROUTEENTRY - 6 )
*****************************************************************/
int
svc_ipRouteMetric4(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (ipmetric_com(service, compc, compl, lenp, value, priv));
}

ipmetric_com(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = -1;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTENEXTHOP ROUTINE ( IPROUTEENTRY - 7 )
*****************************************************************/
int
svc_ipRouteNextHop(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = _initp->net_gway;
		break;

	case SNMP_SET:
		if(_initp->net_gway == *value)
			return(0);
		SetRouterAddr(*value);
		break;

	case SNMP_TEST:
		return(rtn_code);

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTETYPE ROUTINE ( IPROUTEENTRY - 8 )
*****************************************************************/
int
svc_ipRouteType(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = (UINT_32_T)3;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTEPROTO ROUTINE ( IPROUTEENTRY - 9 )
*****************************************************************/
int
svc_ipRouteProto(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = (UINT_32_T)2; /* local */
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTEAGE ROUTINE ( IPROUTEENTRY - 10 )
*****************************************************************/
int
svc_ipRouteAge(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int  rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if(rtn_code != 0)
			return NO_SUCH_NAME;
		*value = (UINT_32_T)0;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTEMASK ROUTINE ( IPROUTEENTRY - 11 )
*****************************************************************/
int
svc_ipRouteMask(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	return(svc_ipRouteAge(service,compc,compl,lenp,value,priv));
}

/****************************************************************
**     SVC_IPROUTEMETRIC5 ROUTINE ( IPROUTEENTRY - 12 )
*****************************************************************/
int
svc_ipRouteMetric5(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (ipmetric_com(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_IPROUTEINFO ROUTINE ( IPROUTEENTRY - 13 )
*****************************************************************/
int
svc_ipRouteInfo(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	int rtn_code;

	rtn_code = chk_routeip((unsigned int  *)compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_routeipnxt((int  *)compc,
		    (unsigned int  *)compl);

	case SNMP_GET:
		if ( rtn_code == 0 )
		{
			*lenp = 2 * sizeof(unsigned int);
			*value = (UINT_32_T)0;
		}
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**    SVC_NETTOMEDIAIFINDEX ROUTINE   (IPNETTOMEDIAENTRY - 1 )
*****************************************************************/
int
svc_ipNetToMediaIfIndex(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_atIfIndex(service,compc,compl,lenp,value,16));
}

/****************************************************************
**   SVC_IPNETTOMEDIAPHYSADDRESS ROUTINE     ( IPNETTOMEDIAENTRY - 2 )
*****************************************************************/
int
svc_ipNetToMediaPhysAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	return(svc_atPhysAddress(service,compc,compl,lenp,value,16));
}

/****************************************************************
**    SVC_IPNETTOMEDIANETADDRESS ROUTINE    (IPNETTOMEDIAENTRY - 3 )
*****************************************************************/
int
svc_ipNetToMediaNetAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	return(svc_atNetAddress(service,compc,compl,lenp,value,16));
}

/****************************************************************
**    SVC_IPNETTOMEDIATYPE ROUTINE    (IPNETTOMEDIAENTRY - 4 )
*****************************************************************/
int
svc_ipNetToMediaType(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	unsigned int  *cp;
	unsigned int idx=0;
	unsigned int i;

	idx=find_atidx(*compc,(unsigned int  *)compl,1);
	switch(service)
	{
	case SNMP_GETNXT:
		if ( *compc == 0 || chk_x_zeros(5,*compc, (unsigned int  *)compl) )
			idx = 0;
		else
		{
			if (idx  == ARP_CACHE_SIZE)
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=find_nxtat(idx,(byte  *)compc,
		    (unsigned int  *)compl,1)) == ARP_CACHE_SIZE )
			return NO_SUCH_NAME;
		*value = (UINT_32_T)(table[i].etip_id != 0 ? 1 : 2);
		break;

	case SNMP_GET:
		if (idx == ARP_CACHE_SIZE)
			return NO_SUCH_NAME;
		*value = (UINT_32_T)(table[idx].etip_id != 0 ? 1 : 2);
		break;

	case SNMP_TEST:
		if(*value != 2)
			return BAD_VALUE;
		if(idx == ARP_CACHE_SIZE)
			return NO_SUCH_NAME;
		break;

	case SNMP_SET:
		table[idx].etip_id = 0;
		break;
	}
	return 0;
}

/****************************************************************
**     SVC_IPROUTINGDISCARDS ROUTINE  ( IP - 23 )
*****************************************************************/
int
svc_ipRoutingDiscards(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

