
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	systable.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/systable.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:41:26   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:41:58   franks
 * No change.
 * 
 *    Rev 1.1   19 Jul 1993 11:39:08   vinay
 * changed the string length to 20 for sysname, contact and also changed the
 * TOO_BIG to BAD_VALUE
 * 
 *    Rev 1.0   14 Jul 1993 10:15:02   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:24:46   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**  This file contains modules for SNMP SYSTEM TABLE
**
*******************************************************/


#include <types.h> 
#include <krnl.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>



/*******************************************************************
**
**      SERVICE ROUTINES FOR SYSTEM GROUP
**
*******************************************************************/



/*******************************************************************
**     SVC_SYSDESCR ROUTINE   ( SYSTEM - 1 ) 
*******************************************************************/
int
svc_sysDescr(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	int len;
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);

	switch(service) {

	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			get_sysdescr((int  *)lenp,(OCTET_P)value);
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/*******************************************************************
**     SVC_SYSOBJ ROUTINE   ( SYSTEM - 2 ) 
*******************************************************************/
int
svc_sysObjectID(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
unsigned int   *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			get_sysobj((int  *)lenp,(unsigned int *)value);
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

get_sysobj(lenp,value)
int  *lenp;
unsigned int   *value;
{
	OBJ_ID_T *objid;
	*lenp = snmp_product_id_count *sizeof(int);
	memcpy((byte  *)value,(byte *)snmp_product_id,*lenp);
}

/*******************************************************************
**     SVC_SYSUPTIME ROUTINE   ( SYSTEM - 3 ) 
*******************************************************************/
int
svc_sysUpTime(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {

	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = (UINT_32_T)RealTimeTicks();
		else return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/*******************************************************************
**     SVC_SYSCONTACT ROUTINE   ( SYSTEM - 4 ) 
*******************************************************************/
int
svc_sysContact(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	int len;
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			gs_syscontact((int  *)lenp,(OCTET_P)value,0);
		else 
			return NO_SUCH_NAME;
		break;


	case SNMP_SET:
		gs_syscontact((int  *)lenp,(OCTET_P)value,1);
		break;

	case SNMP_TEST:
		if(rtn_code == 0)
		{
			if(*lenp <= 20)
				break;
			else
				return BAD_VALUE;
		}
		else
			return(rtn_code);

	}
	return 0;
}

/*******************************************************************
**     SVC_SYSNAME ROUTINE   ( SYSTEM - 5 ) 
*******************************************************************/
int
svc_sysName(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	int len;
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			gs_sysname((int  *)lenp,(OCTET_P)value,0);
		else 
			return NO_SUCH_NAME;
		break;

	case SNMP_SET:
		gs_sysname((int  *)lenp,(OCTET_P)value,1);
		break;

	case SNMP_TEST:
		if(rtn_code == 0)
		{
			if(*lenp <= 20)
				break;
			else
				return BAD_VALUE;
		}
		else
			return(rtn_code);

	}
	return 0;
}

/*******************************************************************
**     SVC_SYSLOCATION ROUTINE   ( SYSTEM - 6 ) 
*******************************************************************/
int
svc_sysLocation(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
OCTET_P  value;
int priv;
{
	int len;
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			gs_syslocation((int  *)lenp,(OCTET_P)value, 0);
		else 
			return NO_SUCH_NAME;
		break;

	case SNMP_SET:
		gs_syslocation((int  *)lenp,(OCTET_P)value,1);
		break;

	case SNMP_TEST:
		if(rtn_code == 0)
		{
			if(*lenp <= 20)
				break;
			else
				return BAD_VALUE;
		}
		else
			return(rtn_code);
	}
	return 0;
}

/*******************************************************************
**     SVC_SYSSERVICES ROUTINE   ( SYSTEM - 7 ) 
*******************************************************************/
int
svc_sysServices(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int  *compl;
int   *lenp;
UINT_32_T   *value;
int priv;
{
	int len;
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = (UINT_32_T)get_sysservices();
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}
