/**
 *	Program Name: 	NIM Initialization
 *
 *	Filename:	nim_init.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mpd/nim_init.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:41:58   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:43:10   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:54:38   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:15:34   gregs
 * Initial revision.
 * 
 *    Rev 1.3   16 Jun 1992 17:31:48   vinay
 * changed back to rev 1.1
 * 
 *    Rev 1.2   16 Jun 1992 14:55:42   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.1   13 May 1992 10:37:46   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:25:50   pvcs
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <ether.h>
#include <tcpip.h>


MBOX	ReceiveMbox;	/*	mbox for all incoming MAC packet	*/
MBOX	IpReceiveMbox;	/*	mbox for all incoming IP packet		*/


extern void 	nim_rcv();
extern void	nim_iprcv();
/*
 *	The stack size for the nim receive task
 */
#define	NIM_RCV_STACK_SIZE	2048
#define	NIM_IPRCV_STACK_SIZE	8192
/*
 *	Stack for the nim receive task.
 */
word *nim_rcv_stack;
word *nim_iprcv_stack;

u_short ETBROADCAST[3] = {0xffff, 0xffff, 0xffff};
IF_ENTRY *ifcntrs;

/* installation routine */
nim_init()

	{
	int	temp;

/*******************	K Kong	3.14.91
 *			We are going to have more than one NIDs.
 *			We have to modify _initp and ifcntrs to
 *			accommodate this.  This can be done later.
 *			For now, just use the NID of the first port.
 */
	ncopy(&_initp->whoami, MyNid(0));
	ifcntrs = _initp->ifcntr;
	ifEntryInit(ifcntrs, _initp->ifNumber);
	/*
	 *	Create the mail boxes for the receiving tasks
	 */
	CreatMailbox(&ReceiveMbox);
	CreatMailbox(&IpReceiveMbox);
	/* start up the demultiplexing task. */
	nim_rcv_stack = (word *)hmalloc(NIM_RCV_STACK_SIZE);
	nim_iprcv_stack = (word *)hmalloc(NIM_IPRCV_STACK_SIZE);
	/*
	 *	K Kong	4.14.92
	 *	Check for the return values.
	 */
	if (nim_rcv_stack == NULL || nim_iprcv_stack == NULL)
		{
		printf("Error: malloc fails on nim_rcv stack\n");
		return 1;
		}
	CreatTask(nim_rcv, nim_rcv_stack, NIM_RCV_STACK_SIZE, NULL);
	CreatTask(nim_iprcv, nim_iprcv_stack, NIM_IPRCV_STACK_SIZE, NULL);
	return 0; 
	}


/* 
 * Shutdown the ethernet interface 
 */
nim_close()
	{
	chnl_stop(0);
	}
/*
 *	Clear the if counters
 */
IfClearCounters()
	{
	IF_ENTRY	*ifp = ifcntrs;
	int	ifNumber = _initp->ifNumber;

	while(ifNumber--)
		{
		ifp->ifLastChange = 0;
		ifp->inbytecnt = 0;			
		ifp->inucastpkts = 0;			
		ifp->inbmcastpkts = 0;			
		ifp->inDiscards = 0;			
		ifp->inerrpkts = 0;			
		ifp->inunknwnpkts = 0;			
		ifp->outbytecnt = 0;			
		ifp->outucastpkts = 0;			
		ifp->outbmcastpkts = 0;			
		ifp->outerrpkts = 0;			
		ifp->outdiscardpkts = 0;		
		ifp++;
		}
	}

