/**
 *	Program Name:	RIP program
 *
 *	Filename:	rip.c
 *
 *	$Log:   /b/gregs/i960/tcpip/rip/rip.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:42:22   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:06   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:16:06   gregs
 * Initial revision.
 * 
 *    Rev 1.5   22 Dec 1992 09:32:34   ramki
 * Changed RIP packet handling. We only need to check whether we are
 * receiving the RIP packets from the router. There is no need to analyse
 * the packet.
 * 
 *    Rev 1.4   28 Jul 1992 15:17:10   ramki
 * Removed the rttbl and made it part of initp structure
 * 
 *    Rev 1.3   16 Jun 1992 17:33:14   vinay
 * changed back to rev 1.1
 * 
 *    Rev 1.2   16 Jun 1992 15:02:06   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.1   08 May 1992 14:25:46   ramki
 * Fixed the router problem
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
/*
 *	We listens to the RIP packets such that we can tell if
 *	the routers are up or down.
 */

#include <krnl.h>
#include <types.h>
#include <netbuf.h>
#include <ether.h>
#include <icmp.h>
#include <ip.h>
#include <udp.h>
#include <sockets.h>
#include <tcpip.h>
/***
#include "internal.h"
**/


#define RIP_TIMEOUT 60   /* 60 2-seconds ticks */

#define	RIP_VERSION	1	/* we support version 1	*/

#define	RIP_REQUEST	1	/* request command	*/
#define	RIP_RESPONSE	2	/* reponse command	*/

#define	RIP_FAMILY_IP	2	/* address family 2 is ip	*/

#define	TWO_SECONDS_TICKS	200

typedef struct riph
	{
	byte	command;
	byte	version;
	u_short	zero;
	}
	RIPH;

#define	SIZEOF_RIPH	4

typedef struct rip_entry
	{
	u_short	address_id;
	u_short	zero1;
	in_name	ipaddress;
	long 	zero2;
	long	zero3;
	long	metric;
	}
	RIP_ENTRY;

#define	SIZEOF_RIP_ENTRY	20

TIMER	RipTimer;
TIMER	RipTimer2;


static UdpRipReceiver(PACKET p, int length, in_name fhost, 
	uint sport, uint dport, void *tag);
static void	RipAliveTimer(void *tag);

static UDPCONN	RipCon;	/* remember my udp connection	*/

RipInit()
{
	
	if ((RipCon = udp_open(UDP_RIP, UdpRipReceiver, NULL)) == NULL)
	{
		printf("Error: Cannot register RIP with UDP\n");
		return 1;
	}
	if((_initp->net_gway) == 0)
		_initp->gway1Metric = 16;
	else
		_initp->gway1Metric = 0;
	if(_initp->net_gway2 == 0)
		_initp->gway2Metric = 16;
	else
		_initp->gway2Metric = 0;
	_initp->gway1Timeout = _initp->gway2Timeout = 0;
	CreatTimer(&RipTimer);
	CreatTimer(&RipTimer2);
	return 0;
}

/*
 *	Check if router 1 is still alive
 */
static void RipAliveTimer(void *tag)
{
	if (_initp->gway1Timeout)
	{
		/*
		 *	If we haven't heard from this router for
		 *	a long time, then we have to say it is
		 *	inactive and clear the redirect table.
		 */
		if (--_initp->gway1Timeout == 0)
			_initp->gway1Metric = 16;
		else
			StartTimerCall(&RipTimer, TWO_SECONDS_TICKS, RipAliveTimer, NULL);
	}
}

/*
 *	Check if router 2 is still alive
 */
static void RipAliveTimer2(void *tag)
{
	if (_initp->gway2Timeout)
	{
		/*
		 *	If we haven't heard from this router for
		 *	a long time, then we have to say it is
		 *	inactive.
		 */
		if (--_initp->gway2Timeout == 0)
			_initp->gway2Metric = 16;
		else
			StartTimerCall(&RipTimer2, TWO_SECONDS_TICKS, RipAliveTimer2, NULL);
	}
}


/*
 *	The up call from udp
 */

UdpRipReceiver(p, length, fhost, sport, dport, tag)
PACKET	p;
int	length;
in_name	fhost;
uint	sport;
uint	dport;
void	*tag;
{
	RIPH	*prip = (RIPH *)p->nb_prot;
	RIP_ENTRY	*pripet;
	int 	ll;	/* length of data remained in packet	*/
	long	ip;    	/* copy of the ipaddress in RIP_ENTRY	*/
	long	metric = 1;	/* metric in RIP_ENTRY			*/
	long	timeout;/* timeout value */

	if((sport != UDP_RIP) || (dport != UDP_RIP))
	{
		udp_free(p);
		return;
	}
	if (prip->command == RIP_RESPONSE && prip->version >= RIP_VERSION)
	{
/**** NO NEED TO VALIDATE THE ROOUTES
 **** WE JUST CHECK WHETHER THE ROUTER IS ALIVE OR NOT
		pripet = (RIP_ENTRY *)(p->nb_prot + SIZEOF_RIPH);
		ll = length - SIZEOF_RIPH;
		while (ll > 0)
		{
			pripet->address_id = ntohs(pripet->address_id);
			if (pripet->address_id == RIP_FAMILY_IP)
			{
				* it is IP address *
				ipcopy(&ip, &pripet->ipaddress);
				if(ip == 0L)
				{
					ipcopy(&metric, &pripet->metric);
					metric = ntohl(metric);
					timeout = RIP_TIMEOUT;
					break;
				}
			}
			ll -= SIZEOF_RIP_ENTRY;
			*
			 *	pripet points to the next entry
			 *	Do not do "pripet++" to increment pripet
			 *	to point to the next element as 
			 *	sizeof(RIP_ENTRY) is not equal to the 
			 *	unpadded size of the rip entry for the 960.
			 *
			pripet = (RIP_ENTRY *)((byte *)pripet + SIZEOF_RIP_ENTRY);
		}
*************************/
	}  /* end of valid command */
	else
	{
		udp_free(p);
		return;
	}

	/*   
	 *	if this is a RIP update message
	 *	transmitted by one of routers that we know
	 *	update the metric and timeout.
	 */
	if (fhost ==  _initp->net_gway)
		/* from the primary router */
	{
		_initp->gway1Metric = metric;
		_initp->gway1Timeout = timeout;
		StartTimerCall(&RipTimer, TWO_SECONDS_TICKS, RipAliveTimer, NULL);
	}
	else if (fhost ==  _initp->net_gway2)
		/* from secondary router */
	{
		_initp->gway2Metric = metric;
		_initp->gway2Timeout = timeout;
		StartTimerCall(&RipTimer2, TWO_SECONDS_TICKS, RipAliveTimer2, NULL);
	}
	udp_free(p);
}
