
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	buffer.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/buffer.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:43:18   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:36   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:16:56   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:26:36   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/
#include <asn1.h>
#include <libfuncs.h>
#include <localio.h>
#include <buffer.h>

/****************************************************************************
*
*NAME:  EBufferSetup
*
*PURPOSE:  Setup a buffer to receive ASN.1 encoded data
*
*PARAMETERS:
*	    unsigned int    BFL_xxx flags from buffer.h
*	    EBUFFER_T *	    Buffer descriptor
*         OCTET_T *       Address of the buffer
*         ALENGTH_T       Length of the buffer
*
*RETURNS:    Nothing
*
*RESTRICTIONS:  
*
*BUGS:  
*****************************************************************************/
void
EBufferSetup(ebufp,addp,len)
EBUFFER_P ebufp;
OCTET_P addp;
ALENGTH_T len;
{
	ebufp->start_bp=(OCTET_P )addp;
	ebufp->next_bp=(OCTET_P)addp;
	ebufp->remaining=(ALENGTH_T)len;
}


/****************************************************************************

NAME:  EBufferPreLoad

PURPOSE:  Pre-load data into a buffer

PARAMETERS:
	    unsigned int    BFL_xxx flags from buffer.h
	    EBUFFER_T *	    Buffer descriptor
            OCTET_T *       Address of the buffer containing the data
            ALENGTH_T       Length of the data

RETURNS:    Nothing

RESTRICTIONS:  

BUGS:  
****************************************************************************/
void
EBufferPreLoad(ebufp,addp,len,maxlen)
EBUFFER_P ebufp;
OCTET_P addp;
ALENGTH_T len;
ALENGTH_T maxlen;
{
	ebufp->start_bp=(OCTET_P )addp;
	ebufp->next_bp=(OCTET_P)(addp+(ALENGTH_T)len);
	ebufp->remaining=(ALENGTH_T)(maxlen-len);
}


/****************************************************************************

NAME:  EBufferUsed

PURPOSE:  Indicate how many octets are currently in the buffer.

PARAMETERS:
	    EBUFFER_T *	    Buffer descriptor

RETURNS:    ALENGTH_T	    Number of octets used.

RESTRICTIONS:  

BUGS:  
****************************************************************************/
ALENGTH_T
EBufferUsed(ebufp)
EBUFFER_P ebufp;
{
	return (ALENGTH_T)(ebufp->next_bp - ebufp->start_bp);
}

