
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	getpdu.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/getpdu.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:43:26   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:42   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:16:58   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:26:40   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#include <types.h>
#include <libfuncs.h>
#include <asn1.h>
#include <buffer.h>
#include <decode.h>
#include <snmp.h>
#include <mib.h>
#include <objectid.h>
#include <syteksnm.h>


#define	ENTER_CRITICAL_SECTION
#define	LEAVE_CRITICAL_SECTION


static	int	call_the_get_routine(VB_P , MIBLOC_T *, int);

/****************************************************************************
NAME:  Process_SNMP_GetClass_PDU

PURPOSE:  Process a Get Class PDU -- given a decoded Get or GetNext PDU,
	  obtain the requested variables and generate a response PDU.

PARAMETERS:
	SNMP_PKT_T *	The decoded Get PDU
	SNMP_PKT_T *	The pre-formed GET RESPONSE PDU
	EBUFFER_T *	Buffer where the resulting PDU should be placed.
			The memory to hold the PDU will be dynamically
			allocated.
	int		SNMP access privilege

RETURNS:  int		0 if things went OK and a reasonable packet is
			in the result buffer.  This DOES NOT mean that
			no errors have occurred -- the result buffer might
			contain an error response packet according to the
			SNMP protocol.
			-1 some sort of error has occurred, the result
			buffer should not be considered to hold a valid
			SNMP packet.

NOTE: For GET_NEXT_REQUEST PDUs there is a critical zone between the
      time that the "next" object identifier is ascertained and the time
      that the value for that object is obtained.  It is important that
      the identifier remain valid during this interval.

      The ENTER_CRITICAL_SECTION and LEAVE_CRITICAL_SECTION macros
      designate when this interval exists.  The macros are a bit over-
      inclusive -- For GET_REQUEST PDUs the interval exists only between
      the time of the call to testproc and the time the value is obtained.
****************************************************************************/
int
Process_SNMP_GetClass_PDU(pktp,  ebuffp, priv)
SNMP_PKT_P	pktp;
EBUFFER_P	ebuffp;
int		priv;
{
	register VB_P	vbp;
	register VB_P	new_vbp;
	register int vbno;
	register int indx;

	vbp = pktp->pdu.std_pdu.std_vbl.vblist;
	if ((vbno = pktp->pdu.std_pdu.std_vbl.vbl_count) != 0)
	{
		for (indx = 0; indx < vbno; indx++,vbp=vbp->next)
		{
			MIBLOC_T ml;
			int error_code;
			ENTER_CRITICAL_SECTION;
			if (pktp->pdu_type == GET_NEXT_REQUEST_PDU)
			{
				snmp_count->ingetnextreq++;
				if ( (error_code=find_next_object(
				    (VB_P)vbp,priv)) != 0)
				{
					LEAVE_CRITICAL_SECTION;
					/*** AWC 11/30/90 */
					/*printf("find_next_object error\n");*/
					Prepare_Error_Resp(pktp,error_code,indx+1);
					return SNMP_Encode_Packet((SNMP_PKT_P)pktp,(EBUFFER_P)ebuffp);
				}
				continue;
			}
			else
			{ /* Assume GET_REQUEST_PDU */
				snmp_count->ingetreq++;

				/*		   print_object(vbp);  */
				if(find_object_node((OBJ_ID_T  *)&(vbp->vb_obj_id),&ml)==0)
				{
					if (ml.ml_flags & ML_IS_LEAF)
					{
						/* Check whether the object is accessable	*/
						/* For tabular variables, the object may not	*/
						/* even exist.  We only do this for GET	*/
						/* REQUEST PDUs and not GET NEXT REQUESTs	*/
						/* because we assume that the find_next has	*/
						/* returned a valid identifier.		*/
						/* It is expected that the object will	*/
						/* remain accessable until the actual value	*/
						/* is retrieved by call_the_get_routine.	*/
						vbp->vb_data_flags_n_type = ml.ml_leaf->expected_tag;
						/*printf("Calling the call_get_routine\n");*/
						if ((error_code=call_the_get_routine((VB_P)vbp,&ml,
						    priv))!= 0)
						{
							LEAVE_CRITICAL_SECTION;
							/*printf("call_the_get_routine error\n");*/
							Prepare_Error_Resp(pktp,error_code,indx+1);
							return SNMP_Encode_Packet((SNMP_PKT_P)pktp,
							    (EBUFFER_P)ebuffp);
						}
						LEAVE_CRITICAL_SECTION;

						continue;
					}
				}

				/* Couldn't locate a node or the found node is NOT a leaf */
				LEAVE_CRITICAL_SECTION;
				/*printf("Can not locate the object\n");*/
				Prepare_Error_Resp(pktp,NO_SUCH_NAME,indx+1);
				return SNMP_Encode_Packet((SNMP_PKT_P)pktp,(EBUFFER_P)ebuffp);
			}
		}
	}
	pktp->pdu_type = GET_RESPONSE_PDU;
	if (SNMP_Bufsize_For_Packet((SNMP_PKT_P)pktp) > SNMP_MAX_PACKET_SIZE)
	{
		/*printf("Packet size is too big\n");*/
		Prepare_Error_Resp(pktp,TOO_BIG,0);
		return SNMP_Encode_Packet((SNMP_PKT_P)pktp,(EBUFFER_P)ebuffp);
	}
	/*  we have got response packet in new_pkt and we don't need pktp
	**  anymore, so we need to all the allocated object id buffer back 
	**	to the link list */
	snmp_count->inreqvar += vbno;
	/*printf("Calling Encode_Packet\n");*/
	return SNMP_Encode_Packet((SNMP_PKT_P)pktp,(EBUFFER_P)ebuffp);
}

/****************************************************************************
NAME:  call_the_get_routine

PURPOSE:  Once a leaf node is located, this routine will invoke the get
	  routine referenced by the node.

	  The get routine reference by a node MUST match the data type
	  of the node as expressed by variable "expected_tag" in the node.

PARAMETERS:

RETURNS:  int		0 if things went OK.
			-1 if some sort of error has occurred.
****************************************************************************/
static
int
call_the_get_routine(vbp, ml,priv)
VB_P		vbp;
MIBLOC_T	*ml;
int         priv;
{
	register MIBLEAF_P	leaf;
	register int rtn_code;
	int	length=0;

	leaf = ml->ml_leaf;
	if ( !(leaf->access_type & READ_ACCESS) )
		return WRITE_ONLY;

	if(snmp_access() != SNMP_ACC_COMMUNITY)
		if(!CheckPrivilege(leaf->windx,priv))
/********
		if(boot2->cmdpriv[leaf->windx] > priv)
********/
			return NO_SUCH_NAME;
	switch (leaf->expected_tag)
	{
	case VT_NUMBER:
	case VT_COUNTER:
	case VT_GAUGE:
	case VT_TIMETICKS:
	case VT_IPADDRESS:
		if ( (rtn_code = (*(leaf->svcproc))(
		    SNMP_GET,
		    (byte  *)&ml->ml_remaining_objid.num_components,
		    (unsigned int  *)ml->ml_remaining_objid.component_list,
		    (int  *)&length,
		    (INT_32_T  *)&(vbp->value_u.v_number),
		    priv)) != 0 )
			return rtn_code;

		break;
	case VT_STRING:
	case VT_OPAQUE:
		{
			OCTET_P	cp;
			if ( (cp = (OCTET_P)alloc_mem(1)) == (OCTET_P)0)
				return TOO_BIG;
			if ( (rtn_code = (*(leaf->svcproc))(
			    SNMP_GET,
			    (byte  *)&ml->ml_remaining_objid.num_components,
			    (unsigned int  *)ml->ml_remaining_objid.component_list,
			    (int  *)&length,(OCTET_P)cp,
			    priv)) != 0)
				return rtn_code;
			/* update free buffer pool  pointer */
			alloc_mem(length-1);
			EBufferPreLoad((EBUFFER_P)&(vbp->value_u.v_string),
			    (OCTET_P)cp, length,length);
			break;
		}
	case VT_OBJECT:
		if ((vbp->value_u.v_object.component_list =
		    (unsigned int  *)alloc_mem(1)) == (unsigned int  *)0)
			return TOO_BIG;
		if ( (rtn_code = (*(leaf->svcproc))(
		    SNMP_GET,
		    (byte  *)&ml->ml_remaining_objid.num_components,
		    (unsigned int  *)ml->ml_remaining_objid.component_list,
		    (int  *)&length,
		    (unsigned int  *)vbp->value_u.v_object.component_list,
		    priv)) != 0)
			return rtn_code;
		else
		{
			vbp->value_u.v_object.num_components=length/sizeof(unsigned int);
			/* update free buffer pool pointer */
			alloc_mem(length - 1);
		}
		break;
	case VT_EMPTY:
		break;
	default:
		break;
	}
	return 0;
}

/*****************************************************************
**
**    Prepare_Error_Resp(pktp,index,error_code)
******************************************************************/
Prepare_Error_Resp(pktp,error_code,index)
SNMP_PKT_P	pktp;
int index;
int error_code;
{
	switch(error_code){
	case TOO_BIG:
		snmp_count->outtoobig++;
		break;
	case NO_SUCH_NAME:
		snmp_count->outnosuch++;
		break;
	case READ_ONLY:
		snmp_count->outreadonly++;
		break;
	case BAD_VALUE:
		snmp_count->outbadvalue++;
		break;
	case GEN_ERR:
		snmp_count->outgenerr++;
	}
	pktp->pdu_type = GET_RESPONSE_PDU;
	pktp->pdu.std_pdu.error_status = error_code;
	pktp->pdu.std_pdu.error_index = index;
}
