
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	localio.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/localio.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:43:26   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:44   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:16:58   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:26:42   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/****************************************************************************
 *     Copyright (c) 1986, 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#include <libfuncs.h>
#include <localio.h>

/****************************************************************************
Local I/O package -- performs I/O like operations on data in a buffer.

Caveat: This version supports only input operations.
****************************************************************************/

/****************************************************************************
Lcl_Open -- Open a buffer for use as a local I/O stream

Parameters:
        LCL_FILE *	lfile
	POINTER  		buffer
	int		nbytes

If lfile == (LCL_FILE *)0 a local file descriptor will be allocated.

Returns: (LCL_FILE *) if sucessful, (LCL_FILE *)0 if unsucessful.
****************************************************************************/
void Lcl_Open(lfile, buff, nbytes)
LCL_FILE    *lfile;
POINTER buff;
int			nbytes;
{
	if (lfile != (LCL_FILE  *)0)
	{
		lfile->lcl_flags = 0;
		lfile->lbuf_start = buff;
		lfile->lbuf_next = buff;
		lfile->lbuf_end = buff + nbytes;
	}
}


/****************************************************************************
Lcl_Getc -- Read a character from a local I/O stream

Parameters:
        LCL_FILE *	lfile

Returns: If sucessful: the character read, but in integer format
	 If unsucessful: -1
****************************************************************************/
int
Lcl_Getc(lfile)
register LCL_FILE *lfile;
{
	if (lfile->lcl_flags & LCL_EOF) return -1;
	if (lfile->lbuf_next < lfile->lbuf_end)
		return (*(lfile->lbuf_next++));
	else {
		lfile->lcl_flags |= LCL_EOF;
		return -1;
	}
	/* NOTREACHED */
}

/****************************************************************************
Lcl_Peekc -- Peek at a character from a local I/O stream, the seek pointer
	     is not advanced.

Parameters:
        LCL_FILE *	lfile

Returns: If sucessful: the character read, but in integer format
	 If unsucessful: -1
****************************************************************************/
int
Lcl_Peekc(lfile)
register LCL_FILE *lfile;
{
	if (lfile->lcl_flags & LCL_EOF) return -1;
	if (lfile->lbuf_next < lfile->lbuf_end)
		return (*(lfile->lbuf_next));
	else {
		lfile->lcl_flags |= LCL_EOF;
		return -1;
	}
	/* NOTREACHED */
}

/****************************************************************************
Lcl_Read -- Read a set of characters from a local I/O stream.

Parameters:
        LCL_FILE *	lfile
	uchar *		ubuf
	int		nbytes

Returns: The number of bytes actually read.
****************************************************************************/
int
Lcl_Read(lfile, ubuf, nbytes)
LCL_FILE	*lfile;
POINTER	    ubuf;
int		nbytes;
{
	/* This is a quick implementation, to be replaced later */
	int orig_nbytes = nbytes;
	uchar c;
	while (nbytes > 0)
	{
		c = Lcl_Getc(lfile);
		if (Lcl_Eof(lfile)) break;
		*ubuf++ = c;
		--nbytes;
	}
	return (orig_nbytes - nbytes);
}

/****************************************************************************
Lcl_Seek -- Move the seek pointer to a give position in the local I/O buffer.

Parameters:
        LCL_FILE *	lfile
	int		offset
	int		whence:
			0 to set pointer to offset bytes from the start
			1 to move pointer by offset bytes
			2 to set pointer to offset bytes from the end

Returns: 0 if sucessful, -1 if not.

Note: The "end" position is the byte AFTER the last one in the buffer
containing data.  Thus, a Lcl_Seek(.., 0, 2) will leave the caller at
the end-of-file.  The last byte is reached by Lcl_Seek(.., 1, 2).
****************************************************************************/
int
Lcl_Seek(lfile, offset, whence)
register LCL_FILE	*lfile;
int			offset;
int			whence;
{
	POINTER next;

	switch (whence)
	{
	case 0:
		next = (POINTER )(lfile->lbuf_start + offset);
		break;
	case 1:
		next = (POINTER )(lfile->lbuf_next + offset);
		break;
	case 2:
		next = (POINTER )(lfile->lbuf_end - offset);
		break;
	default:
		return -1;
	}

	if ((next < lfile->lbuf_start) || (next > lfile->lbuf_end)) return -1;

	if (next < lfile->lbuf_end) lfile->lcl_flags &= ~LCL_EOF;
	lfile->lbuf_next = next;
	return 0;
}

/****************************************************************************
Lcl_Resize -- Move the end-of-buffer position for the local I/O buffer.
	      The buffer may be extended or contracted.

Parameters:
        LCL_FILE *	lfile
	int		offset
	int		whence:
			0 to set new end to offset bytes from the start
			1 to move new end by offset bytes from the current
			  read/write position
			2 to set new end to offset bytes from the end

Returns: Previous value (relative to the start of the file).
	 -1 indicates an error.
****************************************************************************/
int
Lcl_Resize(lfile, offset, whence)
register LCL_FILE	*lfile;
int			offset;
int			whence;
{
	int	oldval;

	oldval = lfile->lbuf_end - lfile->lbuf_start;

	switch (whence)
	{
	case 0:
		lfile->lbuf_end = (POINTER )(lfile->lbuf_start + offset);
		break;
	case 1:
		lfile->lbuf_end = (POINTER )(lfile->lbuf_next + offset);
		break;
	case 2:
		lfile->lbuf_end = (POINTER )(lfile->lbuf_end - offset);
		break;
	default:
		return -1;
	}

	if (lfile->lbuf_next < lfile->lbuf_end)
		lfile->lcl_flags &= ~LCL_EOF;
	else lfile->lcl_flags |= LCL_EOF;

	return oldval;
}
