/**			       
*
*	Program Name:	tcp module
*
*	Filename:	tcp.c
*
*	$Log:   /b/gregs/i960/tcpip/tcp/tcp.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:10   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:16   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:56   gregs
 * Initial revision.
 * 
 *    Rev 1.1   08 May 1992 13:29:08   ramki
 * Added the function tcp_new_wind and changed it to send the window opening
 * packet after ack is received
 * 
 *    Rev 1.0   08 May 1992 13:26:28   ramki
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		7.26.91
*
*	Version:	1.2
*
*	Programmers:	not known
*
*	Modifications:	K Kong	4.19.91
*			Port to the 80960 platform. 
*			i.e.	remove "far", int is 32 bit ...etc
*			We cannot assign/extract sequence number and
*			the ack number to/from the communictaion buffer
*			(PACKET) as they may not be properly aligned.
*			We have to copy them out two bytes at a time before 
*			we manipulate them.
*
*			K Kong	5.14.91
*			Do not use sizeof() operator to get the the size
*			of tcp header (struct tcp) and tcp pseudo header
*			(struct tcpph) as it will give the size of the
*			structure with padded data. What we really 
*			want is the unpadded size.
*			TCP_SIZE and TCPPH_SIZE are the unpadded size of
*			struct tcp and struct tcpph respectively.
*
*			K Kong	7.26.91
*			Do not pass the destination NID and firsthop 
*			ip address to "in_write".  We should let the 
*			ip layer and the mac layer to find these out.
*			Anyway, the destination NID and firsthop ip are
*			not enough to reach the host we want to talk to.
*			We have multi-ports and we have to know which port
*			the the host is on.
*
*			Ramki 2-13-92
*			Made changes to pass and accept the local host address
*
*			Ramki 5-8-92
*			Added the function tcp_new_wind. The window opening 
*			packet should be sent only after the ack is received
*			else it will result in invalid sequence number
*
*	Comments:	This file contains the functions to send 
*			the tcp segment.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * tcp.c - Top of transmit side of Multiple-Connection TCP
 *
 * Copyright (C) 1986, 1987 by FTP Software, Inc.
 *
 * Edit History
 * 26-Aug-86	1.1x02	jbvb	THe big one - output queueing.
 * 02-Sep-86	1.1x05	jbvb	tcp-close() should let ack logic do its thing
 *				 Improve/repair statistics.
 * 04-Sep-86	1.1x07	jbvb	Try not to use up all packet buffers.
 * 10-Sep-86	2.0	jbvb	Cleaned up for PC/TCP release 2.0
 * 13-Oct-86	2.0	jbvb	tc_clrs() shouldn't reply to packets w/reset
 * 02-Nov-86	2.0	jbvb	twrite(): use 1st buffer when possible, always
 *				 fill last buffer on q before getting new one.
 * 05-Dec-86	2.0	jbvb	Don't mung output queue while locked.
 * 09-Dec-86	2.0	jbvb	Install buffering for tputc()
 * 14-Dec-86	2.0	jbvb	tcp_write() returns TRUE if all data sent
 * 23-Dec-86	2.1x01	jbvb	Adaptive retransmit time for tcp_close()
 * 26-Dec-86	2.1x02	jbvb	Free saved_pkt (if present) in tcp_clean()
 * 28-Dec-86	2.1x03	jbvb	tcp_write() now probes 0-length window
 * 30-Dec-86	2.1x04	jbvb	Add packet-filling heuristic to tcp_write()
 * 02-Jan-87	2.1x05	jbvb	Changes to dally_ack() logic, tcp_write()
 * 04-Jan-87	2.1x06	jbvb	Add wakeup alarm for tcp_write() w/0-window
 * 07-Jan-87	2.1x07	jbvb	Use memcpy() to fill buffers in tcp_write()
 * 08-Jan-87	2.1x08	jbvb	Drop RTT when probe acked, better validation
 *				 and error handling in tcp_close()
 * 23-Feb-87	2.1x09	jbvb	Don't include tputc, tputs, tprintf in kernel
 * 11-Mar-87	2.1x10	jbvb/dab Fix *obscure* bug: sending pkts out of seq.
 * 02-Apr-87	2.1x11	jbvb	Correct above, by updating remaing length 1st.
 * 19-Apr-87	2.1x12	jbvb	tcp_urgent(), tcp_ex() set SendReason to
 *				 NEWDATA (so send task won't get confused).
 * 20-Sep-87	2.1x13	jbvb	Don't print "write to un-opened connection"
 *				 unless debugging turned on.
 * 27-Sep-87		romkey	Changed so that data pointer in tcp_write()
 *				 was not a register variable in KERNEL.
 * 27-Sep-87		romkey	Put change to tcp_gen_socket() back in.
 * MOD:BLL tcp_resolve_con - supports listen to anybody.
 */


/*LINTLIBRARY*/

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <ether.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <error.h>
#include "internal.h"



/*  Copyright 1983 by the Massachusetts Institute of Technology  */
/*  Copyright 1984,1985 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

/*
 * This TCP is built around the PC/TCP tasking package.  There is one task:
 * TCPsend, which handles all data transmission.  The incoming data is
 * handled and passed to the user by tcp_rcv() which is upcalled from
 * internet on an arriving packet.  It now pays attention to the foreign
 * window (and will block the sending process when necessary), handles
 * "dally" acking correctly.
 */

/* Convert from host order to Network order */

void tcp_swab_hton(pkt)
struct	tcp	*pkt;  /* ptr to tcp packet to be swapped */

	{	
	ulong	seq_no;
	ulong	ack_no;

	/*
	 *	Copy seq number and the ack number out before
	 *	we swap them as they may not be properly
	 *	aligned.
	 */
	SeqCopy(&seq_no, &pkt->tc_seq);
	SeqCopy(&ack_no, &pkt->tc_ack);
	seq_no = htonl(seq_no);
	ack_no = htonl(ack_no);
	SeqCopy(&pkt->tc_seq, &seq_no);
	SeqCopy(&pkt->tc_ack, &ack_no);
	pkt->tc_srcp = htons(pkt->tc_srcp);
	pkt->tc_dstp = htons(pkt->tc_dstp);
	pkt->tc_win  = htons(pkt->tc_win);
	pkt->tc_urg  = htons(pkt->tc_urg);
	}

/* Convert from Network order to Host order */

void tcp_swab_ntoh(pkt)
struct	tcp	*pkt;  /* ptr to tcp packet to be swapped */

	{	
	ulong	seq_no;
	ulong	ack_no;

	/*
	 *	Copy seq number and the ack number out before
	 *	we swap them as they may not be properly
	 *	aligned.
	 */
	SeqCopy(&seq_no, &pkt->tc_seq);
	SeqCopy(&ack_no, &pkt->tc_ack);
	seq_no = ntohl(seq_no);
	ack_no = ntohl(ack_no);
	SeqCopy(&pkt->tc_seq, &seq_no);
	SeqCopy(&pkt->tc_ack, &ack_no);
	pkt->tc_srcp = ntohs(pkt->tc_srcp);
	pkt->tc_dstp = ntohs(pkt->tc_dstp);
	pkt->tc_win  = ntohs(pkt->tc_win);
	pkt->tc_urg  = ntohs(pkt->tc_urg);
	}



/*
 * name		tfwrite		queue TCP data for sending
 *
 * synopsis	tfwrite(con, data, len)
 *		TcpCon	con; <<		acted upon this connection
 *		byte	*data; <<	data pointer
 *		int	len; <<		length of "data" in number of bytes
 *
 * description	It queues up the TCP data in the DBD buffer and wakes up
 *		the TCP send task to transmit data.
 *
 * returns	0	if data has been copied to the DBD buffer and queued
 *			for transmission
 *		other	error number
 */

tfwrite(con, data, len)
TcpCon   con;
byte	*data;
uint	len;
	{
	register PACKET	p_ptr;		/* pointer to packet in hand	*/
	byte	*tp;			/* points to the tcp header	*/

	/* test connection and request size */
	if (!tcp_is_open(con)) 	/* if connection isn't open */
		return ERR_NOTCONN;
	if (len > con->max_data)
		return OUT_OF_RANGE;
	if (len > con->frn_win)
		return ERR_NORSRC;

	/* use old buffer or get new one */
	p_ptr = (PACKET) con->out_q.mb_mblink; /* empty buf in q? */
	if (len > con->max_data - p_ptr->nb_len)
		{
		if ((p_ptr = get_x_buf()) == NULL)
			{
			return ERR_NORSRC;
			}
		p_ptr->nb_flags = con->tc_flags;	/* load pkt flags */
		p_ptr->nb_seq = con->out_q_seqn;	/* load seq # */
		enqueue((MSGHDR *)p_ptr, (MBOX *)&con->out_q);	/* & enque */
		}

	/* We've got a buffer, & know how much to put in it */
	tp = (byte *)in_data(in_head(p_ptr));
	memcpy(tp + TCP_SIZE + p_ptr->nb_len, data, len);
	p_ptr->nb_len += len;	/* Adjust size of packet, */
	con->out_q_seqn += len;	/*  update saved seq., */
	con->frn_win -= len;	/*  count bytes we wrote, */
	((TCP_CON_ENTRY *)con->tc_stats)->snd_window = con->frn_win;

	/* send packet */
	p_ptr->nb_flags &= ~PKT_SENTOUT;	/* this packet has new data */
	tcp_newdata(con);	/* wake send task for last (or only) buffer */
	return 0;	/* aok */
	}



/* Indicate the presence of urgent data.  Just sets the urgent pointer to
 * the current data length and wakes up the sender.
 */

/*
 * name		tcp_urgent		Indicate urgent data
 *
 * synopsis	tcp_urgent(con)
 *		TcpCon	conl; <<	acted upon this connection
 *
 * description	Indicates  the presence of urgent data. It sets the
 *		urgent pointer to the current data length and wakes up
 *		the sender task.
 *
 * returns	nothing
 */


void tcp_urgent(con) 
register TcpCon con;
	{
	register PACKET p_ptr;

	p_ptr = (PACKET) con->out_q.mb_mblink;
	p_ptr->nb_urg = p_ptr->nb_len;
	p_ptr->nb_furg = 1;
	tcp_newdata(con);
	}

/* Initiate the TCP closing sequence.  This routine will return immediately;
 * when the close is complete the user close function will be called.
 *
 * Returns TRUE if connection could be closed, FALSE if non-existent or
 * not in a state where close is possible.
 */

/*
 * name		tcp_close	initialize the TCP closing sequence
 *
 * synopsis	tcp_close(con)
 *		TcpCon	con; <<	acted upon this connection
 *
 * description	It initailizes the TCP closing sequence.  It returns to 
 *		the caller immediately.  When the closing is complete, the
 *		user upcall "tn_up_close" will be called.
 *
 * returns	TRUE	if connection can be closed
 *		FALSE	if non-existent connection or not in a state where
 *			close is possible.
 */

int tcp_close(con)
register TcpCon con;
	{
	register TcpCon cn2;

	/* verify that connection is present */
	for (cn2 = tcp_list.tc_flink; cn2 != &tcp_list; cn2 = cn2->tc_flink)
		if (cn2 == con)
			break;
	if (cn2 == &tcp_list)
		return(FALSE);	/*  return an error */

	switch(con->conn_state) 
		{
	case ESTAB:
	case SYNRCVD:	
		con->conn_state = FINSENT;
		((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;
		break;
	case FINRCVD:	
		con->conn_state = R_AND_S;
		((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;
		break;
	default: 	
		return(FALSE);
		}

	/* send the FIN packet */
	con->retry_time *= 4;		/* quadruple retry time for close */
	((PACKET)con->out_q.mb_mblink)->nb_fin = 1;
	if((PACKET)con->out_q.mb_mflink  == (PACKET)con->out_q.mb_mblink)
         /* if this is the only packet in output queue */
	     ((PACKET)con->out_q.mb_mblink)->nb_flags &= ~PKT_SENTOUT;
	con->out_q_seqn++;			/* count the FIN bit */
	tcp_newdata(con);			/* run q from tail????? */
	return(TRUE);
	}

/* expedite (resend and push) a packet */
void tcp_ex(con)
TcpCon	con;

	{
	((PACKET)con->out_q.mb_mblink)->nb_psh = 1;
	tcp_newdata(con);
	}

/* Handle a retransmit timer upcall. */
void tmhnd(con)
TcpCon con; 
	{ 
	con->tc_mustrun |= TC_RUN_SEND_DATA;	/* send data */
	SendSignal(&TcpSendSem);
	}

/* Handle a timewait done timer upcall. */
void tmwat(con)
TcpCon con; 
	{ 
	tcp_clean(con, ERR_TIMEOUT);	/* graceful */
	}

/* Closes and resets whoever just talked to you with packet p */
void tc_clrs(p, fhost, lhost)
PACKET p;
in_name fhost; 
in_name lhost;
	{
	unsigned myport;
	struct tcp	*ptp;
	struct tcpph php;
	ulong	seq_no;
	ulong	ack_no;

	/*
	 *	Copy seq number and the ack number out before
	 *	we swap them as they may not be properly
	 *	aligned.
	 */
	ptp = (struct tcp *)in_data(in_head(p));
	SeqCopy(&seq_no, &ptp->tc_seq);
	SeqCopy(&ack_no, &ptp->tc_ack);

	if (ptp->tc_flags & RST_BIT)	/* If the other guy sent us a RESET */
		{
		in_free(p);	/* free the buffer */
		return;		/*  don't start a shouting match */
		}

	/* swap port numbers */
	myport = ptp->tc_dstp;
	ptp->tc_dstp = ptp->tc_srcp;
	ptp->tc_srcp = myport;

	/* fill in the rest of the header */
	SeqCopy(&ptp->tc_seq, &ack_no);
	seq_no += (ptp->tc_flags & SYN_BIT) ? 1 : 0;		/* ack his syn */
	SeqCopy(&ptp->tc_ack, &seq_no);	
	/***
	ptp->tc_thl = TCP_SIZE >> 2;
	ptp->tc_uu1 = 0;
	ptp->tc_fin = 0;
	ptp->tc_syn = 0;
	ptp->tc_rst = 1;	
	ptp->tc_psh = 1;
	ptp->tc_fack = 1;
	ptp->tc_furg = 0;
	ptp->tc_uu2 = 0;
	****/
	ptp->tc_thl = (TCP_SIZE >> 2) << THL_SHIFT;
	ptp->tc_flags = (RST_BIT | PSH_BIT | ACK_BIT);
	ptp->tc_win = 0;
	tcp_swab_hton(ptp);

	/* Set up the tcp pseudo header */
	php.tp_src = in_mymach(fhost,lhost);
	php.tp_dst = fhost;
	php.tp_zero = 0;
	php.tp_pro = TCPPROT;
	php.tp_len = ntohs(TCP_SIZE);

	/* checksum the packet */
	ptp->tc_cksum = cksum((byte *)&php, TCPPH_SIZE >> 1);
	ptp->tc_cksum = ~cksum((byte *)ptp, TCP_SIZE >> 1);
	if (ptp->tc_cksum == 0)
		ptp->tc_cksum = 0xffff;
	/* place packet for sending */
	p->db_actcnt = TCP_SIZE;	/* save pkt len for tx task */
	p->nb_seq = (unsigned long)fhost; 	/* save fhost for tx task */
	p->nb_con = lhost;	/* Save local host for tx task */
	SendMessage((MSGHDR *)p, &clrsMbox);
	SendSignal(&TcpSendSem);
	}

/*
 * Send an abort indication
 */

/*
 * name		tcp_abort	Sends an abort segment
 *
 * synopsis	tcp_abort(con)
 *		TcpCon	con; <<	acted upon this connection
 *
 * description	It sends an abort segment. i.e. A TCP segment with
 *		the RESET (RST) flag set.
 *
 * returns	non-zero	done
 *		0		error
 */


tcp_abort(con)
register TcpCon con;
	{
	register TcpCon cn2;
	PACKET p_ptr;
	struct tcp	*otp;
	uint	len;

	/* verify that connection is present */
	for (cn2 = tcp_list.tc_flink; cn2 != &tcp_list; cn2 = cn2->tc_flink)
		if (cn2 == con)
			break;
	if (cn2 != con)
		return 0;

	/* prepare and send an abort packet */
	if (p_ptr = (PACKET)dequeue(&con->out_q))
		{
		otp = (struct tcp *)in_data(in_head(p_ptr));
		otp->tc_srcp = con->srcport;		/* init header */
		otp->tc_dstp = con->dstport;
		SeqCopy(&otp->tc_seq, &con->out_q_seqn);/* load seq # */
		SeqCopy(&otp->tc_ack, &con->cur_ack);	/* load current ack */
		otp->tc_win = 0;
		/****
		otp->tc_thl = TCP_SIZE >> 2;
		otp->tc_fack = 1;
		otp->tc_rst = 1;
		otp->tc_psh = 1;
		***/
		otp->tc_thl = (TCP_SIZE >> 2) << THL_SHIFT;
		otp->tc_flags = (ACK_BIT | RST_BIT | PSH_BIT);
		tcp_swab_hton(otp);		/* swap the bytes */

		/* build checksum */
		con->ophp.tp_len = ntohs(TCP_SIZE);	/* Fill in TCP hdr */
		otp->tc_cksum =	cksum((byte *)&con->ophp, TCPPH_SIZE >> 1);
		otp->tc_cksum = ~cksum((byte *)otp, TCP_SIZE >> 1);

		if (otp->tc_cksum == 0)
			otp->tc_cksum = 0xffff;
		/* send packet */
		in_write(tcpfd, p_ptr, TCP_SIZE, con->fhost, con->lhost,
		         NULL, NULL);
		in_free(p_ptr);
		}
	tcp_clean(con, ERR_TIMEOUT);
	return 1;
	}

/*
 * the following 4 functions provide support so that 2 connections
 * may never LISTEN to the same port nor OPEN on the same socket.
 */

uint tcp_gen_socket() 
	{	/* generates an unused socket # >= 1000 */
	register TcpCon con;

	for (;;)
		{
		if (tcp_next_socket == 0)
			tcp_next_socket = 1200;

		for (con = tcp_list.tc_flink; con != &tcp_list; con = con->tc_flink)
			if (tcp_next_socket == con->srcport) 
				break;
		if (con == &tcp_list)
			return tcp_next_socket++;
		tcp_next_socket++; 
		}
	}


/*
 * finds an active connection on the (port,fhost) socket, or rets 0 if none
 * useful for creating active connections
 */
TcpCon tcp_is_socket(fhost, fport, lhost, lport)
in_name	fhost; 
in_name lhost;
uint 	fport;
uint 	lport;
	{
	register TcpCon con;

	for (con = tcp_list.tc_flink; con != &tcp_list; con = con->tc_flink)
		if (con->srcport == lport 
		&& con->lhost == lhost
		&& con->fhost == fhost 
		&& con->dstport == fport)
			return(con);
	return NULL;
	}

/*
 * finds a passive or active connection for local port, foreign port, foreign
 * host.  Useful for demuxing packets
 */
TcpCon tcp_resolve_con(LocPort, lhost, ForPort, ForHost)
unsigned LocPort, ForPort;
in_name	 ForHost; 
in_name  lhost;
	{
	register TcpCon con;

	for (con = tcp_list.tc_flink; con != &tcp_list; con = con->tc_flink)
		if (con->srcport == LocPort && con->lhost == lhost) 
			{
			if (con->fhost == ForHost && con->dstport == ForPort)
				return(con);
			/* Awesome hack:  while one host is opening on a   */
			/* listened socket, drop all other hosts' SYN pkts.*/
			/* this keeps the other hosts from being RESET by  */
			/* tcp_rcv, until the us_open upcall occurs.  If   */
			/* the client re-listens from that upcall, the     */
			/* socket will never be deaf to foreign hosts.	   */


			/* Ramki (3/26/92) */
			/* The Terminal Server has to accept multiple session */
			/* requests from the same host at the same time. So do*/
			/* not drop the syn packet. Continue the search.  */
			/* A new connection structure will be created for */
			/* every session request with a different foreign */
			/* port number */
			/*****
			if (con->conn_state == SYNRCVD) 
				return((TcpCon) 1);	
			******/
			}
	/* no match! */
	return 0;
	}


/*
 * name		tcp_clean	cleans up after a connection is closed
 *
 * synopsis	tcp_clean(con, status)
 *		TcpCon	con; <<	acted upon this connection
 *		int	status; <<	why it is closed
 *
 * description	It removes the connection "con" from the active connection
 *		queue.  It frees all DBD buffers associated with "con".
 *
 *
 * returns	nothing
 */

int tcp_clean(con, status)	/* cleans up after a connection closes */
register TcpCon con;	/* may be called by send process, but not receive. */
int	status;		/* tells the way it closed */
	{
	extern int current_direction;
	register TcpCon cn2;
	PACKET	p_ptr;		/* xmit buffer temporary */

	/* verify that connection is present */
	for (cn2 = tcp_list.tc_flink; cn2 != &tcp_list; cn2 = cn2->tc_flink)
		if (cn2 == con)
			break;
	if (cn2 == &tcp_list)
		return(FALSE);	/*  no such connection */

	if(tcpcntrs->current_con > 0)
	   tcpcntrs->current_con--;
	tcpcntrs->close_con++;
	con->conn_state = CLOSED;
	((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;

	while (p_ptr = (PACKET) dequeue(&con->out_q))	/* flush xmit q */
	{
		in_free(p_ptr);
	}

	if (con->saved_pkt)			/* if ahead-of-seq pkt. */
		in_free(con->saved_pkt);	/*  free it now */
	StopTimer(&con->tcptm);
	con->tc_mustrun = 0;

	/* unlink connection structure from circular list */
	con->tc_flink->tc_blink = con->tc_blink;
	con->tc_blink->tc_flink = con->tc_flink;

	/* LME alarms */
/*	if (status)	
**		{ 
**		if (tcpalrms->event_enable & CLOSED_EVENT_ENABLE)
**			lme_alarm(TCP_CLOSE_EVENT, con->tc_stats);
**		}
**	else
**		{
**		if (tcpalrms->event_enable & ESTAB_RESET_EVENT_ENABLE)
**			lme_alarm(TCP_RESET_EVENT, con->tc_stats);
**		}
*/
	/* LME open alarm retrigger */
	if (current_direction == 0
	&&  tcpcntrs->current_con <= tcpalrms->cur_opened_thold_value 
	                           - tcpalrms->cur_opened_del_val)
			current_direction = 1;

	if (status != -1)
		/* tell user it closed, and how */
		tn_up_close(con,status);

	con->ufield = NULL;		/* kill telnet reference */
	free((char *)con);		/* nuke connection block. */
	return;
	}

void tcp_newdata(con)		/* makes sure data on net will be resent */
TcpCon con;
	{
	con->SendReason = 0;
	con->tc_mustrun |= TC_RUN_SEND_DATA;
	SendSignal(&TcpSendSem);
	}

void tcp_alive(con)
TcpCon con;
	{
	con->tc_mustrun |= TC_RUN_SEND_ALIVE;
	SendSignal(&TcpSendSem);
	}

void tcp_sendack(con)	/* makes sure an ack is being sent to the net */
TcpCon con;
	{
	con->tc_mustrun |= TC_RUN_SEND_ACK;
	SendSignal(&TcpSendSem);
	}

void tcp_hush(con)
TcpCon con;
	{
	con->tc_mustrun &= 0x80;	/* dont send ack, dont run, dont keep alive */
	StopTimer(&con->tcptm);
	}

void tcp_timewait(con)	/* handles processing for pkt received in TIMEWAIT */
TcpCon con;
	{
	con->tc_mustrun &= 0x80;	/* dont send ack and dont run */
	con->retry_time = TW_TIME;
	StartTimerCall((TIMER *)&con->tcptm, con->retry_time, tmwat, (int)con);
	}
/*
 *	Copy the seq number.
 *	It copes a long by coping two bytes at a time.
 */
SeqCopy(ushort *to, ushort *from)

	{
	*to++ = *from++;
	*to = *from;
	}

/*
 *	Store the short value into a byte array
 */
CopyShort(u_short val,byte *bp)
{
	*bp++ = val & 0xff;
	*bp = val >> 8;
}

/**********
CheckOutQue(TcpCon con)
{
	int	count;
	int	acount = 0;
	MSGHDR	*flink;

	count = con->out_q.mb_count;
	flink = (MSGHDR *)con->out_q.mb_mflink;
	while(flink != NULL)
	{
		if(++acount <= count)
			flink = (MSGHDR *)flink->mh_link;
		else
			enter_debug(0x5678,con,&con->out_q,con->out_q.mb_count,flink,acount);
	}
}
**************/

tcp_new_wind(TcpCon con, uint x) 
{
	if (con->loc_win != x) 
	{
		PACKET p;

		con->loc_win = x;
		p = (PACKET)con->out_q.q_head;
		if(p->nb_len == 0)
			tcp_sendack(con);
	}
}
