/**			       
*
*	Program Name:	nim960 tcp module
*
*	Filename:	init.c
*
*	$Log:   /b/gregs/i960/tcpip/tcp/tcpinit.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:12   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:18   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:56   gregs
 * Initial revision.
 * 
 *    Rev 1.3   13 Apr 1993 10:07:30   kenb
 * Deleted a ReSchedule from tcp_init
 * 
 *    Rev 1.2   17 Jun 1992 13:12:28   vinay
 * Removed Errorlog function
 * 
 *    Rev 1.1   16 Jun 1992 15:12:12   vinay
 * Changed printf to include the Errorlog function
 * 
 *    Rev 1.0   16 Apr 1992 18:30:52   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		4.19.91
*
*	Version:	1.0
*
*	Programmers:	not known
*
*	Modifications:	K Kong	4.19.91
*			Port to the 80960 platform. 
*			i.e.	remove "far", int is 32 bit ...etc
*
*	Comments:	This file contains the function to initialize 
*			the tcp module.
*			tcp_init()
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* srclib/mtcp/init.c
	Initialize PC/TCP multiple-connection TCP
*/

/*
Copyright (C) 1986,1987 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/


#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include "internal.h"


/* This routine is called to initialize the TCP.  It calls a bunch of
 * lower level protocol-initialization modules, opens a connection to
 * internet, and sets up a pseudo header for outgoing checksum calculations,
 * which is used by all subsequent send processes.
 *
 *	EDIT HISTORY:
 *
 *	27-Sep-87	romkey	added some #ifdef KERNEL's for 2.0, fixed
 *				 a spelling error ("psudo"), changed
 *				 #ifdef TCDBG to #ifdef DEBUG. Put in
 *				 copyright notice. Put back in change
 *				 to initial socket number selection.
 */


uint		tcp_next_socket;
tcp_con		tcp_list;	/* circular queue with dummy head entry */
extern		void tcp_send_main();
TCP_STAT	*tcpcntrs;	/* LME for TCP/IP: TCP cntrs */
TCP_THRESHOLD	*tcpalrms;	/* LME for TCP/IP: TCP alarms */
TCP_CON_ENTRY	*tcpstats;	/* LME for TCP/IP: TCP alarms */
MBOX		clrsMbox;
SEM		TcpSendSem;	/* Semaphore to start the tcp transmitter */

static TIMER	tcp_noact_tmr;	/* noactivity processing routine timer */

#define	TCP_SEND_STACK_SIZE	2048	/* stack size for tcp send task	*/
/*
 *	Stack for the tcp send task
 */
static	int	TcpSendStack[TCP_SEND_STACK_SIZE / sizeof(int)];
extern	void	tcp_noact();

/*
 * name		tcp_init	initialize the tcp module
 *
 * synopsis	tcp_init(void)
 *
 * description	It initializes the tcp module.  It registers with IP such
 *		that all TCP segment will come to me.  It creates a 
 *		task for transmitting tcp segments.
 *
 * returns	0		done
 *		otherwise	error number
 */

int tcp_init()

	{
	int	i;

	if((tcpfd = in_open(TCPPROT, (int(*)())tcp_rcv)) == 0) 
		{
		printf("%s","Error: cannot open tcp port\n");
		return 1;
		}

	/* get us an initial socket number */
	tcp_next_socket = rand() / 2;
	/*
	 *	Cannot be larger than 0xffff.
	 */
	tcp_next_socket &= 0x0000ffff;	
	if(tcp_next_socket < 1200)
		tcp_next_socket += 1200;

	/* allocate and set up pseudoheader for incoming packets */
	iphp.tp_zero = 0;
	iphp.tp_pro = TCPPROT;

	/* setup pointer to connections list */
	tcp_list.tc_flink = &tcp_list;	/* no entries as yet */
	tcp_list.tc_blink = &tcp_list;	/* except myself of course */
	/*
	 *	Create the semaphore for tcp transmitter.
	 */
	CreatSemaphore(&TcpSendSem, 0);

	/* create xmt task */
	CreatTask(tcp_send_main, (word *)TcpSendStack, TCP_SEND_STACK_SIZE, 0);

	/* lme counters */
	tcpcntrs = _initp->tcpcntr;
	tcpalrms = _initp->tcpalrm;
	tcpstats = _initp->tcpstat;
	memset(tcpcntrs, 0, sizeof(TCP_STAT));
	memset(tcpalrms, 0, sizeof(TCP_THRESHOLD));
	memset(tcpstats, 0, sizeof(TCP_CON_ENTRY) * _initp->numtcps);
	tcpcntrs->maxcon = _initp->numtcps;
	for (i = 0; i < _initp->numtcps; i++)
		(tcpstats+i)->tcp_state = CLOSED;

	/* clear the clrs mailbox */
	CreatMailbox(&clrsMbox);

	/* create no activity timer */
	CreatTimer(&tcp_noact_tmr);
	/*
	 *	Activated every 5 seconds
	 */
	StartTimerCall((TIMER *)&tcp_noact_tmr, 500, tcp_noact, 0);
	return 0;
	}


/* every time tick, process all sessions keep alives */
void tcp_noact()

	{
	register TcpCon	con;

	for (con = tcp_list.tc_flink; con != &tcp_list; con = con->tc_flink)
		{
		if (con->conn_state == ESTAB || con->conn_state == FINRCVD)
			{
			if (con->frn_win == 0 || --con->tc_alive == 0)
				{
				con->tc_alive = 100;	/* reset no activity timeout counter */
		  		tcp_alive(con);
				}
			}
		}
	StartTimerCall(&tcp_noact_tmr, 500, tcp_noact, NULL);
	}
/*
 *	Clear the tcp counters.
 */
TcpClearCounters()
	
	{
	tcpcntrs->active_con = 0;
	tcpcntrs->pass_con = 0;
	tcpcntrs->con_fail = 0;
	tcpcntrs->close_con = 0;
	tcpcntrs->current_con = 0;
	tcpcntrs->outseg = 0;
	tcpcntrs->retran_seg = 0;
	tcpcntrs->inseg = 0;
	}


