/**
 *	Program Name:	telnet program
 *
 *	Filename:	close.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/close.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:38   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:36   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:16   gregs
 * Initial revision.
 * 
 *    Rev 1.5   07 Sep 1992 16:13:28   forrest
 * Change "smp_clean" to "smp_abort"
 * 
 *    Rev 1.4   27 Jul 1992 17:25:24   forrest
 * Added V2
 * 
 *    Rev 1.3   13 May 1992 10:51:40   pvcs
 * No change.
 * 
 *    Rev 1.2   08 May 1992 15:54:18   ramki
 * Changed lat include path
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <ip.h>
#include <icmp.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <telnet.h>
#include <error.h>

#ifdef V2 
#include <dbd.h>
#include <v2main.h>
#include <v2ptp.h>
#include <v2rsp.h>
#include <v2smp.h>
#include <v2fns.h>
#endif


void	*tn_clean(telnet *);
/*
 * OPENS AND CLOSES AND ABORTS
 */


/* close an existing telnet connection */
tn_close(tn, time)
register telnet	*tn; 
int	time;
{
	void	*con = tn->tn_tcp;
	int	do_abort = 1;

	/* make sure that it is closable */
	if (tn->tn_chk != TN_CHECK || tn->tn_nus == TN_NUS_FREE)
		return ERR_NOTCONN;

	/* close the connection */
	if (tn->tn_nus == TN_NUS_ACTV || tn->tn_nus == TN_NUS_FCLOSE)
	{
		tn->tn_nus = TN_NUS_CLOS;	/* close in progress */
#ifdef LAT  
		if (tn->tn_psid == PS_LAT)	/* LAT stack */
			do_abort = lat_close(con);
		else 
#endif
#ifdef V2
			if (tn->tn_psid == PS_V2)	/* V2 stack */
				do_abort = smp_close((V2SESSTBL *)con);
			else	/* TCPIP stack */
#endif
				do_abort = !(con != 0 && tcp_is_open(((TcpCon)con))
				    && tcp_close((TcpCon)con));
	}
	else if(tn->tn_nus == TN_NUS_FCLOSED)
	{
		tn_closed(tn,tn_clean(tn));
		return 0;
	}

	/* give up. abort the connection */
	if (do_abort)
		tn_faulted(tn, tn_clean(tn));	/* kill it now */
	else
		StartTimerCall((TIMER *)&tn->tn_tmr, time, tn_up_timer, (int)tn);	
	return 0;
}


/* abort an existing telnet connection */
tn_abort(tn)
register telnet	*tn; 
{
	if (tn->tn_chk != TN_CHECK || tn->tn_nus == TN_NUS_FREE)
		return ERR_NOTCONN;

	/* clean up the telnet structure */
	tn_clean(tn);
	return 0;	/* ok */
}

void *tn_clean(tn)
register telnet	*tn; 
{
	void	*con = tn->tn_tcp;
	void	*tag = tn->tn_tag;
	PACKET	p;

	/* stop timers. flush queued buffers */
	StopTimer(&tn->tn_tmr);
	while (p = (PACKET)AcptMessage(&tn->tn_mbox))
	{
		in_free(p);
	}
	if (tn->tn_pktptr)
	{
		in_free((PACKET)tn->tn_pktptr);
		tn->tn_pktptr = 0;
	}

	/* clean up the telnet structure */
	tn->tn_nus = TN_NUS_FREE;
	tn->tn_tcp = NULL;
	tn->tn_tag = NULL;

	/* close the connection */
	if (con != NULL)
	{
#ifdef  LAT 
		if (tn->tn_psid == PS_LAT)	/* LAT stack */
			lat_abort(con);
		else 
#endif
#ifdef  V2
			if (tn->tn_psid == PS_V2)	/* V2 stack */
			{
				((V2SESSTBL *)con)->st_rsp.sessIdTag = 0;
				smp_abort((V2SESSTBL *)con);
			}
			else	/* TCPIP stack */
#endif
			{
				((TcpCon)con)->ufield = NULL;	/* prohibit TCP upcalls to me */
				tcp_abort((TcpCon)con);
			}
	}
	/* return the tag */
	return tag;
}
