/**
 *	Program Name:	telnet program
 *
 *	Filename:	option.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/option.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:44   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:40   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:20   gregs
 * Initial revision.
 * 
 *    Rev 1.3   30 Nov 1992 17:01:28   kenb
 * Added ifdef for tn3270
 * 
 *    Rev 1.2   30 Nov 1992 12:54:36   kenb
 * Added support for tn3270 EOR negotiation
 * 
 *    Rev 1.1   08 May 1992 10:06:12   ramki
 * Changed the ECHO negotiation, and also added check make sure that
 * same negotiation is not tried again and again
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#include <types.h>
#include <krnl.h>
#include <error.h>
#include <task.h>
#include <telnet.h>
/*
#include "tnint.h"
*/


/*
 * OPTIONS - OUTBOUND
 */


/* event generation */
tn_option(tn, sta, opt, req)
telnet	*tn;
uint	sta;
uint	opt;
uint	req;
{
	static byte negot[4] = {TN_IAC, 0, 0};
	uint	f = char2flg(opt);
	uint	*fp;
	uint	rslt;

	/* Verify parameters */
	if (tn->tn_nus != TN_NUS_ACTV)
		return ERR_NOTCONN;
	if (sta < TN_WILL || sta > TN_DONT)
		return OUT_OF_RANGE;
	if (f == 0)
		if (req == REQ)
			return OUT_OF_RANGE;
#ifdef  LAT
	/* LAT protocol stack */
	if (tn->tn_psid != PS_TCPIP
#ifdef TN3270
		&& tn->tn_psid != PS_TN3270
#endif
		)
		return 0;
#endif


	/* responses to unrecognized commands must always be negative */
	if (f == 0)
		sta = (sta+1) & ~1;	/* make sense negative */

   	/*  If I already WILL  and want to WILLgain, don't send it */
	if(sta == TN_WILL && (tn->tn_will & f))
		return 0;
	else if (sta == TN_DO && (tn->tn_do & f))
		/* if remote already DO, don't ask DO again */
		return 0;

	/* request or resond */
	negot[1] = sta;
	negot[2] = opt;
	rslt = tn_putstr(tn, negot, 3);

	/* set request or status flags when successful */
	if (rslt == 0)	/* negotiation sent ok */
	{
		if (req == REQ)
		{
			(sta > TN_WONT) ? (tn->tn_do_req |= f) : (tn->tn_will_req |= f);
			/* also set what I am requesting WILL or DO */
			if(sta == TN_DO)
				tn->tn_do_set |= f;
			else if(sta == TN_WILL)
				tn->tn_will_set |= f;
		}
	}
	return rslt;
}


/*
 * OPTIONS - INBOUND
 */

proc_option(tn, sta, opt)
register telnet *tn;
uint	sta;
uint	opt;
{
	static byte negot[4] = {TN_IAC, 0, 0};
	uint	reqf;
	uint	setf;
	uint	negf;
	uint	f;
	uint	status;

	/* CHANGE THE 'HE' SENSE TO 'ME' */
	sta += (sta > TN_WONT) ? -2 : 2;

	/* note current state of the telnet option */
	f = char2flg(opt);
	negf = ((sta > TN_WONT) ?  tn->tn_do     :  tn->tn_will    ) & f;
	setf = ((sta > TN_WONT) ?  tn->tn_do_set :  tn->tn_will_set) & f;
	reqf = ((sta > TN_WONT) ?  tn->tn_do_req :  tn->tn_will_req) & f;

	if (reqf)
	{	/* confirmation of my request */
		set_flag(tn, sta, opt, f);
		/* if I request to set and response is not to set 
		** or I request not to set and the response is to set
		** I may let the application to know about it
		**/
		if((setf && !(sta & 1)) || (!setf && (sta & 1)))
			option_conf(tn,tn->tn_tag,sta,opt,0);
		else if (f == F_SYTEK || f == F_BINARY || f == F_ECHO)
		     	/* if sytek option is confirmed back,
			 ** let application know, so it will send out priv level
			 **/
			option_conf(tn, tn->tn_tag, sta, opt,1);
	}
	else  /* if this not the response to my request */
	{
   		/*  If I already WILL  and want to WILLgain, don't send it */
		if(sta == TN_WILL && (tn->tn_will & f))
			return;
		else if (sta == TN_DO && (tn->tn_do & f))
			/* if remote already DO, don't ask DO again */
			return;
		if((negf && !(sta & 1)) || (!negf && (sta & 1)))
		{
	                /* the request also different from what have 
			**been negotiated
        	        **/
                	if(!option_ind(tn, tn->tn_tag, sta,opt))
				/* if the application does not like it, send the
				 ** reverse-response 
				 **/
				(sta & 1) ? (status = sta +1) : (status = sta - 1);

			else
			{
				/* application accept the request , just set it and
				 ** respond the same */
				set_flag(tn, sta, opt, f);
				status = sta;
			}
		}
		else
		{
			/* just respond it */
			status = sta;
		}
		negot[1]=status;
		negot[2] = opt;
		tn_putstr(tn, negot, 3);
	}
}

set_flag(tn, sta, opt, flg)
telnet	*tn;
uint	sta;
uint	opt;
uint	flg;
{
	/* mark status as negotiated, and negotiations complete */
	(sta > TN_WONT) ? (tn->tn_do_set &= ~flg)  : (tn->tn_will_set &= ~flg);
	(sta > TN_WONT) ? (tn->tn_do_req &= ~flg) : (tn->tn_will_req &= ~flg);

	/* record new status */
	if (sta & 1)	 /* confirm: DO/WILL */
		(sta > TN_WONT) ? (tn->tn_do |= flg) : (tn->tn_will |= flg);
	else          	 /* confirm: DONT/WONT */
		(sta > TN_WONT) ? (tn->tn_do &= ~flg) : (tn->tn_will &= ~flg);
}

char2flg(code)
uint code;
{
	switch(code)
	{
	case TN_BINARY: 
		return F_BINARY;
	case TN_ECHO:
		return F_ECHO; 
	case TN_SGA:
		return F_SGA;  
	case TN_STATUS:
		return F_STATUS;
	case TN_TMARK:
		return F_TMARK; 
	case TN_SYTEK:
		return F_SYTEK;
	case TN_TERMTYPE:
		return F_TERMTYPE;
#ifdef TN3270
	case TN_EOR:
		return F_EOR;
#endif
	default:
		return 0;
	}
}

flg2char(flag)
uint flag;
{
	switch(flag)
	{
	case F_BINARY:
		return TN_BINARY;
	case F_ECHO:
		return TN_ECHO; 
	case F_SGA:
		return TN_SGA;  
	case F_STATUS:
		return TN_STATUS;
	case F_TMARK:
		return TN_TMARK; 
	case F_SYTEK:
		return TN_SYTEK;
	case F_TERMTYPE:
		return TN_TERMTYPE;
#ifdef TN3270
	case F_EOR:
		return TN_EOR;
#endif
	default: 
		return -1;	/* note that binary is value 0 */
	}
}
