/**
 *	Program Name:	telnet program
 *
 *	Filename:	get.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/put.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:46   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:40   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:22   gregs
 * Initial revision.
 * 
 *    Rev 1.2   27 Jul 1992 17:29:38   forrest
 * Added V2
 * 
 *    Rev 1.1   08 May 1992 10:05:08   ramki
 * Changed the lat related things
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <ip.h>
#include <icmp.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <error.h>
#include <telnet.h>

#ifdef V2 
#include <dbd.h>
#include <v2main.h>
#include <v2ptp.h>
#include <v2rsp.h>
#include <v2smp.h>
#include <v2fns.h>
#endif


/*
 * CHARACTER TRANSMISSION
 */

/* tn_putstr - drop a string of characters into buffer */
tn_putstr(tn, s, l)
register telnet	*tn;
byte 	*s;
int	l;
{
	register TcpCon con = (TcpCon)tn->tn_tcp;
	
	if (tn == NULL || tn->tn_nus != TN_NUS_ACTV)
		return ERR_NOTCONN;
	if (l == 0)
		return 0;

	tn->tn_outbytes += l;
#ifdef LAT 
	if (tn->tn_psid == PS_LAT)	 /* LAT protocol stack */
		return lat_send(con, s, l);/* handles no room prblm */
	else 
#endif
#ifdef V2
 if (tn->tn_psid == PS_V2)	/* V2 protocol stack */
  return(
   smp_send((V2SESSTBL *)((char *)con), DATASTREAM, (char *)s, l, NEWPKTDATA));
 else				/* TCPIP protocol stack */
#endif
			return tfwrite(con, s, l);
}


tfwindow(tn)
telnet	*tn;
{
	TcpCon con = (TcpCon)tn->tn_tcp;

	if (con == 0)
		return 0x5555;
#ifdef LAT 
	if (tn->tn_psid == PS_LAT)		 /* LAT protocol stack */
		return LatWindow(con);
	else
#endif
#ifdef V2
		if (tn->tn_psid == PS_V2)
			if(!v2smpWindow((V2SESSTBL *)con))
				return 0;
			else
				return 64;
		else	/* TCPIP protocol stack */
#endif
			return con->frn_win;
}

/******** NOT USED ************
tlwindow(tn)
telnet	*tn;
{
	TcpCon	con = (TcpCon)tn->tn_tcp;
	int	i;
	int	j;

	if (con == 0)
		return 0xaaaa;
#ifdef LAT 
	if (tn->tn_psid == PS_LAT)		 
	{
		for (i = j = 0; i < ((SCB_PTR)(con))->num_slots; i++)
			if ( ((SCB_PTR)(con))->slot_ptr_table[i] == 0)
				j++;
		return j;
	}
	else 
#endif
#ifdef  V2
		if (tn->tn_psid == PS_V2)
			if(!v2smpWindow((V2SESSTBL *)con))
				return 0;
			else
				return 64;
		else	
#endif
			return con->loc_win;
}
**************************************/


/* tn_sync - send a sync to other side.  Used by telnet only */
tn_sync(tn)
register telnet	*tn;
{
	static byte dm[2] = {TN_IAC, TN_DM};
	register TcpCon con = (TcpCon)tn->tn_tcp;

	tcp_urgent(con);
	return tfwrite(con, dm, 2);
}
