/**
 *	Program Name:	telnet program
 *
 *	Filename:	tninit.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/tninit.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:46   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:42   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:24   gregs
 * Initial revision.
 * 
 *    Rev 1.3   16 Jun 1992 17:37:18   vinay
 * changed back to rev 1.1
 * 
 *    Rev 1.2   16 Jun 1992 15:32:00   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.1   08 May 1992 10:07:06   ramki
 * changed LAT related things
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#include <types.h>
#include <krnl.h>
#include <netbuf.h>
#include <task.h>
#include <tcpip.h>
#include <telnet.h>
#include <error.h>

telnet	*tns;
telnet	*tne;
uint	tnsz;
uint	ltnsz;

extern int permit;

/* telnet initialization */
tn_init(numtns)
int	numtns;
{
	register telnet	*tn;
	int	i;
	
	/* allocate */
	tns = (telnet *)lmalloc(numtns * sizeof(telnet));
	tne = tns + numtns;
	if (tns == NULL)
		{
		printf("tn_init: Not enough memory\n");
		return 1;
		}
#ifdef   LAT 
	/* lat init please */
	if (i = lat_init( 8, 0, 0))
	{
		printf("tn_init: lat_init error\n");
		return i;
	}
#endif
	/* initialize */
	tnsz = _initp->tn_bufs;
	ltnsz = tnsz - 256;
	for (tn = tns; tn != tne; tn++)
	{
		tn->tn_nus = TN_NUS_FREE; 	/* not yet in use */
		tn->tn_chk = TN_CHECK;  	/* is for real */
		CreatTimer(&tn->tn_tmr);
		tn->tn_gbuf = (byte *)lmalloc(tnsz);  /* que for rx chars */
		tn->tn_sbbf = (byte *)lmalloc(SBBFMAX);/* buffer for sytek iacs */
		if (tn->tn_gbuf == NULL || tn->tn_sbbf == NULL)
			return 16;
	}
	return 0;
}
