/**
 *	Program Name:	telnet program
 *
 *	Filename:	tnopen.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/tnopen.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:48   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:42   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:26   gregs
 * Initial revision.
 * 
 *    Rev 1.5   30 Nov 1992 12:46:00   kenb
 * Added Support for tn3270
 * 
 *    Rev 1.4   05 Nov 1992 08:26:28   vinay
 * Added '&error' parameter to function 'smp_open()' -- Ramki/Forrest
 * 
 *    Rev 1.3   27 Jul 1992 17:30:06   forrest
 * Added V2
 * 
 *    Rev 1.2   11 May 1992 18:14:36   ramki
 * removed three LAT related lines
 * 
 *    Rev 1.1   08 May 1992 10:05:28   ramki
 * Changed the lat related things
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <ip.h>
#include <icmp.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <telnet.h>
#include <error.h>

#ifdef V2 
#include <dbd.h>
#include <v2main.h>
#include <v2ptp.h>
#include <v2rsp.h>
#include <v2smp.h>
#include <v2fns.h>
#endif


/*
 * OPENS AND CLOSES AND ABORTS
 */

telnet *fnd_tn()
{
	static telnet *tnl = 0;
	int	i = tne - tns;	/* number structures */

	/* set tnl initially */
	if (tnl == 0)
		tnl = tns - 1;

	/* seek for free tn structure */
	while (i--)
	{
		if (++tnl == tne)	/* next tn structure */
			tnl = tns;
		if (tnl->tn_nus == TN_NUS_FREE)
		{
			CreatMailbox(&tnl->tn_mbox);
			return tnl;
		}
	}
	return NULL;
}


/* open a telnet connection and return a pointer to the telnet structure */
tn_open(tnp, fhost, fskt, lhost, lskt, tag, time, prot,priv)
telnet	**tnp;
in_name	fhost;
in_name lhost;
uint	fskt;
uint	lskt;
void	*tag;
int	time;
int	prot;
int	priv;
{
	register telnet	*tn;
	register void	*x;
	byte	buf[40];
	byte	*argv[3];
	int	argm,error;
#ifdef LAT
	char	*servicep,*nodep;
#endif

	/* fetch TN structure */

	if (!(tn = fnd_tn()))
		return ERR_NORSRC;

	/* check args and make the call */
	switch(prot)
	{
	case PS_TCPIP:
	case PS_TCP_DIRECT:
	case PS_RLOGIN:
#ifdef TN3270
	case PS_TN3270:
#endif
		x = (void *)tcp_open(fhost, fskt, lhost, lskt, (void *)tn,&error);
		break;

#ifdef LAT 
	case PS_LAT:
		tn->tn_lskt = lskt;
		memset(buf, 0, 40);
		memcpy(buf,(char *)fhost, strlen((char * )fhost));
		argm=parse_parm(buf, ':',argv,3);
		if(argm == 1)
		{
			servicep = (char *)fhost;
			nodep = NULL;
		}
		else
		{
			servicep = (char *)argv[0];
			nodep = (char *)argv[1];
		}
		x = (void *)lat_open(servicep, nodep, lskt, (word)tn, 0,
			    &tn->tn_gbuf[ltnsz], ltnsz/256,&error);
		break;

#endif
#ifdef  V2
	case PS_V2:
		tn->tn_fskt = fskt;
		tn->tn_lskt = lskt;
		tn->tn_fhst = fhost;
		tn->tn_mode = priv/*v2 priv*/;
		x = (void *)smp_open((word)fhost, (word)tn, &error);
		break;
#endif


	default:
		tn->tn_nus = TN_NUS_FREE;
		return OUT_OF_RANGE;
	}
	if (x == NULL)
	{
		tn->tn_nus = TN_NUS_FREE;
		return(error);
	}
	/* start a timer on it */
	StartTimerCall((TIMER *)&tn->tn_tmr, time, tn_up_timer, (int)tn);	
	tn->tn_nus = TN_NUS_OPEN;
	tn->tn_tag = tag;
	tn->tn_psid = prot;
	tn->tn_tcp = x;
	*tnp = tn;
	return 0;
}

