/**
 *	Program Name:	telnet program
 *
 *	Filename:	uplat.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/uplat.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:50   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:46   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:28   gregs
 * Initial revision.
 * 
 *    Rev 1.1   08 May 1992 10:05:48   ramki
 * Changed LAT related things
 * 
 *    Rev 1.0   16 Apr 1992 18:27:54   pvcs
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <task.h>
#include <netbuf.h>
#include <error.h>
#include <tcpip.h>
#include <telnet.h>
#include <appdef.h>
#include <nvrpit.h>
#include <meridian.h>
#include <latvcb.h>
#include <latscb.h>
#include <latdef.h>


extern BOOT1_BLK	*boot1;

/*
 *  TCP UPCALLS 
 */
/* incoming call */
int lat_filter_con(scb, hlen,fhost,svclen,svc)
SCB_PTR scb;           /* Session control block            */
int hlen;
byte *fhost;	/* foreign host */
int svclen;
byte *svc;
{
	extern telnet *fnd_tn();
	register telnet *tn;
	int crdts;
	word x;
	word status;

	if (!(tn = fnd_tn()))
		return ERR_NORSRC;	/* no resources: reject call */
	if ((x = LAT_filter_con(tn,  (char *)fhost, hlen, 
	    (char *)svc,svclen,&status,scb->portsvc,scb->password)) == 0)
		return status;	/* fetched TN is still marked as free */
	tn->tn_tag = (void *)x;
	tn->tn_tcp = (void *)scb;
	tn->tn_psid = PS_LAT;	/* regular TCP protocol */
	tn->tn_nus = TN_NUS_OPEN;
	scb->usertn = (int)tn;		/* scb now in use */
	crdts = ltnsz/256;
	if (crdts > 8)
		crdts = 8;
	scb->num_slots = crdts;     /* <app> No. of receive slots   */
	scb->tx_slot_data = &tn->tn_gbuf[ltnsz];

	/* start timer */
	StartTimerCall((TIMER *)&tn->tn_tmr,boot1->cirtimer * 4,tn_up_timer,(int)tn);
	return 0;
}

/* open completed */
tn_up_open_lat(scb)
SCB_PTR scb;
{
	register telnet *tn = (telnet *)scb->usertn;

	if (scb == NULL || tn->tn_chk != TN_CHECK || tn->tn_nus != TN_NUS_OPEN)
		return;	/* must be in waiting state */

	tn->tn_nus = TN_NUS_ACTV;
	tn->tn_do = 0;	/* no options enabled yet */
	tn->tn_do_req = 0;
	tn->tn_will = 0;	/* no options enabled yet */
	tn->tn_will_req = 0;
	tn->tn_mode = 0;
	tn->tn_gchrs = 0;
	tn->tn_take = 0;
	tn->tn_fill = 0;
	tn->tn_bufs = ltnsz;
	tn->tn_pktptr = NULL;
	CreatMailbox(&tn->tn_mbox);

	/* identifiers */
	tn->tn_fhst = (in_name)scb->srvc;
	bclear(tn->tn_sbbf,SBBFMAX);
	ncopy((NID *)tn->tn_sbbf, &scb->vcb_pntr->dst);	/* frn IEEE addr */
	bcopy((char *)(tn->tn_sbbf+ sizeof(NID)),scb->remport
	    ,strlen(scb->remport));

	StopTimer((TIMER *)&tn->tn_tmr);
	tn_opened(tn, tn->tn_tag);
}

/*
 *	foreign host closed the session
 *	Ramki(9/21/89)
 */
tn_up_fclose_lat(scb)
SCB_PTR	scb;
{
	register telnet *tn = (telnet *)scb->usertn;

	if (scb == NULL || scb != (SCB_PTR)tn->tn_tcp
	    || tn->tn_chk != TN_CHECK || tn->tn_nus == TN_NUS_FREE)
		return 0;
	tn->tn_nus = TN_NUS_FCLOSE;
	tn_fclosed(tn,tn->tn_tag);
	return 0;
}

/* local side is now closed */
tn_up_close_lat(scb, reason)
SCB_PTR scb;
word reason;
{
	register telnet *tn = (telnet *)scb->usertn;
	word state = tn->tn_nus;

	/* free the resources */
	if (scb == NULL || scb != (SCB_PTR)tn->tn_tcp
	    || tn->tn_chk != TN_CHECK || tn->tn_nus == TN_NUS_FREE)
		return;
	tn->tn_tcp = NULL;	/* the connection is already gone! */
	if(tn->tn_nus == TN_NUS_FCLOSE && tn->tn_gchrs)
	{
		tn->tn_nus = TN_NUS_FCLOSED;
		return;
	}

	/* up indicate closing */
	if (!reason)
		tn_closed(tn, tn_clean(tn)); /* graceful close */
	else
		tn_faulted(tn, tn_clean(tn),reason); /* abort indication! */
}


/* data received */
tn_up_rcv_lat(scb, bp, len)
SCB_PTR scb;
byte *bp;
word len;
{
	register telnet *tn = (telnet *)scb->usertn;
	word oldgchrs = tn->tn_gchrs;

	if (scb == NULL || tn->tn_chk != TN_CHECK
	    || (tn->tn_nus & ~(TN_NUS_ACTV | TN_NUS_CLOS))  )
		return;

	if (bp == 0L)	/* attention (flush) */
	{
		/* flush the slot counters, adding credits as needed */
		while (scb->slot_ptr_table[scb->cur_buf_slot])
		{
			/* clear the slot */
			scb->slot_ptr_table[scb->cur_buf_slot] = 0;
			scb->local_credits++;	/* one more credit to send */
			if (++scb->cur_buf_slot == scb->msk_slots)
				scb->cur_buf_slot = 0;
		}

		/* flush the received characters */
		scb->cur_buf_slot = scb->next_rx_slot = 0;	/* reset counters */
		tn->tn_gchrs = tn->tn_fill = tn->tn_take = 0;
		return;	/* no further processingis required */
	}

	if (len > tn->tn_bufs - tn->tn_fill)	/* wraps */
	{
		bcopy(tn->tn_gbuf + tn->tn_fill, bp, tn->tn_bufs - tn->tn_fill);
		bcopy(tn->tn_gbuf, bp + tn->tn_bufs - tn->tn_fill, 
		    len - tn->tn_bufs + tn->tn_fill);
		tn->tn_fill += len - tn->tn_bufs;
	}
	else /* data fits w.o. wrapping */
	{
		bcopy(tn->tn_gbuf + tn->tn_fill, bp, len);
		tn->tn_fill += len;
	}
	tn->tn_gchrs += len;

	/* record the length for slot maintenance purposes */
	scb->slot_ptr_table[scb->next_rx_slot] = len;
	if (++scb->next_rx_slot == scb->msk_slots)
		scb->next_rx_slot = 0;

	/* process packet */
	if (oldgchrs == 0 && tn->tn_gchrs != 0)
		tn_received(tn, tn->tn_tag);	/* buffer no longer empty */
}

/*
 * 	Indicate break received
 *	Ramki(10/12/89)
 */
tn_up_lat_break(scb)
SCB_PTR	scb;
{
	telnet *tn = (telnet *)scb->usertn;

	proc_event(tn,TN_BREAK);
}
