/**			       
*
*	Program Name:	nim960 bridge
*
*	Filename:	gettime.c
*
*	$Log:   /b/gregs/i960/tcpip/timep/gettime.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:45:32   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:38:54   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:19:10   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:25:52   pvcs
 * Initial revision.
*
*	Creation Date:	6.7.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	Get the time from the server via the time protocol.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>
#include <sockets.h>
#include <netbuf.h>
#include <tcpip.h>
#include <udp.h>

#define	LongCopy(to, from)	ipcopy(to, from)

#define	TIMER_TIMEOUT	200	/* 2 seconds	*/
#define	TIME_RETRIES	3	/* let's try this many times	*/


static void GetTimeReceiver(PACKET, int, in_name, uint, uint, long *);


/*
 * name		GetTimeFromServer	Get time via time protocol
 *
 * synopsis	long GetTimeFromServer(server)
 *		in_name	server;	<<	get the time from this time server
 *
 * description	It gets the current time in terms of number of seconds 
 *		since 00:00 1 Jan 1900 from the time server with ip 
 *		address of "server".  It'll retry up to "TIME_RETRIES"
 *		times before it gives up. 
 *
 * returns	current time in terms of number of seconds since 
 *		00:00 Jan 1900. 
 *		0	for error.
 */

long GetTimeFromServer(in_name server)

	{
	volatile long	CurrentTime = 0;
	volatile int	timeout;
	byte	dummy;
	int	retries = TIME_RETRIES;
	UDPCONN	con;

	con = udp_open(UDP_TIMEP, GetTimeReceiver, &CurrentTime);
	if (con == NULL)
		{
		printf("Error: Timer cannot open udp\n");
		return 0;
		}
	while(retries--)
		{
		if (udp_send(server, UDP_TIMEP, UDP_TIMEP, &dummy, 
			0, _initp->in_me) != 0)
			{
			printf("Error: Timer cannot send to udp\n");
			break;
			}
		timeout = RealTimeTicks();
		while ((RealTimeTicks() - timeout) <= TIMER_TIMEOUT)
			{
			if (CurrentTime != 0)
				{
				/*
				 *	We have the time!
				 */
				 udp_close(con);
				 return CurrentTime;
				 }
			ReSchedule();
			}
		}
	udp_close(con);
	return 0;
	}

/*
 * name		GetTimeReceiver		upcall for time reply 
 *
 * synopsis	void GetTimeReceiver(pkt, length, fhost, fport, lport, time)
 *		PACKET	pkt; <<	"packet" received.
 *		int	length; <<	of "udp" (real) data in "pkt"
 *		in_name	fhost; <<	ip address of the sender
 *		uint	fport; <<	sender's port number
 *		uint	lport; <<	destination's port number
 *		long	*time; >>	return the number of seconds since
 *					00:00 Jan 1 1900 in here.
 *
 * description	This is the upcall when a time protocol packet is received.
 *		If it is a valid time protocol reply packet, then the time
 *		is extracted from the packet and stored in "*time".
 *		Otherwise the packet is ignored.
 *
 * returns	
 */

static void GetTimeReceiver(pkt, length, fhost, fport, lport, time)
PACKET	pkt;
int	length;	
in_name	fhost;
uint	fport;
uint	lport;
long	*time;

	{
	long	data;		/* the time in "packet"	*/

	if (fport == UDP_TIMEP && 
		lport == UDP_TIMEP && 
		length >= sizeof(long))
		{
		/*
		 *	Do not get the time directly from the packet
		 *	as it may not be properly aligned.
		 */
		LongCopy(&data, (long *)pkt->nb_prot);
		*time = ntohl(data);
		}
	/*
	 *	free the packet.
	 */
	in_free(pkt);
	}
