/**			       
*
*	Program Name:	UDP Module
*
*	Filename:	udp_send.c
*
*	$Log:   /b/gregs/i960/tcpip/udp/udp_send.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:45:56   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:39:08   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:19:34   gregs
 * Initial revision.
 * 
 *    Rev 1.4   17 Jun 1992 13:14:10   vinay
 * Removed Errorlog function and stuff concerned with it
 * 
 *    Rev 1.3   16 Jun 1992 16:06:30   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.2   13 May 1992 11:03:54   pvcs
 * 
 *    Rev 1.1   17 Apr 1992 14:52:44   kwok
 * comment out the debugger message.
 * 
 *    Rev 1.0   16 Apr 1992 18:29:08   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		11.14.91
*
*	Version:	1.2
*
*	Programmers:
*
*	Modifications:	K Kong	8.8.91	1.1
*			For ip broadcast, we send the packet to the
*			terminal servers multi-cast address if the
*			destination port is the ADMIN_PORT; and to the
*			broadcast address otherwise.
*
*			K Kong	11.14.91	1.2
*			If the packet is for the bootp client, then we
*			send it down to the admin bus only. We do bootp
*			helper for the SYACARD only.
*
*			Ramki 2-14-92
*			Modified the functions to handle local host address
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* Copyright 1986 FTP Software Inc. */

/*  Copyright 1984, 1985 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

/* 8/23/84 - changed debugging messages slightly.
						<John Romkey>
MOD: BLL - added udp_send  function call
*/

#include <krnl.h>
#include <types.h>
#include <netbuf.h>
#include <ip.h>
#include <udp.h>
#include <tcpip.h>
#include <error.h>
#include <sockets.h>
#include "internal.h"

extern UDP_STAT	UdpStat;

extern	char	ETBROADCAST[];

int udp_send(fhost, fport, lport, buf, len, lhost)
in_name	fhost;	/*	Destination host ip	*/
in_name lhost;	/* 	local host address	*/
uint	fport;	/*	Destination host port	*/
uint	lport;	/*	My port number		*/
char	*buf;	/*	data to be sent		*/
uint	len;	/*	length of data in buf	*/

	{
	register PACKET p;
	register uint c;
	/*
	 *	We can only handle this many udp data
	 */
	if (len > 512)
	{
		printf("len %x too big\n",len);
		return OUT_OF_RANGE;
	}
	if ((p = in_alloc(len + 64, 0)) == 0)
	{
/*		printf("in_alloc error len %x\n",len);*/
		return ERR_NORSRC;
	}
	/* fill it with data */
	memcpy(udp_data(udp_head(in_head(p))), (byte *)buf, len);
	/*
	 *	If the fport is bootp client, then
	 *	send it to the admin bus only.
	 */
	if (fport == UDP_BOOTPC)
		{
		p->nb_flags |= PKT_ADMIN;
		}
	c =  udp_send_to(fhost, fport, lhost, lport, p, len);
	/*printf("UDP free dbd %X++", p);*/
	udp_free(p);
	return c;
	}

/* Fill in the udp header on a packet, checksum it and pass it to
	Internet. */

/*
 *	mcast for the terminal server
 */
static char mcast[6] = {
	0x01, 0x00, 0x10, 0xff, 0xff, 0x1c};


udp_send_to(fhost, fport, lhost, lport, p, len)
in_name fhost;
in_name	lhost;
uint	fport;
uint	lport;
PACKET	p;
uint	len; 
	{
	struct udp	*pup;
	struct ph	php;
	register int	udplen;
	NID	*ndp = NULL;
	in_name *inp = NULL;

	UdpStat.outdgrams += 1;
	if (fhost == -1L)
		{
		/*
		 *	K Kong	8.8.91	1.1
		 */
		if (fport == ADMIN_PORT)
			{
			/*
			 *	This is for the Terminal server Admin
			 *	port to reset all the terminal servers.
			 */
			fhost =  _initp->in_me | ~_initp->net_mask;
			ndp = (NID *)mcast;
			}
		else
			{
			/*
			 *	This is for bootps
			 */
			ndp = (NID *)ETBROADCAST;
			/*
			 *	We don't use IEEE header for
			 *	bootp ip broadcast.
			 */
			p->nb_flags &= ~PKT_IEEEHDR;
			}
		inp = &fhost;
		p->db_xmtportlist = 0xff;/* send it on all ports */
		}
	/*
	 *	pup points to the udp header
	 */
	pup = udp_head(in_head(p));
	/*
	 *	upd packet length is the sum of the 
	 *	data length plus udp header length
	 */
	udplen = len + sizeof(struct udp);
	if(udplen & 1)
		((char *)pup)[udplen] = '\0';
	/*
	 *	We convert header info into
	 *	network order.
	 */
	pup->ud_len = htons(udplen);
	pup->ud_srcp = htons(lport);
	pup->ud_dstp = htons(fport);
	/*
	 *	Fill in the pseudo header and calculate 
	 *	the checksum on the pseudo header
	 */
	php.ph_src = in_mymach(fhost,lhost);
	php.ph_dest = fhost;
	php.ph_zero = 0;
	php.ph_prot = UDPPROT;
	php.ph_len = pup->ud_len;
	pup->ud_cksum = cksum((char *)&php, UDP_PH_SIZE >> 1);
	pup->ud_cksum = ~cksum(pup, (udplen+1) >> 1);
	if (pup->ud_cksum == 0)
		pup->ud_cksum = 0xffff;

	return in_write(udp, p, udplen, fhost, lhost, ndp, inp);
	}
