/**			       
*
*	Program Name:	UDP Module
*
*	Filename:	udpdemux.c
*
*	$Log:   /b/gregs/i960/tcpip/udp/udpdemux.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:45:58   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:39:10   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:19:36   gregs
 * Initial revision.
 * 
 *    Rev 1.3   17 Jun 1992 13:15:16   vinay
 * Removed Errorlog function
 * 
 *    Rev 1.2   13 May 1992 11:09:02   pvcs
 * 
 *    Rev 1.1   17 Apr 1992 14:52:34   kwok
 * No change.
 * 
 *    Rev 1.0   16 Apr 1992 18:29:10   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.6.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*			See below for more infomation about this module.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* Copyright 1986 FTP Software Inc. */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

#include <krnl.h>
#include <types.h>
#include <task.h>
#include <netbuf.h>
#include <ether.h>
#include <icmp.h>
#include <ip.h>
#include <udp.h>
#include <sockets.h>
#include "internal.h"

/* This routine handles incoming UDP packets. They're handed to it by the
	internet layer. It demultiplexes the incoming packet based on the
	local port and upcalls the appropriate routine. */

/* 7/3/84 - fixed changed checksum computation to use length from UDP
	header instead of length passed up from internet.
						<John Romkey>
   7/12/84 - "fixed" the demultiplexor to not send destination
	unreachables in response to packets sent to the 4.2 ip
	broadcast address.			<John Romkey>
   12/19/85 - changed trace message to include length of incoming
        packet.					<J. H. Saltzer>

   22-Aug-87	romkey	fixed destination unreachable code to make sure
			   UDP header is in network byte order in
			   ICMP packet. also cleaned up debugging.
MOD: BLL - udp receive matches on first udp con
*/

extern UDPCONN	firstudp;
extern UDP_STAT	UdpStat;

udpdemux(p, len, host,lhost)
PACKET	p;
uint	len;
in_name	host;	
in_name lhost;

	{
	struct ip	*pip;	/* points to the ip packet	*/
	struct udp	*pup;	/* points to the udp packet	*/
	struct ph	php;	/* udp pseudo header		*/
	register UDPCONN	con;
	register UDPCONN	con2;
	ushort	osum;		/* udp checksum (received)	*/
	ushort	xsum;
	uint	plen;		/* udp packet length		*/

	UdpStat.indgrams += 1;      /* for UDP status */
	/* First let's verify that it's a valid UDP packet. */
	pip = in_head(p);	/* points to the ip packet	*/
	pup = udp_head(pip);	/* points to the udp packet	*/
	plen = (uint)ntohs(pup->ud_len);	/* length of udp packet	*/

	if(plen > len)
		{
		/**
		printf("Udp length error ntohs length = 0x%x, len = 0x%x\n",
			plen, len);
		**/
		/*
		 *	udp packet length cannot be bigger
		 *	than the total raw packet length.
		 */
	 	UdpStat.inerror++;      /* for UDP status */
		in_free(p);
		return FALSE;
		}
	osum = pup->ud_cksum;	/* udp checksum	*/
	if(osum != 0) 
		{
		/*
		 *	If length is of odd number,
		 *	append another 0 at the end.
		 */
		if(len & 1) 
			((char *)pup)[plen] = 0;
		/*
		 *	create the pseudo header
		 */
		php.ph_src = host;
		ipcopy(&php.ph_dest, &pip->ip_dest);
		/***
		php.ph_dest = pip->ip_dest;
		****/
		php.ph_zero = 0;
		php.ph_prot = UDPPROT;
		php.ph_len  = pup->ud_len;
	
		pup->ud_cksum = cksum((char *)&php, UDP_PH_SIZE >> 1);
		xsum = ~cksum(pup, (plen + 1) >> 1);
		if (xsum == 0)
			{
			xsum = 0xffff;
			}
		pup->ud_cksum = osum;
		if(xsum != osum) 
			{
	 	    	UdpStat.chksum++;      /* for UDP status */
			in_free(p);
			return FALSE;
			}
		}

	/* get us in the host byte order
	*/
	udpswap_ntoh(pup);
	/* ok, accept it. run through the demux table and try to upcall it
	*/
	for (con2 = NULL, con = firstudp; con != NULL; con = con->u_next) 
		{
		if (con->u_lport == pup->ud_dstp)
			{
			break;
			}
		if (con->u_lport == 0)
			con2 = con;
		}
	/*
	 *	There are three possibilities why we are here
	 *	1	The local port number 0 is registered,
	 *		and there is not match for the port number.
	 *		Sends the packet to con.
	 *		con2 = the connection.
	 *		con = NULL.
	 *
	 *	2	We have found a matched local port number
	 *		con = the connection
	 *
	 *	3	We haven't found a matched local port number
	 *		con = con2 = NULL .
	 *		
	 */
	/*
	 *	case 1, con = con2.
	 */
	if (con == NULL && con2 != NULL)
		con = con2;
	if (con != NULL && con->u_rcv != NULL)
		{
		p->nb_prot = (byte*)udp_data(pup);	/* note real data area start */
		(*con->u_rcv)(p, plen - UDPLEN, host, 
		              (uint)pup->ud_srcp, (uint)pup->ud_dstp, 
			      (uint)con->u_data,lhost);
		return TRUE;
		}

	/* what a crock. check if the packet was sent to the (4.2) ip
		broadcast address. If it was, don't send a destination
		unreachable.
	*/
	/**
	printf("UDP error: cannot find a receiver, srcp = %d, dstp= %d\n",
		pup->ud_srcp, pup->ud_dstp);
	***/
	UdpStat.noport++;      /* for UDP status */
	if(is_broadcast(p)) 
		{
		udp_free(p);
		return TRUE;
		}

	/* send destination unreachable - make sure we're in network
		byte order first.
	*/
	udpswap_hton(pup);
	icmp_destun(host, lhost, in_head(p), DSTPORT);
	udp_free(p);
	return TRUE;
	}


/*******************************************************
	**
	**    icmp_udp
	**
	**   This routine is called by the ICMP rcv
	**   to handle all udp packets which are sent back
	**   by ICMP
	********************************************************/
icmp_udp(type, code, udpkt)
int	type;
int	code;
struct udp *udpkt;

	{
	udpswap_ntoh(udpkt);

	if(udpkt->ud_dstp == UDP_DOMAIN)
		{
		/* if the domain server packet */
		icmp_bad_dm(udpkt->ud_srcp, type, code);
		}
	}
