/**			       
*
*	Program Name:	TCPIP Error Module	
*
*	Filename:	tcpiperr.c
*
*	$Log:   /b/gregs/i960/tcpip/util/tcpiperr.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:46:42   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:39:26   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:20:48   gregs
 * Initial revision.
 * 
 *    Rev 1.3   12 Aug 1992 15:38:50   vinay
 * changed the way errlogPos was handled
 * 
 *    Rev 1.2   27 Jul 1992 11:42:30   vinay
 * Added a function Errorlog which will put all the error messages into a 
 * circular buffer
 * 
 *    Rev 1.1   13 May 1992 11:16:44   pvcs
 * 
 *    Rev 1.0   30 Mar 1992 17:27:18   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		7.15.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	It contains the function to translate a tcpip
*			error number to an ascii error message.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>


#define	MAX_TCPIP_ERROR	12	/* error number is 1 to 12	*/

char 	errorBuf[LOGSIZE];
char 	ermsg[256];

int 	logBufOvrFlow = 0;
int	nologBuf = 0;

char 	*errlogStart = errorBuf;
char	*errlogPos = errorBuf;


static char	*TcpipErrorMsg[] =
		{
		"",	/* error 0 is not an error	*/
		"Remote busy",
		"No remote resource",
		"Unknown error",
		"Network failure",
		"Bad service",
		"Time out",
		"Network unreachable",
		"Bad Parameters",
		"No Tne Got",
		"Connection not closed",
		"No resource",
		"Not connected"
		};

char *TcpipError(int error)
	{
	if (error <=  MAX_TCPIP_ERROR)
		return TcpipErrorMsg[error];
	else
		return "Unknown error number";
	}


/******************************************************************************
**	Errorlog function puts the error message to the Error Log Buffer
**	and also prints the message to the console if the cntrl is set to 1
**	else if puts the Error Message into buffer. 
******************************************************************************/
Errorlog(cntrl,a1,a2,a3,a4,a5,a6)
int 	cntrl;
int	a1,a2,a3,a4,a5,a6;
{
	int length,l,i;

	sprintf(ermsg,a1,a2,a3,a4,a5,a6);
	l = strlen(ermsg);
	*(ermsg+l+1) = '\0';
	if(cntrl == 1)
		printf(ermsg);
	
	if((LOGSIZE + errlogStart - errlogPos) < strlen(ermsg))
	{
		length = errlogStart + LOGSIZE - errlogPos; /* Make length 
						equal to the remaining buffer */
		logBufOvrFlow = 1; /* Set the Overflow flag */
 
		strncpy(errlogPos,ermsg,length); /* Copy text equal to length */
	
		errlogPos = errlogStart; /* wrap around */
		strcpy(errlogPos,(ermsg+length));
		while(*errlogPos++ != '\0');
	}
	else
	{
		strcpy(errlogPos,ermsg);	
		while(*errlogPos++ != '\0');
	}
	return 0;
}
