

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	uart.c
*
*	$Log:   /b/gregs/i960/uart/uart.c_v  $
 * 
 *    Rev 1.3   13 Oct 1993 08:41:38   franks
 * Replaced Ei()/Di() with MaskAllInts()/RestoreIntMask().
 * 
 *    Rev 1.2   12 Oct 1993 10:37:52   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:26:46   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:35:58   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 16:47:16   nim960
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

#include <krnl.h>
#include <defines.h>
#include "../../bridge/include/memory.h"
#include <uart.h>

#ifdef notdef
#define PERIPHIO 	0x90000000	/* 08b UART, TIMER, etc */
#define DIPIO	(PERIPHIO+0x0060) /* Location of DIP_SWITCHES */
#endif

int  SCCbaud();
unsigned char SCCget();
void SCCinit();
int  SCCinrdy();
int  SCCoutrdy();
void SCCput();

extern word fault_cnt;

UART uart_mem;
int data_present;

#define CTRL_S_DSA 1
#define CTRL_Q 0x11
#define CTRL_S 0x13


poll_uart()
{
	register UART *uart_area = &uart_mem;
	volatile struct SCCport *port = CONSOLE;
	shrt i;
	word get, put;
	char c;

	if (fault_cnt)
		return;
	port->control = 0;
	wait_uart();
	i = port->control;
	wait_uart();
	if (i & 0x01) /* Rx */
	{
		c = port->data;
		wait_uart();
		if (uart_area->cntrls == CTRL_S_DSA)
		{
			if (c == CTRL_S)
			{
				uart_area->flowed = 1;
				return;
			}
			else if (c == CTRL_Q)
			{
				uart_area->flowed = 0;
				return;
			}
		}
		if ((uart_area->inque.get - uart_area->inque.put - 1) & uart_area->inque.max)
		{
			put = uart_area->inque.put++;
			uart_area->inque.put &= uart_area->inque.max;
			*(char *)(uart_area->inque.loc + put) = c;
		}
	}
	else if ((i & 0x04) /* Tx */ && !uart_area->flowed)
	{
		if (uart_area->outque.get != uart_area->outque.put)
		{
			get = uart_area->outque.get++;
			uart_area->outque.get &= uart_area->outque.max;
			c = *(char *)(uart_area->outque.loc + get);
			port->data = c;
			wait_uart();
		}
	}
}


setty(baud, ctrl)
word baud;
word ctrl;
{
	register UART *uart_area = &uart_mem;

	uart_area->flowed = 0;
	uart_area->cntrls = ctrl;

	init_console(baud);

	initque(&uart_area->inque, &uart_area->inbuf[0], 128);
	initque(&uart_area->outque, &uart_area->outbuf[0], 128);
	return 0;
}


initque(que, buf, len)
QUE *que;
char *buf;
int len;
{
	que->max = --len;
	que->put = 0;
	que->get = 0;
	que->loc = buf;
}

putcque(c)
char c;
{
	register word saveMask;
	register UART *uart_area = &uart_mem;
	register QUE *que = &uart_area->outque;
	word put;

	MaskAllInts(saveMask);
	if ((que->get - que->put - 1) & que->max)
	{
		put = que->put++;
		que->put &= que->max;
		*(char *)(que->loc + put) = c;
		RestoreIntMask(saveMask);
		return 0;
	}
	RestoreIntMask(saveMask);
	return -1;
}

getcque()
{
	register word saveMask;
	register UART *uart_area = &uart_mem;
	register QUE *que = &uart_area->inque;
	char c;
	word get;

	MaskAllInts(saveMask);
	if (que->get != que->put)
	{
		get = que->get++;
		que->get &= que->max;
		c = *(char *)(que->loc + get);
		RestoreIntMask(saveMask);
		return c;
	}
	RestoreIntMask(saveMask);
	return -1;
}

flush()
{
	register UART *uart_area = &uart_mem;
	register QUE *que = &uart_area->outque;

	while (que->get != que->put)
		ReSchedule();
}

uart_data_in(port)
volatile struct SCCport *port;
{
	register unsigned char c;

	c = port->data;
	wait_uart();
	return c;
}

uart_data_out(port, c)
volatile struct SCCport *port;
unsigned char c;
{
	port->data = c;
	wait_uart();
}

uart_control_in(port)
volatile struct SCCport *port;
{
	register shrt i;

	i = port->control;
	wait_uart();
	return i;
}

uart_control_out(port, c)
volatile struct SCCport *port;
unsigned char c;
{
	port->control = c;
	wait_uart();
}


UartGetch()
{
	if (fault_cnt)
	{
		if ((!SCCinrdy(CONSOLE)) && !data_present)
			return -1;
		else
		{
			data_present = 0;
			return uart_data_in(CONSOLE);
		}
	}
	else
		return getcque();
}

UartPutch(c)
char c;
{
	register UART *uart_area = &uart_mem;
	volatile struct SCCport *port = CONSOLE;
	shrt i;

	if (fault_cnt)
	{
		if ( !SCCoutrdy(CONSOLE) )
			return -1;
		else
		{
			uart_data_out(CONSOLE, c);
			return 0;
		}
	}
	else
	{
		if (putcque(c) == 0)
		{
/*
			if (!uart_area->flowed)
			{
				port->control = 0;
				wait_uart();
				i = port->control;
				wait_uart();
				if (i & 0x04) 
					if ((c = getcque()) != -1)
					{
						port->data = c;
						wait_uart();
					}
			}
*/
			return 0;
		}
		else
			return -1;
	}
}

/****************************************/
/* init_console:			*/
/*					*/
/* this routine initializes the console	*/
/* port for operation in the polled	*/
/* mode, interrupts disabled.		*/
/****************************************/
init_console(baud)
int baud;
{
	SCCinit(CONSOLE,baud);
}


/****************************************/
/* SCCget:				*/
/*					*/
/* Get a character from port.		*/
/****************************************/
unsigned char
SCCget(port)
    volatile struct SCCport *port;
{
	unsigned char c;

	while ( !SCCinrdy(port) ){
		;	/* Wait for a character to be present */
	}
	c = port->data;
	wait_uart();
	return c;
}


/****************************************/
/* SCCput:				*/
/*					*/
/* Send a character to port.		*/
/****************************************/
void
SCCput(port, c)
    volatile struct SCCport *port;
    char c;
{
	while ( !SCCoutrdy(port) ){
		;	/* Wait for transmit buffer to empty */
	}
	port->data = c;
	wait_uart();
}

/****************************************/
/* SCCoutrdy:				*/
/*					*/
/* Return nonzero if transmit buffer of	*/
/* port is clear.			*/
/****************************************/
int
SCCoutrdy(port)
    volatile struct SCCport *port;
{
	int i;

	port->control = 0;
	wait_uart();
	i = port->control & 0x04;
	wait_uart();
	return i;
}

/****************************************/
/* SCCinrdy:				*/
/*					*/
/* Return nonzero if there is a		*/
/* character in the input register.	*/
/****************************************/
int
SCCinrdy(port)
    volatile struct SCCport *port;
{
	int i;

	port->control = 0;
	wait_uart();
	i = port->control & 0x01;
	wait_uart();
	return i;
}


/****************************************/
/* SCCreset:				*/
/*					*/
/* Reset a serial port.			*/
/****************************************/
SCCreset(port)
    volatile struct SCCport *port;
{
	port->control = 0x00;
	wait_uart();
	port->control = 0x09;
	wait_uart();
	port->control = ((port==SCC_PORTA)) ? 0x80 : 0x40;
	wait_uart();
}

/****************************************/
/* SCCbaud:				*/
/*					*/
/* Change the baud rate for serial port.*/
/* baud = freq/( 2 * (time constant+2) )*/
/* time_constant=( Freq/(2*baud))-2	*/
/*					*/
/****************************************/
SCCbaud(port,baud)
    volatile struct SCCport *port;
    int baud;
{
	int tc; 

	tc = (PCLK / (baud * 2 *16)) - 2;
	port->control = 0x0c;
	wait_uart();
	port->control = tc;
	wait_uart();
	port->control = 0x0d;
	wait_uart();
	port->control = tc >> 8;
	wait_uart();
}

/*
 *	The total size of the uart init control data
 *	It is declared in startup.s.  Whenever the control
 *	data is changed, remember to update in here
 */
#define	UART_CMD_DATA_SIZE	18
/****************************************/
/* SCCinit:				*/
/*					*/
/*  Initailizes port to known state.	*/
/****************************************/
void
SCCinit(port,baud)
volatile struct SCCport *port;
int baud;
{
#ifdef kkkkkkk
	static unsigned char cmds[] = {
	    /*	wreg#	value					*/
	    /*	-----	-----					*/
		0x03,	0xc0,	/* 16x clock, 1 stop bits	*/
		0x04,	0x44,	/* Read 8 bit data, auto enabled*/
		0x05,	0xe2,	/* Write 8 bit data use DTR	*/
		0x0b,	0xd2,	/* TxClk = RxClk = Baud Rate Gen*/
		0x0c,	0x12,
		0x0d,	0x00,
		0x0e,	0x05,	/* Start Baud Rate Generator	*/
		0x03,	0xc1,	/* Enable Receiver		*/
		0x05,	0xea,	/* Enable Transmitter		*/
	};
#endif
	int i;
	int tc; 
	extern	unsigned char UartCmdData[];

	data_present = 0;
	SCCreset(port);

	eat_time(80);

	for(i = 0; i < UART_CMD_DATA_SIZE; i++)
	{
		port->control = UartCmdData[i];
		wait_uart(); /* wait for 15 cycles before start next cmd */
	}
	SCCbaud(port, baud);
	eat_time(80);
}

wait_uart()
{
	int 	i;
	volatile shrt	dip;

	for(i = 0; i != 2; i++)
		dip = *(shrt *)DIPIO;
}

/*************************************************************
** These routines are in support of the new debugger.
** Frank Salzmann, 3 May, 1993
*************************************************************/

uartgetc()
{
	char c;

	while (!SCCinrdy(CONSOLE))
		;

	c = uart_data_in(CONSOLE);

	return c;
}

uartputc(char c)
{
	while (!SCCoutrdy(CONSOLE))
		;

	uart_data_out(CONSOLE, c);

	return c;
}
