#include "com.h"
#include "cham.h"

#define	ASY_WAIT	100	/* waiting time for reception */
#define ASY_SIZE	600	/* maximum size of data buffer */

extern	int	rxlen ;

/*********************************************************
File : asy_tsk.c
Date : December 28th 1989
Author : Gilles Lejeune
Desc : Protocol task. Running on port B in asynchronous
**********************************************************/
 

main()
{
struct	ASC_CTRL	encode ; /* async init structure */
int	ret ;			 /* returned value */
int	messtype ;		 /* message type */
char	*pdata ;		 /* data pointer */
MB_MESS	mess_st ;		 /* communication structure */
MB_MESS	*pmess = &mess_st ;	 /* pointer on communication structure */
int	dtlen ;			 /* data length */

/*--- Initialization of init structure */

encode.bitrate	=	B9600 ;
encode.parity	=	NONE ;
encode.stop	=	STOP1 ;
encode.data	=	DATABIT8 ;
encode.duplex	=	HALF ;
encode.block	=	CHARMODE ;
encode.eob	=	0x40 ;

pmess->port = PORT_B ;

/*--- create mail boxes ( 1 pipe ) */

if ( com_crpmb(pmess->port,1) != 0 )
	{
	puts("Cannot open reception mail box") ;
	exit(0) ;
	}

/*--- Set the used port to port B */

if ( ( ret = setport(PORTB) ) != 0 )
	com_error(pmess->port,ret) ;
	
/*--- Load and start front end processor  software */

if ( ( ret = initp1(DCE,&encode) ) )
	com_error(pmess->port,ret) ;

pdata = NULL ; 

/*--- set protocol task to be ready */

com_setrdy(pmess->port) ;

/*--- main loop */

while(1)
	{

	/*--- check reception pipe */

	if ( (messtype = com_chkmb(pmess) ) >= 0 )
		{

		/*--- Message received */

		switch ( messtype )
			{

			case CT_DATA :	/* data message */
				tx_asy(pmess->pdata,pmess->len) ;
				com_rel(pmess->pdata) ;
				break ;

			case CT_FLUSH :	/* flush message */
				flush() ;
				break ;

			case CT_EXIT :	/* exit message */
				p1reset(1) ;	/* reset interface */
				exit(0) ;
				break ;

			default :
				break ;
			}	 
		}

/*-- get a pointer for the data */

	if ( pdata == NULL )
		{
		if ( (pdata = com_gptr(ASY_SIZE)) == NULL )
			{
			puts("ASY malloc error") ;
			break ;
			}
		} 

	/*--- Check line reception */

	dtlen = receiveWait(pdata,ASY_WAIT) ;
	if ( dtlen > 0 )
		{
		
		/*--- Data received, send them to control task */

		pmess->len = dtlen ;
		pmess->pdata = pdata ;
		pmess->type = CT_DATA ;
		com_snd(pmess) ;
		pdata = NULL  ;
		}
	}
}

/********** Wait with delay for a line reception *********************

This wait routine will divide the delay ( in millisecond ) by 20
and loop for the result of the division. Everytime the program loops,
it will check the reception. If nothing is received, it will pause for
20 milliseconds. If something is received, it will get all the received
characters and return. In addition, the routine wil filter all non
ASCII characters and will strip out the parity bit.

**********************************************************************/ 

receiveWait(pdata,delay)
char	*pdata ;		/* pointer on data */
int	delay ;			/* maximum delay to wait */
{
char	c ;
int	nb,len,esc ;

for(nb = 0,len=0,esc=0 ; (nb <= delay/20) && (esc == 0) ; )
	{
	while(1)	
		{
		receive(&c) ;
		if ( rxlen != 0 )
			{
			esc = 1 ;
			c &= 0x7f ;
			if ( ( c >= 0x20 ) && ( c <= 0x7f ) )
				{
				*pdata++ = c ;
				len++ ;
				}
			}
		else
			break ;
		}
	pause(20+MS) ;
	nb ++ ;
	}
*pdata = 0 ;
return(len) ;
}

/********** transmit data in asyncronous */

tx_asy(ptr,len)
char	*ptr ;		/* data pointer */
int	len ;		/* length of the data to transmit */
{
while(len--)
	{
	while( tready() != 0 )
		pause(10+MS) ;
	transmit(ptr++,1) ;
	}
}
