#include "stdio.h"
#include "video.h"
#include "com.h"

extern long	_stdvt ;

/************************************************************
File : x25_disp.c
Date : Dec 28th 1989
Author : Gilles Lejeune
Desc : list of functions used to display informations during
       the execution of the test

List : 
	disp_init      : display background screen before test
        clears         : clear screen
        movxy          : move cursor position
        disp_x25       : display an X25 message
        disp_x25_error : display an X25 error
        disp_async     : display an asynchronous message
        disp_asy_error : display an asynchronous error
        dispend        : display end of test message 

***************************************************************/

int	cur_line = 1 ;  /* current line of display */

char *pline = "\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262\262" ;


char	*ptraffic = "                                                                                " ;

/******* display init screen ***********************
parameter :
            pstr : pointer on a description string
****************************************************/

disp_init(pstr)
char	*pstr ;
{
int	 i ;

movxy(1,23) ;
putmvt(_stdvt,FWHITE,HILITE,"***** ",pstr," *****",
		NORM,0L) ;
movxy(2,5) ;
putmvt(_stdvt,FGREEN,HILITE,"DUT",0L) ;
movxy(2,13) ;
putmvt(_stdvt,FCYAN,HILITE,"X25 traffic",0L) ;
movxy(2,27) ;
putmvt(_stdvt,FGREEN,HILITE,"CHAMELEON",0L) ;
movxy(2,40) ;
putvt(_stdvt,"CHAMELEON") ;
movxy(2,52) ;
putmvt(_stdvt,FYELLOW,HILITE,"ASYNC traffic",NORM,0L) ;
movxy(2,70);
putmvt(_stdvt,FGREEN,HILITE,"DUT",NORM,0L) ;
movxy(3,1) ;
putmvt(_stdvt,FWHITE,HILITE,0L) ;
putvt(_stdvt,pline) ;
putvt(_stdvt,pline) ;

for(i=4;i!=23;i++)
	{
	movxy(i,1) ;
	putvt(_stdvt,ptraffic) ;
	}
cur_line = 4 ;

}

/******** clear screen *************************/

clears()
{
putmvt(_stdvt,NORM,CLEARS,0L) ;
}

char	*curs_xy = "\033[00;00f" ;

/******* move cursor position *****************
parameters :
	line : line of the cursor ( 1 to 23 )
	col  : column of the cursor ( 1 to 80 )
***********************************************/

movxy(line,col) 
int	line,col ;
{
*(curs_xy+2) = line/10+'0' ;
*(curs_xy+3) = line%10+'0' ;
*(curs_xy+5) = col/10+'0' ;
*(curs_xy+6) = col%10+'0' ;

putvt(_stdvt,curs_xy) ;
}

/******* display X25 message *****************
parameter :
	ptr : pointer on the message string
**********************************************/

disp_x25(ptr)
char	*ptr ;
{
movxy(cur_line,10) ;
putmvt(_stdvt,FCYAN,HILITE,ptr,NORM,0L) ;
if ( cur_line < 21 )
	cur_line++ ;
else
	{
	movxy(4,1) ;
	putvt(_stdvt,"\033[01M") ;
	}
}

/****** display X25 error **********************
parameter :
	ptr : pointer on error message string
************************************************/

disp_x25_error(ptr)
char	*ptr ;
{
movxy(cur_line,10) ;
putmvt(_stdvt,FRED,FLASH,ptr,NORM,0L) ;
if ( cur_line < 21 )
	cur_line++ ;
else
	{
	movxy(4,1) ;
	putvt(_stdvt,"\033[01M") ;
	}
movxy(23,1) ;
putmvt(_stdvt,FGREEN,"Press a key to stop ...",NORM,0L) ;
}

/****** display asynchronous message ***************
parameter :
	ptr : pointer on asynchronous message string
****************************************************/

disp_async(ptr)
char	*ptr ;
{
movxy(cur_line,50) ;
putmvt(_stdvt,FYELLOW,HILITE,ptr,NORM,0L) ;
if ( cur_line < 21 )
	cur_line++ ;
else
	{
	movxy(4,1) ;
	putvt(_stdvt,"\033[01M") ;
	}
}

/****** display asynchronous error *****************************
parameter :
	ptr : pointer on the asynchronous error message string
****************************************************************/

disp_asy_error(ptr)
char	*ptr ;
{
movxy(cur_line,50) ;
putmvt(_stdvt,FRED,FLASH,ptr,NORM,0L) ;
if ( cur_line < 21 )
	cur_line++ ;
else
	{
	movxy(4,1) ;
	putvt(_stdvt,"\033[01M") ;
	}
movxy(23,1) ;
putmvt(_stdvt,FGREEN,"Press a key to stop ...",NORM,0L) ;
}

/****** display end message *************************/

dispend()
{
movxy(cur_line,30) ;
putmvt(_stdvt,FGREEN,FLASH,"Test correct",NORM,0L) ;
if ( cur_line < 21 )
	cur_line++ ;
else
	{
	movxy(4,1) ;
	putvt(_stdvt,"\033[01M") ;
	}
movxy(23,1) ;
putmvt(_stdvt,FGREEN,"Press a key to end the test ...",NORM,0L) ;
}
