#include "test.h"

/****** x25 <---> Pad, test numero 1 *****/

main()
{
char	buf_x25[50],buf_asy[50] ;	/* data buffers */

/*---- test initialization */

init_test("test numero 1") ;

/*--- send X25 Call request, expect Call confirm */

send_x25(PT_CR) ;

if ( expect_x25(PT_CA,2000) != PT_CA )
	{
	x25_error("Confirmation d'appel non recue") ;
	exit(0) ;
	}

/*--- Expect Async communication established mesage */

if ( expect_asy(2000,buf_asy) < 0 )
	{
	asy_error("Pas de reception asynchrone") ;
	exit(0) ;
	}
else if ( strcmp(STR_COM,buf_asy) )
	{
	asy_error("COM non recu") ;
	exit(0) ;
	}

/*--- Send X25 Data, expect X25 receive ready */

send_x25(PT_DT,"TOTO") ;

if ( expect_x25(PT_RR,2000) != PT_RR )
	{
	x25_error("Receive ready non recu") ;
	exit(0) ;
	}

/*--- expect same data from Async port */

if ( expect_asy(2000,buf_asy) < 0 )
	{
	asy_error("Pas de reception asynchrone") ;
	exit(0) ;
	}
else if ( strcmp("TOTO",buf_asy) )
	{
	asy_error("donnees recues incorrectement") ;
	exit(0) ;
	}

/*--- send Async data, expect ( echo ) and X25 data with the same data */

send_asy("TITI\015") ;

if ( expect_x25(PT_DT,2000,buf_x25) != PT_DT )
	{
	x25_error("Paquet de donnees non recu") ;
	exit(0) ;
	}

/*--- send X25 Receive ready */

send_x25(PT_RR) ;

/*----- Echo verification, (optional) 

if ( expect_asy(2000,buf_asy) < 0 )
	{
	asy_error("Pas d'echo donnees recu") ;
	exit(0) ;
	}
else if ( strcmp("TITI",buf_asy) )
	{
	asy_error("Echo donnees recu incorrectement") ;
	exit(0) ;
	}
--------------------------------------*/

/*--- send X25 Clear packet, expect X25 Clear confirmation */

send_x25(PT_CLR) ;

if ( expect_x25(PT_CLC,2000) != PT_CLC )
	{
	x25_error("Clear confirm non recu") ;
	exit(0) ;
	}

/*--- Expect Async string of communication break */

if ( expect_asy(2000,buf_asy) < 0 )
	{
	asy_error("Pas de reception asynchrone") ;
	exit(0) ;
	}
else if ( strcmp(STR_LIB,buf_asy) )
	{
	asy_error("LIB recu incorrectement") ;
	exit(0) ;
	}

/*--- End of test successfull */ 

end_test() ;
}
