
SS#7 ANALYSIS

The SS7ANAL application provides Signalling System 7 (SS#7) 
monitoring and interpretation.


SS#7 MODES

You can configure the Chameleon to use either SS#7 condensed or 
non-condensed mode.  In condensed mode, when multiple identical 
FISUs or LSSUs occur in sequence, only the first of each 255 
FISUs/LSSUs is displayed as an event.  Each 256th identical 
FISU/LSSU is displayed as a new event.  In non-condensed mode, 
all FISUs and LSSUs are displayed.  


SS#7 FUNCTION KEYS

     F1 determines the format of the user data display as 
     one of the following:  

        ASCII
        EBCDIC
        HEXS (hex pairs separated by blank space)
        HEX


     F2 determines the acquisition information display format, 
     with the following options:

        Number     Event number in decimal (default)
        Flags      If condensed mode is off, this displays the 
                   number of flags between events.  If 
                   condensed mode is on, for FISUs and LSSUs, 
                   it indicates the number of identical 
                   sequential FISUs or LSSUs that have occurred 
                   since the preceding displayed event.  
        Time       Event time stamp at the end of the event, in 
                   the format hh:mm:ss ddd ddd (ddd ddd = 
                   .dddddd seconds)
        dTime      Displays the elapsed time between events
        CRC        CRC value and OK if the CRC is good, or 
                   Bad if the CRC is not good
        None       No acquisition information is displayed


     F3 determines what types of events will be displayed:

        M       MSUs are shown
        MS      MSUs and LSSUs are shown
        MSF     MSUs, LSSUs and FISUs are shown
        MSFL    MSUs, LSSUs, FISUs, and lead changes

     F4 determines how the Message Transfer Part (MTP) 
     is interpreted.  The options are:

        MTP+   Message Transfer Part is interpreted 
        MTP"   Message Transfer Part is uninterpreted 
               in the code selected in F1.
        MTP*   Message Transfer Part is displayed interpreted 
               and uninterpreted. 
        MTP-   Message Transfer Part is acquired but 
               not displayed.


     F5 determines how the User Part (UP) is interpreted.

        UP+   User Part is interpreted 
        UP"   User Part is uninterpreted in the code 
              selected in F1.
        UP*   User Part is displayed interpreted and 
              uninterpreted. 
        UP-   User Part is acquired but not displayed.


     F6 is available only when ANSI is the selected 
     SS#7 Standard. It determines how the Transaction 
     Capability (TCAP) is interpreted. TCAP is relevant 
     for MSUs only.  

        TCAP+   TCAP is interpreted 
        TCAP"   TCAP is uninterpreted in the code 
                selected in F1.
        TCAP*   TCAP is displayed interpreted and 
                uninterpreted. 
        TCAP-   TCAP is acquired but not displayed.


     F8 determines the detail level for each interpreted 
     data item.  The options are:

        Detail0    Signaling unit type and Heading Code
        Detail1    Routing Label and Parameter names
        Detail2    Parameter details
        Detail3    (Currently identical to Detail 2)


     F9 determines the display format of data item values.
     Each data item is normally displayed with a caption which 
     identifies the data item, and a value which represents the 
     acquired data.  The format of the value part is determined 
     by this option, as described below.

        Meaning  Documented interpretation of the data 
                 item value
        Offset   Offset of the item from the start of the 
                 acquired data is shown in the format n.m,
                 n = number of bytes and m = number of bits
        Length   Length is the size of the data item in the 
                 in the format n.m,  n = number of bytes 
                 and m = number of bits
        Hex      Data is shown in hexadecimal.
        Decimal  Data is shown in decimal.
        Binary   Data is shown in binary.


     F10 determines if user data is displayed.  

        User+   User data is displayed (default)
        User-   User data is not displayed
        Raw     All traffic is displayed uninterpreted (raw) 
                in the code selected in F1


SS#7 :MERGE COMMAND


The :merge command causes Spare bits to be included in 
the adjacent field.   The syntax for merge is:

     :merge or :merge on      Spare bits included
     :merge off               Spare bits excluded


USER PARTS EDITOR

CTRL Z invokes a User Parts Editor which gives you the ability 
to configure the heading code mnemonics and Routing Label 
Structure for each type of user part.  When the SS#7 Analysis 
application is first started, the built-in User Parts 
configuration is loaded.  This information is hard-coded into 
the Chameleon system.  Once these built-in values are loaded, 
you can invoke the User Parts Editor to change the mnemonic 
table or routing label structure and then save the information 
in a file.  This file can then be loaded, as needed.  

