
WINDOW INTERFACE FUNCTIONS


assignleds  Creates or changes the LEDs for an application.
            assignleds(vtnum, pleds, ledword)
            long vtnum;
            char *pleds;
            long ledword;

            vtnum     Virtual terminal number 

            pleds     Pointer to 80 characters which
                      will appear on the LEDs line.

            ledword   Bits 10-31 are reserved.
                      Bits 0 - 9:  If Bit i = 1, LED i+1 is on.
                                   If Bit i = 0 LED i+1 is off


closeform    Releases the screen from form mode and 
             returns to window mode. 
             closeform(vtnum)
             long vtnum;



closevt    Releases the virtual terminal. 
           closevt(vtnum)
           long vtnum;  


disablecur    Causes the cursor to be invisible on the
              screen (default setting). 
              disablecur(vtnum)
              long vtnum;



enablecur    Causes the cursor to be visible on the screen.  
             enablecur(vtnum)
             long vtnum;


getch     Gets a character from standard input without 
          waiting.  If no character is available, 
          it returns a 0xFF.  When standard input is 
          used (not opened using the openvt() function),
          the vtnum value is in  _stdvt.  The characters 
          are not echoed.
          unsigned char getch(vtnum)
          long vtnum;


getcwt   Gets a character from standard input.  
         It does not return a value until a character
         is available.  If you use this function, you will 
         have to force a key when killing the task from
         the shell.  
         unsigned char getcwt(vtnum)
         long vtnum;

         When stdio is used, the vtnum value is in _stdvt.


openform    Puts the screen in non-window (form) mode 
            of 24 lines and returns the virtual terminal 
            number (vtnum).  It clears the screen and works
            in form mode using putvt() calls.  Only one open
            form is allowed in the system, and therefore 
            this function should be in response to a request
            fromthe user.
            long openform()

            Returns:   0   (virtual terminal number of form)  


openvt     Assigns a virtual terminal to an application.

           long openvt(pname)
           char *pname;

           pname is a 25-character null-terminated string
           which will appear on the window banner. 
           The function returns the virtual terminal number
           (vtnum) which is referenced in other functions.

           The first 10 characters of the string constitute an
           Esc sequence that defines the default foreground 
           and background colors of the window.


prndata   This function sends data to the printer.

          prndata(data)
          char *data;


putvt    This function displays a string on a 
         virtual terminal (window).  

         putvt(vtnum,string)
         long vtnum;
         char *string;

         The string is a maximum of 80 ASCII characters in
         VT100 format.  Esc sequences are defined.


selprn   Selects the parameters for outputing to a printer. 

         selprn (device, br, bits, sb, par)
         long device, br, bits, sb, par;

         The default printer settings are:
 
            Parallel, 9600, 8 bits, 2 Stop bits, Even.
 
         device            1   Parallel
                           0   Serial
 
         br   Baud rate    3   300
                           6   600
                          12   1200
                          24   2400
                          48   4800
                          96   9600
                         192   19200
 
         bits   Data Bits    0   5 bits
                             2   6 bits
                             1   7 bits
                             3   8 bits
 
         sb   Stop bits.     1   1 stop bits
                             2   1.5 stop bits
                             3   2 stop bits
 
         par   Parity        0   None
                             1   Odd 
                             3   Even


WINDOW INTERFACE ESCAPE SEQUENCES


The Chameleon 32 C Escape sequences are a subset of the 
VT100Escape sequences and are listed in the table below.  

Where a value is required for the Escape sequence (indicated
by Pn in the  syntax) enter the ASCII value of the value. 
For example, to move the cursor up 7 seven lines, you
would print the string Esc [ 7 a.  In C you enter 
the following:  

      printf("\033[7a")

      where \033 represents the Esc key in octal:

      Esc[Pna        Move cursor up Pn lines
      Esc[Pnb        Move cursor down Pn lines
      Esc[Pn c       Move cursor right Pn columns
      Esc[Pnd        Move cursor left Pn columns
      Esc[Pi;Pnf     Move cursor to line Pi column Pn
      Esc[f          Move cursor home
      Esc[PnL        Insert Pn lines above the cursor
      Esc[PnM        Delete Pn lines 
      Esc[4h         Insert mode
      Esc[4i         Replace mode (default)
      Esc[1P         Delete 1 character
      Esc[0K         Erase to the end of the line
      Esc[0J         Erase to the end of the screen
      Esc[2J         Clear the screen


Screen
Attributes    Use the following command to set the 
              screen attributes (color, highlight, blink, 
              reverse video, etc):

                Esc [ nn m  

                nn is one of these attribute numbers:
 
                0     Reset attributes 
                1     Highlight
                4     Underline
                5     Blink
                7     Reverse
                30     Foreground Black
                31     Foreground Red
                32     Foreground Green
                33     Foreground Yellow
                34     Foreground Blue
                35     Foreground Magenta
                36     Foreground Cyan
                37     Foreground White
                40     Background Black
                41     Background Red
                42     Background Green
                43     Background Yellow
                44     Background Blue
                45     Background Magenta
                46     Background Cyan
                47     Background White

