
AUX SERIAL PORT 2 LIBRARY


initporta    Initializes the Chameleon 32 Aux Serial Port 2 to 
             transmit and receive data. 
 
               #include "paval.h" 
               int initporta (stopbit,bitchar, bitrate, parity) 
               long stopbit; 
               long  bitchar; 
               long  bitrate; 
               long  parity;
 
               stopbit     ST1       (1 stop bit) 
                           ST15      (1.5 stop bits) 
                           ST20      (2 stop bits)
 
               bitchar   DB5         (5 data bits) 
                         DB6         (6 data bits) 
                         DB7         (7 data bits) 
                         DB8         (8 data bits)
 
               bitrate   F110        (110 bits per second) 
                         F300        (300 bits per second) 
                         F120        (1200 bits per second) 
                         F240        (2400 bits per second) 
                         F480        (4800 bits per second) 
                         F960        (9600 bits per second) 
                         F192        (19200 bits per second)
 
               parity    PANO        (No parity) 
                         PAEV        (Even parity) 
                         PAOD        (Odd parity)
 
               Returns      0     Successful 
                           -1     Parameter error



sndpa     Transmits data using Aux Serial Port 2, after
          port has been initialized.  

          #include "paval.h"
          int sndpa (ptr, nb, timeout)
          char     *ptr;          /*user buffer pointer*/
          long      nb;            /*number of bytes*/
          long     timeout;      /*timout value*/

          ptr is a pointer to a buffer containing the data 
          to transmit.  nb is the number of bytes of data 
          to transmit.  timeout is the amount of time to wait 
          for the other device to receive the data.  
          It is in millisecond units.

          Returns     nb     Number of bytes transmitted
                      0     Time out
                     -1     Parameter error


recpa     Receives data using Aux Serial Port 2, after
          port has been initialized.  

          #include "paval.h"
          int recpa (ptr, timeout)
          char     *ptr;
          long     timeout;

          ptr is a pointer to a buffer to put the rec'd data.  

          timeout is the amount of time (in milliseconds)
          to wait to receive data data  units.  
          If 0, the Chameleon does not wait, but returns 
          the number of characters currently in the reception 
          buffer.  If > 0, the function immediately returns 
          the number of characters currently in the reception 
          buffer.  However, if the reception buffer is empty, 
          it waits the timeout period for reception, 
          before returning the number of bytes in the buffer. 

          Returns     nb     Number of bytes received
                       0     Time out 
                      -1     Parameter error


rstdrv    Flushes the driver reception buffer. 

          #include "paval.h"
          rstdrv()
