BASIC RATE INTERFACE (BRI) SETUP/RUNTIME PAGES

The BRI Setup menu enables you to configure the BRI for your 
testing application.  To access the setup menu, press F7 Physicl 
in the Chameleon main configuration menu.

The BRI runtime page enables you to monitor the BRI and change 
the configuration while your application is running.  To access 
the BRI runtime page, start the BASIC application in the 
Applications Selection menu.

The BRI Setup and runtime display the same parameters, as 
described below.  Note that the parameters marked with asterisks 
(*) cannot be changed at runtime.


*MODE    Selects a layer 1 mode for the Basic Rate Interface.  

         Simulate     Simulates layer 1 as an NT or as a TE.  
         Monitor      Monitors layer 1.


*DEVICE  Available only if Mode is Simulate.  Selects the type 
         of device to simulate:

         NT     Network Termination (default)
         TE     Terminal Endpoint


CHANNEL
SELECTION    Specifies on which channel to run the upper level 
             (above layer 1) protocol software. This software 
             can be any of the standard Chameleon packages:

             B1
             B2
             D (default)


*LAYER 1   Selects an option for layer 1 activation:

           Interactive   At runtime, interactive transmission 
                         of signals is possible.  
                         No automatic activation is done. 
           Automatic     When Layer 1 is deactivated, or goes
                         to error state, the system reactivates.


CHANNEL B1    Available only if Channel Selection is B2 or D. 
              See options under Channel B2.


CHANNEL B2   Available only if Channel Selection is B1 or D. 

             Options for the Channel B1 and B2 parameters are:
     
             Milliwatt   Inserts a digital milliwatt (0dBm, 
                         1004 Hz u-law, or 1020 Hz A-law) in 
                         the channel.  Simulation only.
             Codec       Allows you to connect a handset using 
                         Codec to the Basic Rate Interface.
             Idle        Idles the channel with all 1s data.
             Ext B       B channel available at the BRI Ext B 
                         Interface (RS422 compatible).


TRANSMIT 
SIGNAL     Enables you to select Layer 1 signals for additional 
           test purposes.


When the Chameleon is simulating an NT, Transmit Signals are:
        
DR    Deact_Request        Deactivate the link (Layer 1)
SSp   Send_Single_pulses   Sendsa test signal (4 KHZ)
RSYD  Resynchronization    Try to re-synchronize the line
ARN   Send_Info_2          Send an Info 2 signal
ARL   Send_I2_Test_loop2   Send test sequence & loopback (96kHZ)
AI    Send_Info_4          Send Info 4 signal
AIL   Send_I4_Test_loop2   Send test sequence & loopback (96kHZ)
NTA   Activate_NT          Execute activation sequence
DIAG  Diagnostics          Display add'l Transmit commands

----------The NT Status is as follows:-------------

RIM   No_Clock_Signal           LSL   Lost_Signal_Level
RSYUN Resynchronization         EI    Error
ARU   Receiving Info_1          UND   Undefined
AIU   Receiver_Synchronized


When the Chameleon is simulating a TE, Transmit signals are:

TIM   Timing               Clocks Module Interface
RS    Reset                Resets the ISDN Controller chip
SSP   Send_Single_Pulses   Transmits single pulses
TM    Test_Mode            Transmits continuous pulses
AR8   Activate_Priority 8  Activation instr, D Ch priority=8
AR10  Activate_Priority10  Activation instr, D Ch priority=10
ARL   Activate_Test_Loop3  Activates Test Loop 3
DIU   Deactivate           Module interface is shut down
TEA   Activate_TE          Executes activation sequence
DIAG  Diagnostics          Displays add'l Transmit signals

----------The TE Status is as follows:-------------

PU    Power_Up                     DR    Deactivate_Request
SD    Slip_Detected                DIS   Disconnected
EI    Error                        RSYD  Resynchronizing
ARD   Receiving_Info_2             TI    Test_Mode
ATI   Level_Received_Test_Loop     AI 8  Info-4_Priority 8/9 
AI 10 Info-4_Priority 10/11        DID   Quiescent_State
UNDF  Undefined

  
BIT 
INVERSION     If ON, inverts the data bits when a B channel is 
              chosen for Channel Selection.  This feature is 
              supported only on machines with BRI Board
              (805-0259), Revision F.  


NT POWER     Specifies the type of power provided from the NT 
             to the TE.  Supported only on machines with BRI
             Board (805-0259), Revision F. 

             SCR1Nor    Power source 1 under normal conditions
             SCR1Rev    Power source 1 under emergency 
                        conditions  (reverses polarity)
             SCR2Nor    Power source 2 under normal conditions
             SCR2Rev    Power source 2 under emergency
                        conditions  (reverses polarity)
             Off        NT power not supplied


DTMF NUMBER    Causes the Chameleon to generate the Dual Tone 
               Multi-Frequency (DTMF) tones corresponding to 
               the numbers entered in the field.  Relevant 
               only when the Codec unit is selected for a B 
               Channel and is supported only on machines with 
               BRI Board (805-0259), Revision F.  You can 
               enter a maximum of 20 digits.  The Chameleon 
               generates the DTMF tones  when the arrow cursor 
               is moved from the DTMF field.  For this reason, 
               the following is recommended:

               -Enter the DTMF number as the last parameter 
               -If DTMF is not being used, leave it blank



