C MULTI-LINK LAPD LIBRARY Filename:  libmlapd.a 


FIND_LINK       Returns the number of the lowest link matching
                the specified SAPI/TEI/TGI values.
                int find_link(sapi,tei,tgi)
                int sapi, tei, tgi;
                sapi  0 - 255 (SAPI > 63 = don't care)
                tei   0 - 255 (TEI > 127 = don't care)
                tgi  0 - 255  0 - 255 (TGI > 15 = don't care)
                Returns:   0 - 63    Matching link number
                           -1        No match found


GET_FREELINK()   Gets the number of first disabled link.
                 int get_freelink()
                 Returns:   0 - 63    Disabled link number
                           -1         No free links available
                           -2         initp1 not performed

GET_FWAITING   Gets the number of I-frames waiting to be
               transmitted on link lnkn.
               int get_fwaiting (lnkn)
               char lnkn;    0 - 63
               Returns:      0 - 7  Number of I-frames 

GET_LINK()     Gets the number of the link which is currently
               under user control.
               int get_link()
               Returns:   0 - 63   Current link number
                           -1      initp1 not performed

GET_LNKSAPI    Gets the SAPI value for link lnkn.
               int get_lnksapi (lnkn)
               char lnkn;   0 - 63
               Returns:     0 - 63   SAPI value 
                            >  63    Disables link 

GET_LNKTEI     Gets the TEI value for link lnkn.
               int get_lnktei (lnkn)
               char lnkn;   0 - 63
               Returns:     0 - 127    TEI value 
                            > 127      Disables link 

GET_LNKTGI     Gets the TGI value for link lnkn.
               int get_lnktgi (lnkn)
               char lnkn;   0 - 63
               Returns:     0 - 14    TGI value of lnkn
                            15 -255   TGI use is disabled 
                                      (link is not disabled)

GET_MESWAITING   Gets number of messages waiting to be 
                 received from the FEP.
                 int get_meswaiting ()
                 Returns:    0 - 32    Number of messages 


GET_RLINK()    Gets the number of the link which sent the last
               received message.  
               int get_rlink()
               Returns:   0 - 63   Current link number
                           -1      No messages received yet
                           -2      initp1 not performed

GET_RNTEI     Dummy function to maintain compatibility
              with existing single link LAPD programs that
              are being upgraded to Multi-Link LAPD.  This
              function always returns zero.
              int get_rntei (val)
              int  val;

GET_RSAPI     Dummy function to maintain compatibility
              with the existing single link LAPD programs
              that are being upgraded to Multi-Link LAPD.
              This function always returns zero.
              int get_rsapi (val)   
              int val;

GET_RXSTAT()   Gets the low order byte of the frame status byte
               frstat for the last received message.
               char get_rxstat()
               Returns:   0-0xC3    frstat value  
                          0xFF   No messages received yet
                          0xFE   initp1 not performed
  
GET_SAPI()       Gets the SAPI  value of the link currently
                 under user control.
                 int get_sapi()
                 Returns:   0 - 255    SAPI for current link

GET_SCONFIG ()   Returns a copy of the current control
                 configuration byte.
                 int get_sconfig ()

GET_SIM ()       Returns a copy of of the network/subscriber
                 selection.
                 int get_sim ()
                 Returns:   0      Network 
                            1      Subscriber

GET_TEI()        Gets the TEI of the link currently under user
                 control.
                 int get_tei()
                 Returns:   0 - 255    TEI number

GET_TGI()        Gets the TGI of the link currently under user
                 control.
                 int get_tgi()
                 Returns:   0 - 14    TGI value of current link
                            15 - 255  Use of TGI is disabled

GET_WINDOW       Gets the number of outstanding I-frames on
                 link number lnkn.
                 int get_window (lnkn)
                 char lnkn;   0 - 63
                 Returns:   0 - 7       Number of I-frames

INITP1           initp1 loads the FEP code for the selected
                 library and starts simulation.  This is 
                 identical to start_sim, but is inlcuded to
                 to provide downward compatibility with the
                 single link LAPD library.
                 int initp1 (interface, sta, encode, bitrt)
                 int interface, sta, encode;
                 long  bitrt;
                 interface   0      V-type interface (DCE)
                             1      V-type interface (DTE)
                             2      ISDN interface
                 sta         0      NETWORK 
                             1      SUBSCRIBER 
                 encode      0      NRZ
                             1      NRZI 
                 bitrt       50 - 64000. 

LINK_STAT       Gets the current state of link n.
                int link_stat(n)
                char n;   0 - 63
                Returns:   0 - 9   Current state of link

                     0    Link Disconnected
                     1    Link Connection Requested
                     2    Frame Rejected
                     3    Disconnect Requested 
                     4    Information Transfer
                     5    Local Station Busy
                     6    Remote Station Busy
                     7    Local & Remote Station Busy
                     8    Remote Stn not Responding
                     9    Link Disabled

RECEIVE        Receives a message from the FEP 
               int receive(dest_addr)
               char *dest_addr;

S_N200         Sets the maximum number of retries (N200). 
               int s_n200 (val)
               int val;   1 -  255
               Returns:   0    Successful

S_N201         Sets the maximum length for an I-frame (N201). 
               int s_n201 (val)
               int val;   1 - 512
               Returns:   0    Successful

S_T200        Sets the time allowed for the remote station
              to respond (T200).
              int s_t200 (val)
              int val;   0 - 255  (0 = timer diabled)
              Returns:   0    Successful

S_T203        Sets the maximum time between frames (T203). 
              int s_t203 (val)
              int val;   0 - 255 (0 = timer diabled)
              Returns:   0    Successful

SET_LINK      Puts link n under user control.  
              int set_link(n)
              char n;   0 - 63
              Returns:    0    Successful
                         -1    Parameter out of range
                         -2    initp1 not performed
                         -3    Timeout

SET_NET ()
               Sets the simulation side to Network.   
               int set_net ()

SET_RNTEI      Dummy function to maintain compatibility 
               with existing LAPD link programs that are 
               being upgraded to Multi-Link LAPD.
               int set_rntei (val, tei)
               int val, tei;
               This function always returns zero.

SET_RSAPI      Dummy function to maintain compatibility 
               with existing LAPD programs that are 
               being upgraded to Multi-Link LAPD.
               int set_rsapi (val, sapi)
               int val, sapi;
               This function always returns zero.

SET_SAPI       Sets the SAPI value for the link under 
               user control.
               int set_sapi(v)
               char v;
               Accepted range of v is 0 - 255.  
               A value over 63 disables the link.
               Returns:   0    Successful
                         -1    Parameter out of range
                         -2    initp1 not performed
                         -3    Timeout

SET_SCONFIG   Sets the value of the control configuration byte
              int set_sconfig (byte)
              int byte;
              Returns:   0    Successful

SET_SUB ()     Set the simulation side to Subscriber.  
               int set_sub ()

SET_TEI        Sets the TEI value of the selected link.
               int set_tei(v)   
               char v;
               The accepted range of v is 0 to 255.
               A value over 127 disables the link.
               Returns:  0    Successful
                        -1    Parameter out of range
                        -2    initp1 not performed
                        -3    Timeout

SET_TGI        Sets the TGI value of the selected link.
               int set_tgi(val)   
               char val;        
               The accepted range of v is 0 to 255, as follows:

               0 - 14     Valid TGI value
               15 - 255   Disables use of TGI (does not disable
                          the link)
               Returns:  0    Successful
                        -1    Parameter out of range
                        -2    initp1 not performed
                        -3    Timeout

SET_WINDOW     Sets the maximum number of outstanding frames
               on each link.  
               int set_window (val)
               int val;   1 - 7
               Returns:   0    Successful

SETFLG         Selects an interframe fill pattern.
               int setflg (flag)
               int flag;   0   0x7E fill
                           1   0xFF fill
               Returns:    0   Successful

SLOF ()        Sends a DISC and waits for a UA frame. 
               int slof ()
               Returns:   0   Successful

SLON ()        Sends a SABME and waits for a UA frame. 
               int slon ()
               Returns:   0    Successful

SRCH_LNK       Returns the  number of lowest link matching
               the specified SAPI/TEI.  To search for a link by 
               specifying SAPI, TEI, and TGI, refer to the 
               find_link function.
               int srch_lnk(sapi,tei)
               Returns:    0 - 63    Number of lowest link 
                             -1       No match found

START_SIM        start_sim loads the FEP code for the selected
                 library and starts simulation.  This is 
                 identical to the initp1 function.
                 int start_sim (interface, sta, encode, bitrt)
                 int interface, sta, encode;
                 long  bitrt;
                 interface   0      V-type interface (DCE)
                             1      V-type interface (DTE)
                             2      ISDN interface
                 sta         0      NETWORK 
                             1      SUBSCRIBER 
                 encode      0      NRZ
                             1      NRZI 
                 bitrt       50 - 64000
 
STATUS()       Gets the state of the selected link.
               int status()
               Returns:   0 - 9    (see LINK_STAT table above)

TRANS       Transmits a frame.
            int trans (frame,address,len)
            int frame, len;
            char *address
            frame selects type of frame to transmit:
               0x80   I-frame   Sequenced (numbered) I-frame
               0x81   UI        Unnumbered I-frame (NSI)
               0x82   XIDC      XID command frame
               0x83   XIDR      XID response frame
            address is a pointer to the first byte of the 
            message to be transmitted.  len is the length
            of the message to be transmitted.  
            Returns:    0   Successful

TRANSMIT    Transmits a message in a sequenced I-frame.
            int transmit (xloc, xlen)
            char *xloc;
            int xlen;
            xloc is a pointer to the first byte of the 
            message to be transmitted.  xlen is the length of 
            the message to be transmitted.  

TRUI        Transmits a message in a UI frame. 
            int trui (xloc, xlen)
            char  *xloc;
            int  xlen;
            xloc is a pointer to the first byte of the 
            message to be transmitted.  xlen is the 
            length of the message to be transmitted.  

TRXCNI      Transmits an XID command frame with no data field.
            int trxcni ()
            int v;
            Returns:   0    Successful

TRXIDC      Transmits a message in an XID command frame. 
            int trxidc (xloc, xlen)
            char *xloc;
            int   xlen;
            xloc is a pointer to the first byte of the
            message to be transmitted.  xlen is the 
            length of the message to be transmitted.  

TRXIDR      Transmits a message in an XID response frame. 
            int trxidr (xloc, xlen)
            char *xloc; 
            xloc is a pointer to the first byte of the 
            message to be transmitted.  xlen is the 
            length of the message to be transmitted.  

TRXRNI      Transmits an XID response frame with no data field.
            int trxrni ()
            int v;
            Returns:   0    Successful

